/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier;

import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.ExecutorWithProgress;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerifier;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a8\u0006\t"}, d2={"getConcurrencyLevel", "", "runSeveralVerifiers", "", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "verifiers", "Lcom/jetbrains/pluginverifier/PluginVerifier;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginVerifierRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginVerifierRun.kt\ncom/jetbrains/pluginverifier/PluginVerifierRunKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,57:1\n1549#2:58\n1620#2,3:59\n1#3:62\n17#4,6:63\n*S KotlinDebug\n*F\n+ 1 PluginVerifierRun.kt\ncom/jetbrains/pluginverifier/PluginVerifierRunKt\n*L\n27#1:58\n27#1:59,3\n30#1:63,6\n*E\n"})
public final class PluginVerifierRunKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PluginVerificationResult> runSeveralVerifiers(@NotNull PluginVerificationReportage reportage, @NotNull List<PluginVerifier> verifiers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        Intrinsics.checkNotNullParameter(verifiers, "verifiers");
        if (verifiers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ExecutorWithProgress executor2 = new ExecutorWithProgress("verifier", PluginVerifierRunKt.getConcurrencyLevel(), true, (Function1)new Function1<ExecutorWithProgress.ProgressData<PluginVerificationResult>, Unit>(reportage){
            final /* synthetic */ PluginVerificationReportage $reportage;
            {
                this.$reportage = $reportage;
                super(1);
            }

            public final void invoke(@NotNull ExecutorWithProgress.ProgressData<PluginVerificationResult> progressData) {
                Intrinsics.checkNotNullParameter(progressData, "progressData");
                PluginVerificationResult pluginVerificationResult = progressData.getResult();
                Intrinsics.checkNotNull(pluginVerificationResult);
                PluginVerificationResult result2 = pluginVerificationResult;
                int n = progressData.getFinishedNumber();
                int n2 = progressData.getTotalNumber();
                String string = "%.1f";
                Object[] objectArray = new Object[]{(double)progressData.getElapsedTime() / (double)1000};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                this.$reportage.logVerificationStage("Finished " + n + " of " + n2 + " verifications (in " + string2 + " s): " + result2.getVerificationTarget() + " against " + result2.getPlugin() + ": " + result2.getVerificationVerdict());
            }
        });
        Iterable $this$map$iv = verifiers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void verifier;
            PluginVerifier pluginVerifier = (PluginVerifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ExecutorWithProgress.Task<PluginVerificationResult>(verifier.getVerificationDescriptor().toString(), () -> PluginVerifierRunKt.runSeveralVerifiers$lambda$3$lambda$2((PluginVerifier)verifier, reportage)));
        }
        List tasks2 = (List)destination$iv$iv;
        return executor2.executeTasks(tasks2);
    }

    public static final int getConcurrencyLevel() {
        Integer fromProperty;
        String string = System.getProperty("intellij.plugin.verifier.concurrency.level");
        Integer n = fromProperty = string != null ? StringsKt.toIntOrNull(string) : null;
        if (fromProperty != null) {
            if (!(fromProperty > 0)) {
                boolean bl = false;
                String string2 = "Invalid concurrency level: " + fromProperty;
                throw new IllegalStateException(string2.toString());
            }
            return fromProperty;
        }
        long availableMemory = Runtime.getRuntime().maxMemory();
        long availableCpu = Runtime.getRuntime().availableProcessors();
        long maxByMemory = availableMemory / (long)1024 / (long)1024 / (long)200;
        return (int)Math.max(8L, Math.min(maxByMemory, availableCpu));
    }

    private static final PluginVerificationResult runSeveralVerifiers$lambda$3$lambda$2(PluginVerifier $verifier, PluginVerificationReportage $reportage) {
        Intrinsics.checkNotNullParameter($verifier, "$verifier");
        Intrinsics.checkNotNullParameter($reportage, "$reportage");
        PluginVerificationResult verificationResult = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        verificationResult = $verifier.loadPluginAndVerify();
        long verificationTime = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to("plugin.verification.duration", Duration.ofMillis(verificationTime))};
        $reportage.reportTelemetry(verificationResult.getPlugin(), new PluginTelemetry(pairArray));
        if (verificationResult instanceof PluginVerificationResult.Verified) {
            $reportage.reportTelemetry(verificationResult.getPlugin(), ((PluginVerificationResult.Verified)verificationResult).getTelemetry());
        }
        $reportage.reportVerificationResult(verificationResult);
        return verificationResult;
    }
}

