/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.CharSequenceComparator;
import com.jetbrains.plugin.structure.base.utils.CharSequencesKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.ResourceBundlesKt;
import com.jetbrains.plugin.structure.base.utils.charseq.CharBufferCharSequence;
import com.jetbrains.plugin.structure.base.utils.charseq.CharReplacingCharSequence;
import com.jetbrains.plugin.structure.base.zip.ZipHandlerKt;
import com.jetbrains.plugin.structure.base.zip.ZipResource;
import com.jetbrains.plugin.structure.jar.Jar$WhenMappings;
import com.jetbrains.plugin.structure.jar.JarArchiveException;
import com.jetbrains.plugin.structure.jar.JarEntryResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarKt;
import com.jetbrains.plugin.structure.jar.Packages;
import com.jetbrains.plugin.structure.jar.descriptors.Descriptor;
import com.jetbrains.plugin.structure.jar.descriptors.ModuleDescriptorReference;
import com.jetbrains.plugin.structure.jar.descriptors.PluginDescriptorReference;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002]^B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000eJ\u000e\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u000eJ\u0018\u00105\u001a\u0002062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\u00192\u0006\u00102\u001a\u00020\u000eH\u0002J\u001c\u0010:\u001a\u00020/2\u0006\u00102\u001a\u00020\f2\n\u0010;\u001a\u00060\fj\u0002`\u0019H\u0002J \u0010<\u001a\u00020/2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\fH\u0002J\u0014\u0010E\u001a\u00020/2\n\u0010F\u001a\u00060\fj\u0002`\u0019H\u0002J\u0006\u0010G\u001a\u00020\u0000J\u0012\u0010H\u001a\u0004\u0018\u00010\u000e2\u0006\u0010I\u001a\u00020\u000eH\u0002J \u0010J\u001a\u0002012\u0018\u0010K\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002010LJ9\u0010M\u001a\u0004\u0018\u0001HN\"\u0004\b\u0000\u0010N2\u0006\u00102\u001a\u00020\u000e2\u001c\u0010O\u001a\u0018\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\fj\u0002`\u0019\u0012\u0004\u0012\u0002HN0L\u00a2\u0006\u0002\u0010PJ\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010R\u001a\u00020\u0003H\u0002J \u0010S\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\fH\u0002J\u0010\u0010W\u001a\u00020\f2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010X\u001a\u00020\f2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010Y\u001a\u00020/2\u0006\u0010=\u001a\u00020>H\u0002J\f\u0010Z\u001a\u000201*\u00020@H\u0002J\f\u0010[\u001a\u000201*\u00020\u0003H\u0002J\f\u0010\\\u001a\u00020B*\u00020@H\u0002R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\fj\u0002`\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R)\u0010\u001d\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001b\u0010$\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b,\u0010\u0013\u00a8\u0006_"}, d2={"Lcom/jetbrains/plugin/structure/jar/Jar;", "Ljava/lang/AutoCloseable;", "jarPath", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "entryResolvers", "", "Lcom/jetbrains/plugin/structure/jar/JarEntryResolver;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;Ljava/util/List;)V", "_bundleNames", "", "", "", "", "bundleNames", "", "", "getBundleNames", "()Ljava/util/Map;", "classes", "getClasses", "()Ljava/util/Set;", "classesInJar", "Ljava/util/TreeMap;", "Lcom/jetbrains/plugin/structure/jar/PathInJar;", "descriptorCandidates", "Lcom/jetbrains/plugin/structure/jar/descriptors/Descriptor;", "getDescriptorCandidates", "entryResolverResults", "Lcom/jetbrains/plugin/structure/jar/JarEntryResolver$Key;", "", "", "getEntryResolverResults", "getJarPath", "()Ljava/nio/file/Path;", "packages", "Lcom/jetbrains/plugin/structure/jar/Packages;", "getPackages", "()Lcom/jetbrains/plugin/structure/jar/Packages;", "packages$delegate", "Lkotlin/Lazy;", "serviceProviderPaths", "serviceProviders", "getServiceProviders", "serviceProviders$delegate", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "getFileSystem", "Ljava/nio/file/FileSystem;", "expectedClients", "", "getPath", "handleClass", "classPath", "handleDescriptorCandidate", "zipEntry", "Ljava/util/zip/ZipEntry;", "path", "Lcom/jetbrains/plugin/structure/jar/Jar$PathWithinJar;", "descriptorType", "Lcom/jetbrains/plugin/structure/jar/Jar$DescriptorType;", "handleResourceBundle", "resourceBundleName", "handleServiceProvider", "serviceProviderPath", "init", "parseServiceImplementationLine", "line", "processAllClasses", "processor", "Lkotlin/Function2;", "processClassPathInJar", "T", "handler", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "readServiceImplementationNames", "metaInfServiceProviderPath", "resolve", "separator", "", "suffix", "resolveBundleName", "resolveClass", "scan", "hasServiceProviders", "isParsableServiceImplementation", "matchesDescriptor", "DescriptorType", "PathWithinJar", "structure-base"})
@SourceDebugExtension(value={"SMAP\nJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jar.kt\ncom/jetbrains/plugin/structure/jar/Jar\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n457#2:276\n403#2:277\n361#2,7:287\n361#2,7:295\n1238#3,4:278\n1855#3:286\n1856#3:294\n167#4,2:282\n169#4:285\n1#5:284\n*E\n*S KotlinDebug\n*F\n+ 1 Jar.kt\ncom/jetbrains/plugin/structure/jar/Jar\n*L\n64#1:276\n64#1:277\n148#1,7:287\n161#1,7:295\n64#1,4:278\n146#1:286\n146#1:294\n103#1,2:282\n103#1:285\n*E\n"})
public final class Jar
implements AutoCloseable {
    private final TreeMap<CharSequence, CharSequence> classesInJar;
    @NotNull
    private final Set<CharSequence> classes;
    @NotNull
    private final Lazy packages$delegate;
    private final Map<CharSequence, Set<String>> _bundleNames;
    @NotNull
    private final Lazy serviceProviders$delegate;
    private final Set<CharSequence> serviceProviderPaths;
    @NotNull
    private final Set<Descriptor> descriptorCandidates;
    @NotNull
    private final Map<JarEntryResolver.Key<?>, List<Object>> entryResolverResults;
    @NotNull
    private final Path jarPath;
    private final JarFileSystemProvider fileSystemProvider;
    private final List<JarEntryResolver<?>> entryResolvers;

    @NotNull
    public final Set<CharSequence> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Packages getPackages() {
        Lazy lazy = this.packages$delegate;
        Jar jar2 = this;
        Object var3_3 = null;
        return (Packages)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Set<String>> getBundleNames() {
        void $this$mapKeysTo$iv$iv;
        Map<CharSequence, Set<String>> $this$mapKeys$iv = this._bundleNames;
        boolean $i$f$mapKeys = false;
        Map<CharSequence, Set<String>> map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void $dstr$k$_u24__u24;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void var12_12 = $dstr$k$_u24__u24;
            CharSequence k = (CharSequence)var12_12.getKey();
            String string = ((Object)k).toString();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = string;
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string2, entry);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Map<String, Set<String>> getServiceProviders() {
        Lazy lazy = this.serviceProviders$delegate;
        Jar jar2 = this;
        Object var3_3 = null;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Set<Descriptor> getDescriptorCandidates() {
        return this.descriptorCandidates;
    }

    @NotNull
    public final Map<JarEntryResolver.Key<?>, List<Object>> getEntryResolverResults() {
        return this.entryResolverResults;
    }

    @NotNull
    public final Jar init() throws JarArchiveException {
        Jar jar2;
        Jar $this$apply = jar2 = this;
        boolean bl = false;
        try {
            ZipHandlerKt.newZipHandler($this$apply.jarPath).iterate((Function2)new Function2<ZipEntry, ZipResource, Unit>($this$apply){
                final /* synthetic */ Jar $this_apply;

                public final void invoke(@NotNull ZipEntry zipEntry, @NotNull ZipResource zipResource) {
                    Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
                    Intrinsics.checkNotNullParameter(zipResource, "zipResource");
                    if (!zipEntry.isDirectory()) {
                        Jar.access$scan(this.$this_apply, zipEntry);
                    }
                }
                {
                    this.$this_apply = jar2;
                    super(2);
                }
            });
        }
        catch (IOException e) {
            throw (Throwable)new JarArchiveException("JAR archive could not be opened at [" + $this$apply.jarPath + "]: " + e.getMessage() + " ", e);
        }
        return jar2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final boolean processAllClasses(@NotNull Function2<? super String, ? super Path, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        var2_2 = this.getFileSystem(this.jarPath, this.classesInJar.size());
        var3_3 = null;
        try {
            block14: {
                block16: {
                    fs = (FileSystem)var2_2;
                    $i$a$-use-Jar$processAllClasses$1 = false;
                    $this$all$iv = this.classesInJar;
                    $i$f$all = false;
                    if (!$this$all$iv.isEmpty()) break block16;
                    v0 = true;
                    break block14;
                }
                var8_11 = $this$all$iv.entrySet().iterator();
                while (var8_11.hasNext()) {
                    $dstr$className$classFilePath = element$iv = var8_11.next();
                    $i$a$-all-Jar$processAllClasses$1$1 = false;
                    var12_15 = $dstr$className$classFilePath;
                    var13_16 = (CharSequence)var12_15.getKey();
                    var12_15 = $dstr$className$classFilePath;
                    classFilePath = (CharSequence)var12_15.getValue();
                    var12_15 = this.getFileSystem(this.jarPath, 1);
                    var15_18 = null;
                    try {
                        classFs = (FileSystem)var12_15;
                        $i$a$-use-Jar$processAllClasses$1$1$1 = false;
                        it = var18_24 = classFs.getPath(classFilePath.toString(), new String[0]);
                        $i$a$-takeIf-Jar$processAllClasses$1$1$1$1 = false;
                        v1 = it;
                        Intrinsics.checkNotNullExpressionValue(v1, "it");
                        v2 = FileUtilKt.isFile(v1) != false ? var18_24 : null;
                        if (v2 == null) ** GOTO lbl-1000
                        it = var18_24 = v2;
                        $i$a$-let-Jar$processAllClasses$1$1$1$2 = false;
                        if (processor.invoke(className.toString(), it).booleanValue()) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        var16_19 = v3;
                    }
                    catch (Throwable var16_21) {
                        var15_18 = var16_21;
                        throw var16_21;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_15, var15_18);
                    }
                    if (var16_19) continue;
                    v0 = false;
                    break block14;
                }
                v0 = true;
            }
            var4_5 = v0;
        }
        catch (Throwable var4_6) {
            var3_3 = var4_6;
            throw var4_6;
        }
        finally {
            CloseableKt.closeFinally(var2_2, var3_3);
        }
        return var4_5;
    }

    public final boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.getPackages().contains(packageName);
    }

    public final boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.classes.contains(className);
    }

    private final CharSequence getPath(String className) {
        return this.classesInJar.get(className);
    }

    private final FileSystem getFileSystem(Path jarPath, int expectedClients) {
        return this.fileSystemProvider.getFileSystem(jarPath, new JarFileSystemProvider.Configuration(expectedClients));
    }

    @Nullable
    public final <T> T processClassPathInJar(@NotNull String className, @NotNull Function2<? super String, ? super CharSequence, ? extends T> handler) {
        T t2;
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(handler, "handler");
        CharSequence charSequence = this.getPath(className);
        if (charSequence != null) {
            CharSequence charSequence2;
            CharSequence pathInJar = charSequence2 = charSequence;
            boolean bl = false;
            t2 = handler.invoke(className, pathInJar);
        } else {
            t2 = null;
        }
        return t2;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    private final void scan(ZipEntry zipEntry) {
        PathWithinJar path = PathWithinJar.Companion.of(zipEntry);
        if (path.isClass()) {
            this.handleClass(this.resolveClass(path), path.getPath());
        } else if (path.isResourceBundle()) {
            this.handleResourceBundle(this.resolveBundleName(path));
        } else if (this.hasServiceProviders(path)) {
            this.handleServiceProvider(path.getPath());
        } else {
            DescriptorType descriptorType = this.matchesDescriptor(path);
            if (descriptorType != DescriptorType.NO_MATCH) {
                this.handleDescriptorCandidate(zipEntry, path, descriptorType);
            } else {
                Iterable $this$forEach$iv = this.entryResolvers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    void $this$getOrPut$iv;
                    Object t2;
                    JarEntryResolver resolver = (JarEntryResolver)element$iv;
                    boolean bl = false;
                    if (resolver.resolve(path.getPath(), zipEntry) == null) continue;
                    Object it = t2;
                    boolean bl2 = false;
                    Object object2 = this.entryResolverResults;
                    JarEntryResolver.Key key$iv = resolver.getKey();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    object2 = (List)object;
                    object2.add(it);
                }
            }
        }
    }

    private final void handleClass(CharSequence className, CharSequence classPath) {
        ((Map)this.classesInJar).put(className, classPath);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleResourceBundle(CharSequence resourceBundleName) {
        Object object;
        void $this$getOrPut$iv;
        String fullBundleName = ((Object)resourceBundleName).toString();
        Object object2 = this._bundleNames;
        String key$iv = ResourceBundlesKt.getBundleBaseName(fullBundleName);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        object2 = (Set)object;
        object2.add(fullBundleName);
    }

    private final void handleServiceProvider(CharSequence serviceProviderPath) {
        Collection collection = this.serviceProviderPaths;
        collection.add(serviceProviderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> readServiceImplementationNames(Path metaInfServiceProviderPath) {
        Set<String> set;
        if (!this.isParsableServiceImplementation(metaInfServiceProviderPath)) {
            return SetsKt.emptySet();
        }
        AutoCloseable autoCloseable = Files.lines(metaInfServiceProviderPath);
        Throwable throwable = null;
        try {
            Stream lines = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream = lines;
            Intrinsics.checkNotNullExpressionValue(stream, "lines");
            set = SequencesKt.toSet(SequencesKt.mapNotNull(StreamsKt.asSequence(stream), (Function1)new Function1<String, String>(this){
                final /* synthetic */ Jar this$0;
                {
                    this.this$0 = jar2;
                    super(1);
                }

                @Nullable
                public final String invoke(String it) {
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue(string, "it");
                    return Jar.access$parseServiceImplementationLine(this.this$0, string);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return set;
    }

    private final String parseServiceImplementationLine(String line) {
        String serviceImplementation;
        String string = StringsKt.substringBefore$default(line, "#", null, 2, null);
        String it = string = (serviceImplementation = ((Object)StringsKt.trim((CharSequence)string)).toString());
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence.length() > 0 ? string : null;
    }

    private final CharSequence resolve(PathWithinJar path, char separator, CharSequence suffix) {
        CharBuffer pathBuf = path.getPath();
        CharBuffer charBuffer = pathBuf.get(0) == separator ? pathBuf.subSequence(1, pathBuf.length()) : pathBuf;
        Intrinsics.checkNotNullExpressionValue(charBuffer, "if (pathBuf.get(0) == se\u2026lse {\n      pathBuf\n    }");
        CharBuffer noPrefix = charBuffer;
        CharSequence charSequence = suffix;
        CharSequence neitherPrefixNoSuffix = charSequence.length() > 0 && StringsKt.endsWith$default((CharSequence)noPrefix, suffix, false, 2, null) ? (CharSequence)new CharBufferCharSequence(noPrefix, 0, noPrefix.length() - suffix.length()) : (CharSequence)noPrefix;
        return separator == File.separatorChar ? neitherPrefixNoSuffix : (CharSequence)new CharReplacingCharSequence(neitherPrefixNoSuffix, File.separatorChar, separator);
    }

    private final CharSequence resolveClass(PathWithinJar path) {
        if (File.separatorChar == '/') {
            return path.removeSuffix(JarKt.access$getCLASS_SUFFIX$p());
        }
        return this.resolve(path, '/', JarKt.access$getCLASS_SUFFIX$p());
    }

    private final CharSequence resolveBundleName(PathWithinJar path) {
        return this.resolve(path, '.', JarKt.access$getRESOURCE_BUNDLE_SUFFIX$p());
    }

    private final void handleDescriptorCandidate(ZipEntry zipEntry, PathWithinJar path, DescriptorType descriptorType) {
        switch (Jar$WhenMappings.$EnumSwitchMapping$0[descriptorType.ordinal()]) {
            case 1: {
                Collection collection = this.descriptorCandidates;
                PluginDescriptorReference pluginDescriptorReference = new PluginDescriptorReference(this.jarPath, path.getPath());
                collection.add(pluginDescriptorReference);
                break;
            }
            case 2: {
                Collection collection = this.descriptorCandidates;
                ModuleDescriptorReference moduleDescriptorReference = new ModuleDescriptorReference(this.jarPath, path.getPath());
                collection.add(moduleDescriptorReference);
                break;
            }
        }
    }

    private final boolean hasServiceProviders(PathWithinJar $this$hasServiceProviders) {
        CharSequence spPath = this.resolve($this$hasServiceProviders, '/', JarKt.access$getNO_SUFFIX$p());
        return StringsKt.startsWith$default(spPath, (CharSequence)"META-INF/services/", false, 2, null) && CharSequencesKt.occurrences(spPath, '/') == 2;
    }

    private final DescriptorType matchesDescriptor(PathWithinJar $this$matchesDescriptor) {
        if (!$this$matchesDescriptor.isXml()) {
            return DescriptorType.NO_MATCH;
        }
        CharSequence descriptorPath = this.resolve($this$matchesDescriptor, '/', JarKt.access$getNO_SUFFIX$p());
        if (StringsKt.startsWith$default(descriptorPath, (CharSequence)"META-INF/", false, 2, null) && CharSequencesKt.occurrences(descriptorPath, '/') == 1) {
            return DescriptorType.PLUGIN;
        }
        if (CharSequencesKt.occurrences(descriptorPath, '/') == 0) {
            return DescriptorType.MODULE;
        }
        return DescriptorType.NO_MATCH;
    }

    private final boolean isParsableServiceImplementation(Path $this$isParsableServiceImplementation) {
        if (!Files.exists($this$isParsableServiceImplementation, new LinkOption[0])) {
            JarKt.access$getLOG$p().debug("Service provider file {} does not exist", (Object)$this$isParsableServiceImplementation);
            return false;
        }
        if (!FileUtilKt.isFile($this$isParsableServiceImplementation)) {
            JarKt.access$getLOG$p().debug("Service provider file {} is not a regular file", (Object)$this$isParsableServiceImplementation);
            return false;
        }
        return true;
    }

    @NotNull
    public final Path getJarPath() {
        return this.jarPath;
    }

    public Jar(@NotNull Path jarPath, @NotNull JarFileSystemProvider fileSystemProvider, @NotNull List<? extends JarEntryResolver<?>> entryResolvers) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        Intrinsics.checkNotNullParameter(entryResolvers, "entryResolvers");
        this.jarPath = jarPath;
        this.fileSystemProvider = fileSystemProvider;
        this.entryResolvers = entryResolvers;
        this.classesInJar = new TreeMap(CharSequenceComparator.INSTANCE);
        Set<CharSequence> set = this.classesInJar.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "classesInJar.keys");
        this.classes = set;
        this.packages$delegate = LazyKt.lazy((Function0)new Function0<Packages>(this){
            final /* synthetic */ Jar this$0;

            @NotNull
            public final Packages invoke() {
                Packages packages2;
                Packages $this$apply = packages2 = new Packages();
                boolean bl = false;
                Iterable $this$forEach$iv = this.this$0.getClasses();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    CharSequence it = (CharSequence)element$iv;
                    boolean bl2 = false;
                    $this$apply.addClass(it);
                }
                return packages2;
            }
            {
                this.this$0 = jar2;
                super(0);
            }
        });
        this._bundleNames = new LinkedHashMap();
        this.serviceProviders$delegate = LazyKt.lazy((Function0)new Function0<Map<String, Set<String>>>(this){
            final /* synthetic */ Jar this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, Set<String>> invoke() {
                void var1_1;
                Map serviceProviders2 = new LinkedHashMap<K, V>();
                Closeable closeable = Jar.access$getFileSystemProvider$p(this.this$0).getFileSystem(this.this$0.getJarPath());
                Throwable throwable = null;
                try {
                    FileSystem fs = (FileSystem)closeable;
                    boolean bl = false;
                    Iterable $this$forEach$iv = Jar.access$getServiceProviderPaths$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Object object;
                        void $this$getOrPut$iv;
                        Path serviceProviderFile;
                        CharSequence spPath = (CharSequence)element$iv;
                        boolean bl2 = false;
                        Path path = serviceProviderFile = fs.getPath(((Object)spPath).toString(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue(path, "serviceProviderFile");
                        if (!FileUtilKt.isFile(path)) continue;
                        Set serviceProviderNames = Jar.access$readServiceImplementationNames(this.this$0, serviceProviderFile);
                        Object object2 = serviceProviders2;
                        String key$iv = ((Object)serviceProviderFile.getFileName()).toString();
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Set answer$iv = new LinkedHashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        object2 = (Set)object;
                        CollectionsKt.addAll(object2, serviceProviderNames);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return var1_1;
            }
            {
                this.this$0 = jar2;
                super(0);
            }
        });
        this.serviceProviderPaths = new LinkedHashSet();
        this.descriptorCandidates = new LinkedHashSet();
        this.entryResolverResults = new LinkedHashMap();
    }

    public /* synthetic */ Jar(Path path, JarFileSystemProvider jarFileSystemProvider, List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(path, jarFileSystemProvider, list);
    }

    public static final /* synthetic */ void access$scan(Jar $this, ZipEntry zipEntry) {
        $this.scan(zipEntry);
    }

    public static final /* synthetic */ String access$parseServiceImplementationLine(Jar $this, String line) {
        return $this.parseServiceImplementationLine(line);
    }

    public static final /* synthetic */ JarFileSystemProvider access$getFileSystemProvider$p(Jar $this) {
        return $this.fileSystemProvider;
    }

    public static final /* synthetic */ Set access$getServiceProviderPaths$p(Jar $this) {
        return $this.serviceProviderPaths;
    }

    public static final /* synthetic */ Set access$readServiceImplementationNames(Jar $this, Path metaInfServiceProviderPath) {
        return $this.readServiceImplementationNames(metaInfServiceProviderPath);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/jar/Jar$PathWithinJar;", "", "path", "Ljava/nio/CharBuffer;", "(Ljava/nio/CharBuffer;)V", "getPath", "()Ljava/nio/CharBuffer;", "component1", "copy", "equals", "", "other", "hashCode", "", "isClass", "isResourceBundle", "isXml", "removePrefix", "", "prefix", "", "removeSuffix", "suffix", "toString", "Companion", "structure-base"})
    private static final class PathWithinJar {
        @NotNull
        private final CharBuffer path;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final boolean isClass() {
            return StringsKt.endsWith$default((CharSequence)this.path, JarKt.access$getCLASS_SUFFIX$p(), false, 2, null);
        }

        public final boolean isResourceBundle() {
            return StringsKt.endsWith$default((CharSequence)this.path, JarKt.access$getRESOURCE_BUNDLE_EXTENSION$p(), false, 2, null);
        }

        public final boolean isXml() {
            return StringsKt.endsWith$default((CharSequence)this.path, JarKt.access$getXML_DESCRIPTOR_SUFFIX$p(), false, 2, null);
        }

        @NotNull
        public final CharSequence removePrefix(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            if (!StringsKt.startsWith$default((CharSequence)this.path, (CharSequence)prefix, false, 2, null)) {
                return this.path;
            }
            CharBuffer charBuffer = this.path.subSequence(0, prefix.length());
            Intrinsics.checkNotNullExpressionValue(charBuffer, "path.subSequence(0, prefix.length)");
            return charBuffer;
        }

        @NotNull
        public final CharSequence removeSuffix(@NotNull CharSequence suffix) {
            Intrinsics.checkNotNullParameter(suffix, "suffix");
            if (!StringsKt.endsWith$default((CharSequence)this.path, suffix, false, 2, null)) {
                return this.path;
            }
            return new CharBufferCharSequence(this.path, 0, this.path.length() - suffix.length());
        }

        @NotNull
        public String toString() {
            String string = this.path.toString();
            Intrinsics.checkNotNullExpressionValue(string, "path.toString()");
            return string;
        }

        @NotNull
        public final CharBuffer getPath() {
            return this.path;
        }

        public PathWithinJar(@NotNull CharBuffer path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.path = path;
        }

        @NotNull
        public final CharBuffer component1() {
            return this.path;
        }

        @NotNull
        public final PathWithinJar copy(@NotNull CharBuffer path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return new PathWithinJar(path);
        }

        public static /* synthetic */ PathWithinJar copy$default(PathWithinJar pathWithinJar, CharBuffer charBuffer, int n, Object object) {
            if ((n & 1) != 0) {
                charBuffer = pathWithinJar.path;
            }
            return pathWithinJar.copy(charBuffer);
        }

        public int hashCode() {
            CharBuffer charBuffer = this.path;
            return charBuffer != null ? ((Object)charBuffer).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PathWithinJar)) break block3;
                    PathWithinJar pathWithinJar = (PathWithinJar)object;
                    if (!Intrinsics.areEqual(this.path, pathWithinJar.path)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/jar/Jar$PathWithinJar$Companion;", "", "()V", "of", "Lcom/jetbrains/plugin/structure/jar/Jar$PathWithinJar;", "zipEntry", "Ljava/util/zip/ZipEntry;", "structure-base"})
        public static final class Companion {
            @NotNull
            public final PathWithinJar of(@NotNull ZipEntry zipEntry) {
                Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
                CharBuffer charBuffer = CharBuffer.wrap(zipEntry.getName());
                Intrinsics.checkNotNullExpressionValue(charBuffer, "CharBuffer.wrap(zipEntry.name)");
                return new PathWithinJar(charBuffer);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugin/structure/jar/Jar$DescriptorType;", "", "(Ljava/lang/String;I)V", "NO_MATCH", "PLUGIN", "MODULE", "structure-base"})
    public static final class DescriptorType
    extends Enum<DescriptorType> {
        public static final /* enum */ DescriptorType NO_MATCH;
        public static final /* enum */ DescriptorType PLUGIN;
        public static final /* enum */ DescriptorType MODULE;
        private static final /* synthetic */ DescriptorType[] $VALUES;

        static {
            DescriptorType[] descriptorTypeArray = new DescriptorType[3];
            DescriptorType[] descriptorTypeArray2 = descriptorTypeArray;
            descriptorTypeArray[0] = NO_MATCH = new DescriptorType();
            descriptorTypeArray[1] = PLUGIN = new DescriptorType();
            descriptorTypeArray[2] = MODULE = new DescriptorType();
            $VALUES = descriptorTypeArray;
        }

        public static DescriptorType[] values() {
            return (DescriptorType[])$VALUES.clone();
        }

        public static DescriptorType valueOf(String string) {
            return Enum.valueOf(DescriptorType.class, string);
        }
    }
}

