/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/JarsResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "jarFiles", "", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/util/List;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "jarPath", "pathWithinJar", "", "relativePath", "basePath", "structure-intellij"})
public final class JarsResourceResolver
implements ResourceResolver {
    private final List<Path> jarFiles;
    private final JarFileSystemProvider jarFileSystemProvider;

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        ResourceResolver.Result resourceResult = DefaultResourceResolver.INSTANCE.resolveResource(relativePath, basePath);
        if (!(resourceResult instanceof ResourceResolver.Result.NotFound)) {
            return resourceResult;
        }
        String finalPath = ((Object)basePath.resolveSibling(relativePath)).toString();
        for (Path jarFile : this.jarFiles) {
            ResourceResolver.Result result2 = this.resolveResource(jarFile, finalPath);
            if (result2 == null) continue;
            return result2;
        }
        return ResourceResolver.Result.NotFound.INSTANCE;
    }

    private final ResourceResolver.Result resolveResource(Path jarPath, String pathWithinJar) throws Exception {
        FileSystem jarFs = null;
        try {
            Path path;
            jarFs = this.jarFileSystemProvider.getFileSystem(jarPath);
            Path path2 = path = jarFs.getPath(pathWithinJar, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "path");
            if (!FileUtilKt.exists(path2)) {
                return null;
            }
            return new ResourceResolver.Result.Found(path, FileUtilKt.inputStream(path), jarFs, null, 8, null);
        }
        catch (Throwable e) {
            block3: {
                FileSystem fileSystem = jarFs;
                if (fileSystem == null) break block3;
                fileSystem.close();
            }
            throw e;
        }
    }

    public JarsResourceResolver(@NotNull List<? extends Path> jarFiles, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        Intrinsics.checkNotNullParameter(jarFiles, "jarFiles");
        Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
        this.jarFiles = jarFiles;
        this.jarFileSystemProvider = jarFileSystemProvider;
    }
}

