/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.layout;

import com.jetbrains.plugin.structure.base.problems.MissedFile;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.StringUtilsKt;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentFactory;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentLoader;
import com.jetbrains.plugin.structure.ide.layout.PluginWithArtifactPathResult;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesManager;
import com.jetbrains.plugin.structure.intellij.platform.LayoutComponent;
import com.jetbrains.plugin.structure.intellij.plugin.PluginFileNotFoundException;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J2\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/ide/layout/PluginFactory;", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentFactory;", "Lcom/jetbrains/plugin/structure/intellij/platform/LayoutComponent$Plugin;", "pluginLoader", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentLoader;", "(Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentLoader;)V", "getRelativePluginDirectory", "Ljava/nio/file/Path;", "pluginComponent", "read", "Lcom/jetbrains/plugin/structure/ide/layout/PluginWithArtifactPathResult;", "layoutComponent", "idePath", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "moduleManager", "Lcom/jetbrains/plugin/structure/intellij/platform/BundledModulesManager;", "structure-ide"})
public final class PluginFactory
implements LayoutComponentFactory<LayoutComponent.Plugin> {
    private final LayoutComponentLoader pluginLoader;

    @Override
    @Nullable
    public PluginWithArtifactPathResult read(@NotNull LayoutComponent.Plugin layoutComponent, @NotNull Path idePath, @NotNull IdeVersion ideVersion, @NotNull ResourceResolver resourceResolver, @NotNull BundledModulesManager moduleManager) {
        PluginWithArtifactPathResult pluginWithArtifactPathResult;
        Intrinsics.checkNotNullParameter(layoutComponent, "layoutComponent");
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
        Intrinsics.checkNotNullParameter(moduleManager, "moduleManager");
        Path path = this.getRelativePluginDirectory(layoutComponent);
        if (path == null) {
            return null;
        }
        Path relativePluginDir = path;
        Path pluginDir = idePath.resolve(relativePluginDir);
        try {
            Path path2 = pluginDir;
            Intrinsics.checkNotNullExpressionValue(path2, "pluginDir");
            pluginWithArtifactPathResult = this.pluginLoader.load(path2, "plugin.xml", resourceResolver, ideVersion, layoutComponent.getName());
        }
        catch (PluginFileNotFoundException e) {
            Path path3 = pluginDir;
            Intrinsics.checkNotNullExpressionValue(path3, "pluginDir");
            pluginWithArtifactPathResult = new PluginWithArtifactPathResult.Failure(path3, layoutComponent.getName(), new MissedFile(((Object)pluginDir).toString()));
        }
        return pluginWithArtifactPathResult;
    }

    private final Path getRelativePluginDirectory(LayoutComponent.Plugin pluginComponent) {
        Path path = StringUtilsKt.getCommonParentDirectory(pluginComponent.getClasspath());
        if (path == null) {
            return null;
        }
        Path commonParent = path;
        return Intrinsics.areEqual(FileUtilKt.getSimpleName(commonParent), "lib") ? commonParent.getParent() : commonParent;
    }

    public PluginFactory(@NotNull LayoutComponentLoader pluginLoader) {
        Intrinsics.checkNotNullParameter(pluginLoader, "pluginLoader");
        this.pluginLoader = pluginLoader;
    }
}

