/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.BuildTxtIdeVersionProvider;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.IdeVersionResolution;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIde;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIdeManagerKt;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedPluginCollectionProvider;
import com.jetbrains.plugin.structure.ide.layout.MissingLayoutFileMode;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParseException;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParser;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "missingLayoutFileMode", "Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;", "additionalPluginReader", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "(Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;)V", "pluginCollectionProvider", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedPluginCollectionProvider;", "productInfoParser", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser;", "productInfoJson", "Ljava/nio/file/Path;", "getProductInfoJson", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "assertProductInfoPresent", "idePath", "createIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "version", "createIdeVersion", "isAtLeastVersion", "", "expectedVersion", "", "supports", "NoopPluginReader", "PluginReader", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nProductInfoBasedIdeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n288#2,2:102\n*E\n*S KotlinDebug\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n*L\n73#1,2:102\n*E\n"})
public final class ProductInfoBasedIdeManager
extends IdeManager {
    private final ProductInfoParser productInfoParser;
    private final ProductInfoBasedPluginCollectionProvider pluginCollectionProvider;

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath) throws InvalidIdeException {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.createIde(idePath, ProductInfoBasedIdeManagerKt.getVERSION_FROM_PRODUCT_INFO());
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath, @Nullable IdeVersion version) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        this.assertProductInfoPresent(idePath);
        try {
            Path path = this.getProductInfoJson(idePath);
            Intrinsics.checkNotNull(path);
            ProductInfo productInfo = this.productInfoParser.parse(path);
            IdeVersion ideVersion = version;
            if (ideVersion == null) {
                ideVersion = this.createIdeVersion(productInfo);
            }
            IdeVersion ideVersion2 = ideVersion;
            return this.createIde(idePath, ideVersion2, productInfo);
        }
        catch (ProductInfoParseException e) {
            throw (Throwable)new InvalidIdeException(idePath, e);
        }
    }

    private final Ide createIde(Path idePath, IdeVersion ideVersion, ProductInfo productInfo) {
        if (!FileUtilKt.isDirectory(idePath)) {
            throw (Throwable)new IOException("Specified path does not exist or is not a directory: " + idePath);
        }
        return new ProductInfoBasedIde(idePath, ideVersion, productInfo, this.pluginCollectionProvider);
    }

    private final IdeVersion createIdeVersion(ProductInfo productInfo) {
        ProductInfo productInfo2;
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        ProductInfo $this$with = productInfo2 = productInfo;
        boolean bl2 = false;
        CharSequence charSequence = $this$with.getProductCode();
        if (charSequence.length() > 0) {
            $this$buildString.append($this$with.getProductCode()).append("-");
        }
        $this$buildString.append($this$with.getBuildNumber());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String versionString = string;
        IdeVersion ideVersion = IdeVersion.createIdeVersion(versionString);
        Intrinsics.checkNotNullExpressionValue(ideVersion, "IdeVersion.createIdeVersion(versionString)");
        return ideVersion;
    }

    private final Path getProductInfoJson(Path $this$productInfoJson) {
        Object v3;
        block1: {
            Path[] pathArray = new Path[2];
            Path path = $this$productInfoJson.resolve("product-info.json");
            Intrinsics.checkNotNullExpressionValue(path, "resolve(PRODUCT_INFO_JSON)");
            pathArray[0] = path;
            Path path2 = $this$productInfoJson.resolve("Resources").resolve("product-info.json");
            Intrinsics.checkNotNullExpressionValue(path2, "resolve(MACOS_RESOURCES_\u2026esolve(PRODUCT_INFO_JSON)");
            pathArray[1] = path2;
            List<Path> locations = CollectionsKt.listOf(pathArray);
            Iterable $this$firstOrNull$iv = locations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!FileUtilKt.exists(it)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private final Path assertProductInfoPresent(Path idePath) throws InvalidIdeException {
        Path path = this.getProductInfoJson(idePath);
        if (path == null) {
            throw (Throwable)new InvalidIdeException(idePath, "The 'product-info.json' file is not available.");
        }
        return path;
    }

    public final boolean supports(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.getProductInfoJson(idePath) != null && this.isAtLeastVersion(idePath, "242");
    }

    private final boolean isAtLeastVersion(Path idePath, String expectedVersion) {
        boolean bl;
        IdeVersionResolution version = new BuildTxtIdeVersionProvider().readIdeVersion(idePath);
        if (version instanceof IdeVersionResolution.Found) {
            bl = ((IdeVersionResolution.Found)version).getIdeVersion().compareTo(IdeVersion.createIdeVersion(expectedVersion)) > 0;
        } else if (version instanceof IdeVersionResolution.Failed || version instanceof IdeVersionResolution.NotFound) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public ProductInfoBasedIdeManager(@NotNull MissingLayoutFileMode missingLayoutFileMode, @NotNull PluginReader additionalPluginReader) {
        Intrinsics.checkNotNullParameter((Object)missingLayoutFileMode, "missingLayoutFileMode");
        Intrinsics.checkNotNullParameter(additionalPluginReader, "additionalPluginReader");
        this.productInfoParser = new ProductInfoParser();
        this.pluginCollectionProvider = new ProductInfoBasedPluginCollectionProvider(missingLayoutFileMode, additionalPluginReader, SingletonCachingJarFileSystemProvider.INSTANCE);
    }

    public /* synthetic */ ProductInfoBasedIdeManager(MissingLayoutFileMode missingLayoutFileMode, PluginReader pluginReader, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            missingLayoutFileMode = MissingLayoutFileMode.SKIP_AND_WARN;
        }
        if ((n & 2) != 0) {
            pluginReader = NoopPluginReader.INSTANCE;
        }
        this(missingLayoutFileMode, pluginReader);
    }

    public ProductInfoBasedIdeManager() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "", "readPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "structure-ide"})
    public static interface PluginReader {
        @NotNull
        public List<IdePlugin> readPlugins(@NotNull Path var1, @NotNull ProductInfo var2, @NotNull IdeVersion var3);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$NoopPluginReader;", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "()V", "readPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "structure-ide"})
    private static final class NoopPluginReader
    implements PluginReader {
        @NotNull
        public static final NoopPluginReader INSTANCE;

        @Override
        @NotNull
        public List<IdePlugin> readPlugins(@NotNull Path idePath, @NotNull ProductInfo productInfo, @NotNull IdeVersion ideVersion) {
            Intrinsics.checkNotNullParameter(idePath, "idePath");
            Intrinsics.checkNotNullParameter(productInfo, "productInfo");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            return CollectionsKt.emptyList();
        }

        private NoopPluginReader() {
        }

        static {
            NoopPluginReader noopPluginReader;
            INSTANCE = noopPluginReader = new NoopPluginReader();
        }
    }
}

