/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmountKt;
import com.jetbrains.pluginverifier.repository.downloader.DownloadResult;
import com.jetbrains.pluginverifier.repository.downloader.DownloadStatistics;
import com.jetbrains.pluginverifier.repository.downloader.Downloader;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #*\u0006\b\u0000\u0010\u0001 \u00002\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002:\u0001#B/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ3\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider;", "K", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "Ljava/nio/file/Path;", "destinationDirectory", "downloader", "Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;", "fileNameWithoutExtensionMapper", "Lkotlin/Function1;", "", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;Lkotlin/jvm/functions/Function1;)V", "downloadDirectory", "kotlin.jvm.PlatformType", "downloadStatistics", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "getDownloadStatistics", "()Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "createTempDirectoryForDownload", "key", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getDestinationFile", "isDirectory", "", "extension", "(Ljava/lang/Object;ZLjava/lang/String;)Ljava/nio/file/Path;", "moveFileOrDirectory", "", "fileOrDirectory", "destination", "provide", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "saveDownloadedFileToFinalDestination", "tempDownloadedFile", "(Ljava/lang/Object;Ljava/nio/file/Path;Ljava/lang/String;Z)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "Companion", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDownloadProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadProvider.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class DownloadProvider<K>
implements ResourceProvider<K, Path> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Path destinationDirectory;
    @NotNull
    private final Downloader<K> downloader;
    @NotNull
    private final Function1<K, String> fileNameWithoutExtensionMapper;
    private final Path downloadDirectory;
    @NotNull
    private final DownloadStatistics downloadStatistics;
    @Deprecated
    @NotNull
    public static final String DOWNLOADS_DIRECTORY = ".downloads";

    public DownloadProvider(@NotNull Path destinationDirectory, @NotNull Downloader<? super K> downloader, @NotNull Function1<? super K, String> fileNameWithoutExtensionMapper) {
        Intrinsics.checkNotNullParameter(destinationDirectory, "destinationDirectory");
        Intrinsics.checkNotNullParameter(downloader, "downloader");
        Intrinsics.checkNotNullParameter(fileNameWithoutExtensionMapper, "fileNameWithoutExtensionMapper");
        this.destinationDirectory = destinationDirectory;
        this.downloader = downloader;
        this.fileNameWithoutExtensionMapper = fileNameWithoutExtensionMapper;
        this.downloadDirectory = this.destinationDirectory.resolve(DOWNLOADS_DIRECTORY);
        this.downloadStatistics = new DownloadStatistics();
        FileUtilKt.createDir(this.destinationDirectory);
        Path path = this.downloadDirectory;
        Intrinsics.checkNotNullExpressionValue(path, "downloadDirectory");
        FileUtilKt.forceDeleteIfExists(path);
    }

    @NotNull
    public final DownloadStatistics getDownloadStatistics() {
        return this.downloadStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProvideResult<Path> provide(K key) throws InterruptedException {
        ProvideResult<Path> provideResult;
        DownloadStatistics.DownloadEvent downloadEvent = this.downloadStatistics.downloadStarted();
        Path tempDirectory = this.createTempDirectoryForDownload(key);
        try {
            ProvideResult<Path> provideResult2;
            Intrinsics.checkNotNullExpressionValue(tempDirectory, "tempDirectory");
            DownloadResult $this$provide_u24lambda_u240 = this.downloader.download(key, tempDirectory);
            boolean bl = false;
            DownloadResult downloadResult = $this$provide_u24lambda_u240;
            if (downloadResult instanceof DownloadResult.Downloaded) {
                downloadEvent.downloadEnded(SpaceAmountKt.getFileSize(((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getDownloadedFileOrDirectory()));
                provideResult2 = this.saveDownloadedFileToFinalDestination(key, ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getDownloadedFileOrDirectory(), ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getExtension(), ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).isDirectory());
            } else if (downloadResult instanceof DownloadResult.NotFound) {
                provideResult2 = new ProvideResult.NotFound(((DownloadResult.NotFound)$this$provide_u24lambda_u240).getReason());
            } else if (downloadResult instanceof DownloadResult.FailedToDownload) {
                provideResult2 = new ProvideResult.Failed(((DownloadResult.FailedToDownload)$this$provide_u24lambda_u240).getReason(), ((DownloadResult.FailedToDownload)$this$provide_u24lambda_u240).getError());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            provideResult = provideResult2;
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue(tempDirectory, "tempDirectory");
            FileUtilKt.deleteLogged(tempDirectory);
            throw throwable;
        }
        FileUtilKt.deleteLogged(tempDirectory);
        return provideResult;
    }

    private final synchronized ProvideResult<Path> saveDownloadedFileToFinalDestination(K key, Path tempDownloadedFile, String extension, boolean isDirectory) {
        Path destination = this.getDestinationFile(key, isDirectory, extension);
        try {
            this.moveFileOrDirectory(tempDownloadedFile, destination);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            return new ProvideResult.Failed("Unable to download " + key, e);
        }
        return new ProvideResult.Provided<Path>(destination);
    }

    private final Path getDestinationFile(K key, boolean isDirectory, String extension) {
        if (!Intrinsics.areEqual(extension, FileUtilKt.replaceInvalidFileNameCharacters(extension))) {
            boolean $i$a$-check-DownloadProvider$getDestinationFile$22 = false;
            String $i$a$-check-DownloadProvider$getDestinationFile$22 = "Extension must not contain invalid characters: " + extension;
            throw new IllegalStateException($i$a$-check-DownloadProvider$getDestinationFile$22.toString());
        }
        String nameWithoutExtension = FileUtilKt.replaceInvalidFileNameCharacters(this.fileNameWithoutExtensionMapper.invoke(key));
        String extensionSuffix = isDirectory || ((CharSequence)extension).length() == 0 ? "" : "." + extension;
        Path destination = this.destinationDirectory.resolve(nameWithoutExtension + extensionSuffix);
        int nextSuffix = 1;
        while (Files.exists(destination, new LinkOption[0])) {
            String newName = ((CharSequence)extensionSuffix).length() == 0 ? nameWithoutExtension + " (" + nextSuffix + ")" : nameWithoutExtension + " (" + nextSuffix + ")" + extensionSuffix;
            destination = this.destinationDirectory.resolve(newName);
            ++nextSuffix;
        }
        Path path = destination;
        Intrinsics.checkNotNullExpressionValue(path, "destination");
        return path;
    }

    private final Path createTempDirectoryForDownload(K key) {
        Path path;
        try {
            Path path2 = this.downloadDirectory;
            Intrinsics.checkNotNullExpressionValue(path2, "downloadDirectory");
            path = Files.createTempDirectory(FileUtilKt.createDir(path2), "download-" + FileUtilKt.replaceInvalidFileNameCharacters(this.fileNameWithoutExtensionMapper.invoke(key)) + "-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    private final void moveFileOrDirectory(Path fileOrDirectory, Path destination) {
        if (FileUtilKt.exists(destination)) {
            FileUtilKt.deleteLogged(destination);
        }
        if (FileUtilKt.isDirectory(fileOrDirectory)) {
            FileUtils.moveDirectory(fileOrDirectory.toFile(), destination.toFile());
        } else {
            FileUtils.moveFile(fileOrDirectory.toFile(), destination.toFile());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider$Companion;", "", "()V", "DOWNLOADS_DIRECTORY", "", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

