/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.intellij.classes.locator.CompileServerExtensionKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.BundledPluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.JetBrainsPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.pluginverifier.plugin.AbstractPluginDetailsProvider;
import com.jetbrains.pluginverifier.plugin.PluginDetailsProviderImpl;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.dependency.DependencyPluginInfo;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider;", "Lcom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "dependencyProblemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "nonBundledPluginDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProviderImpl;", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "pluginFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "readPluginClasses", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "verifier-repository"})
public final class DefaultPluginDetailsProvider
extends AbstractPluginDetailsProvider {
    @NotNull
    private final PluginDetailsProviderImpl nonBundledPluginDetailsProvider;
    @NotNull
    private final PluginCreationResultResolver dependencyProblemResolver;

    public DefaultPluginDetailsProvider(@NotNull Path extractDirectory) {
        Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
        super(extractDirectory);
        this.nonBundledPluginDetailsProvider = new PluginDetailsProviderImpl(extractDirectory);
        this.dependencyProblemResolver = JetBrainsPluginCreationResultResolver.Companion.fromClassPathJson(new IntelliJPluginCreationResultResolver());
    }

    @Override
    @NotNull
    public IdePluginClassesLocations readPluginClasses(@NotNull PluginInfo pluginInfo, @NotNull IdePlugin idePlugin) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        return pluginInfo instanceof BundledPluginInfo ? BundledPluginClassesFinder.Companion.findPluginClasses(idePlugin, CollectionsKt.listOf(CompileServerExtensionKey.INSTANCE)) : this.nonBundledPluginDetailsProvider.readPluginClasses(pluginInfo, idePlugin);
    }

    @Override
    @NotNull
    protected PluginCreationResult<IdePlugin> createPlugin(@NotNull PluginInfo pluginInfo, @NotNull FileLock pluginFileLock) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(pluginFileLock, "pluginFileLock");
        return pluginInfo instanceof DependencyPluginInfo ? IdePluginManager.createPlugin$default(this.getIdePluginManager(), pluginFileLock.getFile(), false, null, this.dependencyProblemResolver, 4, null) : super.createPlugin(pluginInfo, pluginFileLock);
    }
}

