/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.StructurallyValidated;
import com.jetbrains.plugin.structure.intellij.problems.UnableToReadPluginFile;
import com.jetbrains.pluginverifier.plugin.PluginDetails;
import com.jetbrains.pluginverifier.plugin.PluginDetailsProvider;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\fH&J0\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider;", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "idePluginManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "getIdePluginManager", "()Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "problems", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "getProblems", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;)Ljava/util/List;", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "pluginFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "providePluginDetails", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider$Result;", "idePlugin", "readPluginClasses", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "warnings", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nAbstractPluginDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,90:1\n70#2,5:91\n*S KotlinDebug\n*F\n+ 1 AbstractPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider\n*L\n35#1:91,5\n*E\n"})
public abstract class AbstractPluginDetailsProvider
implements PluginDetailsProvider {
    @NotNull
    private final Path extractDirectory;
    @NotNull
    private final IdePluginManager idePluginManager;

    public AbstractPluginDetailsProvider(@NotNull Path extractDirectory) {
        Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
        this.extractDirectory = extractDirectory;
        this.idePluginManager = IdePluginManager.Companion.createManager(this.extractDirectory);
    }

    @NotNull
    protected final IdePluginManager getIdePluginManager() {
        return this.idePluginManager;
    }

    private final List<PluginProblem> getProblems(IdePlugin $this$problems) {
        return $this$problems instanceof StructurallyValidated ? ((StructurallyValidated)((Object)$this$problems)).getProblems() : CollectionsKt.emptyList();
    }

    @NotNull
    public abstract IdePluginClassesLocations readPluginClasses(@NotNull PluginInfo var1, @NotNull IdePlugin var2);

    @Override
    @NotNull
    public PluginDetailsProvider.Result providePluginDetails(@NotNull PluginInfo pluginInfo, @NotNull FileLock pluginFileLock) {
        PluginDetailsProvider.Result result2;
        block4: {
            Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
            Intrinsics.checkNotNullParameter(pluginFileLock, "pluginFileLock");
            Closeable $this$closeOnException$iv = pluginFileLock;
            boolean $i$f$closeOnException = false;
            try {
                FileLock it = (FileLock)$this$closeOnException$iv;
                boolean bl = false;
                PluginCreationResult<IdePlugin> $this$providePluginDetails_u24lambda_u241_u24lambda_u240 = this.createPlugin(pluginInfo, pluginFileLock);
                boolean bl2 = false;
                PluginCreationResult<IdePlugin> pluginCreationResult = $this$providePluginDetails_u24lambda_u241_u24lambda_u240;
                if (pluginCreationResult instanceof PluginCreationSuccess) {
                    result2 = this.readPluginClasses(pluginInfo, (IdePlugin)((PluginCreationSuccess)$this$providePluginDetails_u24lambda_u241_u24lambda_u240).getPlugin(), this.getProblems((IdePlugin)((PluginCreationSuccess)$this$providePluginDetails_u24lambda_u241_u24lambda_u240).getPlugin()), pluginFileLock);
                    break block4;
                }
                if (pluginCreationResult instanceof PluginCreationFail) {
                    LanguageUtilsKt.closeLogged((Closeable)pluginFileLock);
                    result2 = new PluginDetailsProvider.Result.InvalidPlugin(pluginInfo, ((PluginCreationFail)$this$providePluginDetails_u24lambda_u241_u24lambda_u240).getErrorsAndWarnings());
                    break block4;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (Throwable e$iv) {
                LanguageUtilsKt.closeLogged($this$closeOnException$iv);
                throw e$iv;
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public PluginDetailsProvider.Result providePluginDetails(@NotNull PluginInfo pluginInfo, @NotNull IdePlugin idePlugin) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        return this.readPluginClasses(pluginInfo, idePlugin, this.getProblems(idePlugin), null);
    }

    private final PluginDetailsProvider.Result readPluginClasses(PluginInfo pluginInfo, IdePlugin idePlugin, List<? extends PluginProblem> warnings, FileLock pluginFileLock) {
        PluginDetailsProvider.Result result2;
        try {
            IdePluginClassesLocations pluginClassesLocations = this.readPluginClasses(pluginInfo, idePlugin);
            boolean bl = false;
            result2 = new PluginDetailsProvider.Result.Provided(new PluginDetails(pluginInfo, idePlugin, warnings, pluginClassesLocations, pluginFileLock));
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getSimpleName();
            }
            String message2 = string;
            Intrinsics.checkNotNullExpressionValue(message2, "message");
            result2 = new PluginDetailsProvider.Result.InvalidPlugin(pluginInfo, CollectionsKt.listOf(new UnableToReadPluginFile(message2)));
        }
        return result2;
    }

    @NotNull
    protected PluginCreationResult<IdePlugin> createPlugin(@NotNull PluginInfo pluginInfo, @NotNull FileLock pluginFileLock) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(pluginFileLock, "pluginFileLock");
        return this.idePluginManager.createPlugin(pluginFileLock.getFile());
    }
}

