/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.VersionComparatorUtil;
import com.jetbrains.pluginverifier.dependencies.resolution.PluginVersionSelector;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/LastVersionSelector;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector;", "()V", "selectLastVersion", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector$Result;", "allVersions", "", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "notFoundMessage", "", "selectPluginByModuleId", "moduleId", "selectPluginVersion", "pluginId", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nLastVersionSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LastVersionSelector.kt\ncom/jetbrains/pluginverifier/dependencies/resolution/LastVersionSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1963#2,14:44\n*S KotlinDebug\n*F\n+ 1 LastVersionSelector.kt\ncom/jetbrains/pluginverifier/dependencies/resolution/LastVersionSelector\n*L\n33#1:44,14\n*E\n"})
public final class LastVersionSelector
implements PluginVersionSelector {
    @Override
    @NotNull
    public PluginVersionSelector.Result selectPluginVersion(@NotNull String pluginId, @NotNull PluginRepository pluginRepository) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        List<PluginInfo> allVersions = pluginRepository.getAllVersionsOfPlugin(pluginId);
        return this.selectLastVersion(allVersions, pluginRepository, "Plugin " + pluginId + " is not found in " + pluginRepository);
    }

    @Override
    @NotNull
    public PluginVersionSelector.Result selectPluginByModuleId(@NotNull String moduleId, @NotNull PluginRepository pluginRepository) {
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        List<PluginInfo> plugins = pluginRepository.getPluginsDeclaringModule(moduleId, null);
        return this.selectLastVersion(plugins, pluginRepository, "Plugin declaring module '" + moduleId + "' is not found in " + pluginRepository);
    }

    private final PluginVersionSelector.Result selectLastVersion(List<? extends PluginInfo> allVersions, PluginRepository pluginRepository, String notFoundMessage) {
        PluginInfo pluginInfo;
        if (pluginRepository instanceof MarketplaceRepository) {
            Object v0;
            Iterable $this$maxByOrNull$iv = allVersions;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    PluginInfo it = (PluginInfo)maxElem$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo");
                    int maxValue$iv = ((UpdateInfo)it).getUpdateId();
                    do {
                        Object e$iv = iterator$iv.next();
                        PluginInfo it2 = (PluginInfo)e$iv;
                        $i$a$-maxByOrNull-LastVersionSelector$selectLastVersion$lastVersion$1 = false;
                        Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo");
                        int v$iv = ((UpdateInfo)it2).getUpdateId();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            pluginInfo = v0;
        } else {
            Iterable iterable = allVersions;
            Comparator<String> comparator = VersionComparatorUtil.COMPARATOR;
            Intrinsics.checkNotNullExpressionValue(comparator, "COMPARATOR");
            Comparator<String> comparator2 = comparator;
            pluginInfo = (PluginInfo)CollectionsKt.maxWithOrNull(iterable, new Comparator(comparator2){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    PluginInfo pluginInfo = (PluginInfo)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    PluginInfo it = (PluginInfo)b;
                    String string = it.getVersion();
                    bl = false;
                    String string2 = it.getVersion();
                    return comparator.compare(string, string2);
                }
            });
        }
        PluginInfo lastVersion2 = pluginInfo;
        return lastVersion2 != null ? (PluginVersionSelector.Result)new PluginVersionSelector.Result.Selected(lastVersion2) : (PluginVersionSelector.Result)new PluginVersionSelector.Result.NotFound(notFoundMessage);
    }
}

