/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependenciesKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeResolution;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.DependencyEdge;
import com.jetbrains.pluginverifier.dependencies.DependencyNode;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011*\u00020\fH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e*\u00020\fH\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\bH\u0002J\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0004j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider;", "", "()V", "dependencyNodeCache", "Ljava/util/HashMap;", "Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;", "Lkotlin/collections/HashMap;", "pluginDependencyCache", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "getDependenciesGraph", "Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "dependencyTreeResolution", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTreeResolution;", "getEdges", "", "Lcom/jetbrains/pluginverifier/dependencies/DependencyEdge;", "getMissingDependencies", "", "", "Lcom/jetbrains/pluginverifier/dependencies/MissingDependency;", "getTransitiveDependencyVertices", "getVertices", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency$Module;", "intern", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDependenciesGraphProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesGraphProvider.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,77:1\n1360#2:78\n1446#2,5:79\n1620#2,3:87\n1549#2:91\n1620#2,3:92\n125#3:84\n152#3,2:85\n154#3:90\n*S KotlinDebug\n*F\n+ 1 DependenciesGraphProvider.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider\n*L\n29#1:78\n29#1:79,5\n58#1:87,3\n70#1:91\n70#1:92,3\n56#1:84\n56#1:85,2\n56#1:90\n*E\n"})
public final class DependenciesGraphProvider {
    @NotNull
    private final HashMap<PluginDependency, PluginDependency> pluginDependencyCache = new HashMap();
    @NotNull
    private final HashMap<DependencyNode, DependencyNode> dependencyNodeCache = new HashMap();

    @NotNull
    public final DependenciesGraph getDependenciesGraph(@NotNull DependencyTreeResolution dependencyTreeResolution) {
        Intrinsics.checkNotNullParameter(dependencyTreeResolution, "dependencyTreeResolution");
        DependencyNode verifiedPlugin = new DependencyNode(DependenciesKt.getId(dependencyTreeResolution.getDependencyRoot()), "unknown version");
        List<DependencyNode> transitiveDependencyVertices = this.getTransitiveDependencyVertices(dependencyTreeResolution);
        List<DependencyNode> vertices = CollectionsKt.plus((Collection)transitiveDependencyVertices, verifiedPlugin);
        List<DependencyEdge> edges = this.getEdges(dependencyTreeResolution);
        Map<DependencyNode, Set<MissingDependency>> missingDependencies = this.getMissingDependencies(dependencyTreeResolution);
        return new DependenciesGraph(verifiedPlugin, vertices, edges, missingDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyNode> getTransitiveDependencyVertices(DependencyTreeResolution $this$getTransitiveDependencyVertices) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getTransitiveDependencyVertices.getTransitiveDependencies();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection collection;
            Dependency it = (Dependency)element$iv$iv;
            boolean bl = false;
            Dependency dependency = it;
            if (dependency instanceof Dependency.Module) {
                collection = this.getVertices((Dependency.Module)it);
            } else if (dependency instanceof Dependency.Plugin) {
                collection = SetsKt.setOf(new DependencyNode(DependenciesKt.getId(it), "unknown version"));
            } else if (Intrinsics.areEqual(dependency, Dependency.None.INSTANCE)) {
                collection = SetsKt.emptySet();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<DependencyEdge> getEdges(DependencyTreeResolution $this$getEdges) {
        List edges = new ArrayList();
        $this$getEdges.forEach((Function2<? super String, ? super PluginDependency, Unit>)new Function2<String, PluginDependency, Unit>((List<DependencyEdge>)edges, this){
            final /* synthetic */ List<DependencyEdge> $edges;
            final /* synthetic */ DependenciesGraphProvider this$0;
            {
                this.$edges = $edges;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String id, @NotNull PluginDependency dependency) {
                Intrinsics.checkNotNullParameter(id, "id");
                Intrinsics.checkNotNullParameter(dependency, "dependency");
                ((Collection)this.$edges).add(new DependencyEdge(DependenciesGraphProvider.access$intern(this.this$0, new DependencyNode(id, "unknown version")), DependenciesGraphProvider.access$intern(this.this$0, new DependencyNode(dependency.getId(), "unknown version")), DependenciesGraphProvider.access$intern(this.this$0, dependency)));
            }
        });
        return edges;
    }

    private final PluginDependency intern(PluginDependency $this$intern) {
        PluginDependency pluginDependency = this.pluginDependencyCache.computeIfAbsent($this$intern, Function.identity());
        Intrinsics.checkNotNullExpressionValue(pluginDependency, "pluginDependencyCache.co\u2026his, Function.identity())");
        return pluginDependency;
    }

    private final DependencyNode intern(DependencyNode $this$intern) {
        DependencyNode dependencyNode = this.dependencyNodeCache.computeIfAbsent($this$intern, Function.identity());
        Intrinsics.checkNotNullExpressionValue(dependencyNode, "dependencyNodeCache.comp\u2026his, Function.identity())");
        return dependencyNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DependencyNode, Set<MissingDependency>> getMissingDependencies(DependencyTreeResolution $this$getMissingDependencies) {
        void $this$mapTo$iv$iv;
        Map<IdePlugin, Set<PluginDependency>> $this$map$iv = $this$getMissingDependencies.getMissingDependencies();
        boolean $i$f$map = false;
        Map<IdePlugin, Set<PluginDependency>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void destination$iv;
            void $this$mapTo$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IdePlugin plugin = (IdePlugin)entry.getKey();
            Set dependencies = (Set)entry.getValue();
            DependencyNode pluginNode = new DependencyNode(DependenciesKt.getId(plugin), "unknown version");
            Iterable iterable = dependencies;
            Collection collection2 = new LinkedHashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PluginDependency pluginDependency = (PluginDependency)item$iv;
                void var20_20 = destination$iv;
                boolean bl2 = false;
                var20_20.add(new MissingDependency((PluginDependency)it, "Unavailable"));
            }
            Set dependencyNodes = (Set)destination$iv;
            collection.add(TuplesKt.to(pluginNode, dependencyNodes));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyNode> getVertices(Dependency.Module $this$getVertices) {
        void $this$mapTo$iv$iv;
        List vertices = new ArrayList();
        ((Collection)vertices).add(new DependencyNode($this$getVertices.getId(), "unknown version"));
        ((Collection)vertices).add(new DependencyNode(DependenciesKt.getId($this$getVertices.getPlugin()), "unknown version"));
        Iterable $this$map$iv = $this$getVertices.getPlugin().getDefinedModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alias;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            new DependencyNode((String)alias, "unknown version");
            collection.add(new DependencyNode($this$getVertices.getId(), "unknown version"));
        }
        List definedModuleNodes = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)vertices, definedModuleNodes);
        return vertices;
    }

    public static final /* synthetic */ DependencyNode access$intern(DependenciesGraphProvider $this, DependencyNode $receiver) {
        return $this.intern($receiver);
    }

    public static final /* synthetic */ PluginDependency access$intern(DependenciesGraphProvider $this, PluginDependency $receiver) {
        return $this.intern($receiver);
    }
}

