/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.dependencies;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.DependenciesModifier;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PassThruDependenciesModifier;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DefaultDependencyTreeResolution;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTree;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeResolution;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.PluginAware;
import com.jetbrains.plugin.structure.intellij.plugin.module.IdeModule;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002=>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u000fJH\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u001bH\u0002J>\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010\u0011\u001a\u00020\u00122\u001e\b\u0002\u0010&\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00060'j\u0002`)2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010,\u001a\u00020(H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\bJ\f\u00101\u001a\u00020\u0016*\u00020\u0016H\u0002J.\u00102\u001a\b\u0012\u0004\u0012\u00020\u00160$*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00142\n\u00103\u001a\u00060\bj\u0002`\u0015H\u0002J@\u00102\u001a\u00020\u0006*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00142\n\u00103\u001a\u00060\bj\u0002`\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0016052\b\b\u0002\u00106\u001a\u00020\nH\u0002J\u0014\u00107\u001a\u00020\u0016*\u00020\u00032\u0006\u00103\u001a\u00020\bH\u0002JN\u0010.\u001a\u00020\u0006*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00142\n\u00103\u001a\u00060\bj\u0002`\u00152\u0006\u00108\u001a\u00020\n2\u0010\u00109\u001a\f\u0012\b\u0012\u00060\bj\u0002`\u0015052\n\u0010:\u001a\u00060;j\u0002`<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree;", "", "pluginProvider", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;)V", "debugLog", "", "indent", "", "numericIndex", "", "message", "params", "", "(Ljava/lang/String;ILjava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "getDependencyGraph", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "graph", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/PluginId;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency;", "resolutionDepth", "dependencyIndex", "parentDependencyIndex", "context", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$ResolutionContext;", "getDependencyTreeResolution", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTreeResolution;", "dependenciesModifier", "Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "getIndent", "getNestedDependencyIndent", "dependencyNumber", "getTransitiveDependencies", "", "dependencyResolutionContext", "missingDependencyListener", "Lkotlin/Function2;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/MissingDependencyListener;", "ignore", "", "dependency", "missingId", "toDebugString", "", "pluginId", "asTransitive", "collectDependencies", "id", "dependencies", "", "layer", "getPluginOrModule", "indentSize", "visited", "printer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "DiGraph", "ResolutionContext", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1#2:284\n1864#3,3:285\n1855#3,2:288\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n*L\n105#1,3:285\n207#1,2:288\n*E\n"})
public final class DependencyTree {
    private final PluginProvider pluginProvider;

    @NotNull
    public final DependencyTreeResolution getDependencyTreeResolution(@NotNull IdePlugin plugin, @NotNull DependenciesModifier dependenciesModifier) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
        String string = plugin.getPluginId();
        if (string == null) {
            boolean $i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$pluginId$22 = false;
            String $i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$pluginId$22 = this.missingId(plugin);
            throw new IllegalArgumentException($i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$pluginId$22.toString());
        }
        String pluginId = string;
        Map missingDependencies = new LinkedHashMap();
        Function2<IdePlugin, PluginDependency, Unit> missingDependencyListener2 = new Function2<IdePlugin, PluginDependency, Unit>(missingDependencies){
            final /* synthetic */ Map $missingDependencies;

            public void invoke(@NotNull IdePlugin idePlugin, @NotNull PluginDependency missingDependency) {
                Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
                Intrinsics.checkNotNullParameter(missingDependency, "missingDependency");
                this.$missingDependencies.merge(idePlugin, SetsKt.setOf(missingDependency), getDependencyTreeResolution.missingDependencyListener.invoke.1.INSTANCE);
            }
            {
                this.$missingDependencies = $captured_local_variable$0;
            }
        };
        ResolutionContext dependencyResolutionContext = new ResolutionContext((Function2<? super IdePlugin, ? super PluginDependency, Unit>)missingDependencyListener2, dependenciesModifier);
        DiGraph<String, Dependency> dependencyGraph = this.getDependencyGraph(plugin, dependencyResolutionContext);
        Set transitiveDependencies = new LinkedHashSet();
        dependencyGraph.forEachAdjacency$structure_intellij((Function2<String, List<Dependency>, Unit>)new Function2<String, List<? extends Dependency>, Unit>(transitiveDependencies){
            final /* synthetic */ Set $transitiveDependencies;

            public final void invoke(@NotNull String pluginId, @NotNull List<? extends Dependency> dependencies) {
                Intrinsics.checkNotNullParameter(pluginId, "pluginId");
                Intrinsics.checkNotNullParameter(dependencies, "dependencies");
                Collection collection = this.$transitiveDependencies;
                CollectionsKt.addAll(collection, (Iterable)dependencies);
            }
            {
                this.$transitiveDependencies = set;
                super(2);
            }
        });
        return new DefaultDependencyTreeResolution(plugin, transitiveDependencies, missingDependencies, dependencyGraph);
    }

    public static /* synthetic */ DependencyTreeResolution getDependencyTreeResolution$default(DependencyTree dependencyTree, IdePlugin idePlugin, DependenciesModifier dependenciesModifier, int n, Object object) {
        if ((n & 2) != 0) {
            dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
        }
        return dependencyTree.getDependencyTreeResolution(idePlugin, dependenciesModifier);
    }

    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull IdePlugin plugin) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return this.getTransitiveDependencies(plugin, new ResolutionContext(null, null, 3, null));
    }

    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull IdePlugin plugin, @NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
        Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
        return this.getTransitiveDependencies(plugin, new ResolutionContext(missingDependencyListener2, dependenciesModifier));
    }

    public static /* synthetic */ Set getTransitiveDependencies$default(DependencyTree dependencyTree, IdePlugin idePlugin, Function2 function2, DependenciesModifier dependenciesModifier, int n, Object object) throws IllegalArgumentException {
        if ((n & 2) != 0) {
            function2 = DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p();
        }
        if ((n & 4) != 0) {
            dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
        }
        return dependencyTree.getTransitiveDependencies(idePlugin, function2, dependenciesModifier);
    }

    private final Set<Dependency> getTransitiveDependencies(IdePlugin plugin, ResolutionContext dependencyResolutionContext) throws IllegalArgumentException {
        String string = plugin.getPluginId();
        if (string == null) {
            boolean bl = false;
            String string2 = this.missingId(plugin);
            throw new IllegalArgumentException(string2.toString());
        }
        String pluginId = string;
        DiGraph<String, Dependency> graph = this.getDependencyGraph(plugin, dependencyResolutionContext);
        return this.collectDependencies(graph, pluginId);
    }

    private final DiGraph<String, Dependency> getDependencyGraph(IdePlugin plugin, ResolutionContext context) {
        DiGraph<String, Dependency> graph = new DiGraph<String, Dependency>();
        this.getDependencyGraph(plugin, graph, 0, -1, -1, context);
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    private final void getDependencyGraph(IdePlugin plugin, DiGraph<String, Dependency> graph, int resolutionDepth, int dependencyIndex, int parentDependencyIndex, ResolutionContext context) {
        IdePlugin $this$with = plugin;
        boolean bl = false;
        List<PluginDependency> dependencies = context.getDependenciesModifier().apply($this$with, this.pluginProvider);
        String string = $this$with.getPluginId();
        if (string != null) {
            String pluginId = string;
            String number = dependencyIndex < 0 ? "" : dependencyIndex + 1 + ") ";
            String indent = this.getIndent(resolutionDepth, parentDependencyIndex);
            if (dependencies.isEmpty()) {
                this.debugLog(indent, number + "No dependencies for '{}'", pluginId);
            } else {
                this.debugLog(indent, number + "Resolving {} " + FormatUtilsKt.pluralize("dependency", dependencies.size()) + " for '{}': {}", dependencies.size(), pluginId, CollectionsKt.joinToString$default(dependencies, null, null, null, 0, null, getDependencyGraph.1.1.INSTANCE, 31, null));
                String nestedIndent = this.getNestedDependencyIndent(indent, number);
                Iterable $this$forEachIndexed$iv = dependencies;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void dep;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    PluginDependency pluginDependency = (PluginDependency)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    Dependency dependencyPlugin = this.getPluginOrModule(this.pluginProvider, dep.getId());
                    if (this.ignore(plugin, (PluginDependency)dep)) {
                        this.debugLog(nestedIndent, i + 1, "Ignoring '{}'", dep);
                        continue;
                    }
                    if (graph.contains(pluginId, dependencyPlugin)) {
                        this.debugLog(nestedIndent, i + 1, "Resolved cached dependency '{}'", dep.getId());
                        continue;
                    }
                    Dependency dependency = dependencyPlugin;
                    if (dependency instanceof Dependency.Module || dependency instanceof Dependency.Plugin) {
                        if (!(dependencyPlugin instanceof PluginAware) || dependencyPlugin.matches(pluginId)) continue;
                        graph.addEdge(pluginId, dependencyPlugin);
                        this.getDependencyGraph(((PluginAware)((Object)dependencyPlugin)).getPlugin(), graph, resolutionDepth + 1, i, dependencyIndex, context);
                        continue;
                    }
                    if (!(dependency instanceof Dependency.None)) continue;
                    context.notifyMissingDependency(plugin, (PluginDependency)dep);
                    this.debugLog(nestedIndent, i + 1, "Skipping dependency '{}' as it is not available in the IDE.", dep.getId());
                }
            }
        }
    }

    private final String getNestedDependencyIndent(String indent, String dependencyNumber) {
        int n = dependencyNumber.length();
        int n2 = 3;
        String additionalIndent = StringsKt.repeat(" ", Math.max(n, n2));
        return indent + additionalIndent;
    }

    private final String getIndent(int resolutionDepth, int parentDependencyIndex) {
        Object object;
        if (resolutionDepth <= 1) {
            object = "";
        } else {
            String suffix = parentDependencyIndex < 0 ? "" : StringsKt.repeat(" ", String.valueOf(parentDependencyIndex).length() - 1) + StringsKt.repeat(" ", resolutionDepth - 1);
            object = StringsKt.repeat("  ", resolutionDepth - 1) + suffix;
        }
        return object;
    }

    private final boolean ignore(IdePlugin plugin, PluginDependency dependency) {
        return dependency.isModule() && plugin.getDefinedModules().contains(dependency.getId());
    }

    private final String missingId(IdePlugin plugin) {
        String string = plugin.getPluginName();
        if (string == null) {
            string = "unknown name";
        }
        String name = string;
        Path path = plugin.getOriginalFile();
        Comparable originalFile = path != null ? (Comparable)path : (Comparable)((Object)"unknown plugin artifact path");
        return "Plugin must have an ID. Name: " + name + ". Path: " + originalFile;
    }

    private final Set<Dependency> collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id) {
        Set set;
        Set $this$apply = set = (Set)new LinkedHashSet();
        boolean bl = false;
        DependencyTree.collectDependencies$default(this, $this$collectDependencies, id, $this$apply, 0, 4, null);
        return set;
    }

    private final void collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id, Set<Dependency> dependencies, int layer) {
        for (Dependency dependency : $this$collectDependencies.get(id)) {
            String depId;
            if (!(dependency instanceof PluginAware)) continue;
            Intrinsics.checkNotNull(((PluginAware)((Object)dependency)).getPlugin().getPluginId());
            Dependency dep = layer == 0 ? dependency : this.asTransitive(dependency);
            if (dependencies.contains(dep)) continue;
            Collection collection = dependencies;
            collection.add(dep);
            this.collectDependencies($this$collectDependencies, depId, dependencies, layer + 1);
        }
    }

    static /* synthetic */ void collectDependencies$default(DependencyTree dependencyTree, DiGraph diGraph, String string, Set set, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        dependencyTree.collectDependencies(diGraph, string, set, n);
    }

    private final Dependency getPluginOrModule(PluginProvider $this$getPluginOrModule, String id) {
        Dependency dependency;
        IdePlugin plugin = $this$getPluginOrModule.findPluginById(id);
        if (plugin != null) {
            dependency = plugin instanceof IdeModule ? new Dependency.Module(plugin, id, false, 4, null) : new Dependency.Plugin(plugin, false, 2, null);
        } else {
            IdePlugin idePlugin = $this$getPluginOrModule.findPluginByModule(id);
            if (idePlugin != null) {
                IdePlugin idePlugin2;
                IdePlugin it = idePlugin2 = idePlugin;
                boolean bl = false;
                IdePlugin idePlugin3 = it;
                Intrinsics.checkNotNullExpressionValue(idePlugin3, "it");
                dependency = new Dependency.Module(idePlugin3, id, false, 4, null);
            } else {
                dependency = Dependency.None.INSTANCE;
            }
        }
        return dependency;
    }

    private final void toDebugString(DiGraph<String, Dependency> $this$toDebugString, String id, int indentSize, Set<String> visited, StringBuilder printer) {
        String indent = StringsKt.repeat("  ", indentSize);
        Iterable $this$forEach$iv = $this$toDebugString.get(id);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Object object;
            String depId;
            Dependency dep = (Dependency)element$iv;
            boolean bl = false;
            if (!(dep instanceof PluginAware)) continue;
            Intrinsics.checkNotNull(((PluginAware)((Object)dep)).getPlugin().getPluginId());
            if (!visited.contains(depId)) {
                object = visited;
                object.add(depId);
                object = printer;
                string = indent + "* " + dep;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
                this.toDebugString($this$toDebugString, depId, indentSize + 1, visited, printer);
                continue;
            }
            object = printer;
            string = indent + "* " + dep + " (already visited)";
            StringBuilder stringBuilder = ((StringBuilder)object).append(string);
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
        }
    }

    private final Dependency asTransitive(Dependency $this$asTransitive) {
        Dependency dependency;
        Dependency dependency2 = $this$asTransitive;
        if (dependency2 instanceof Dependency.Module) {
            dependency = Dependency.Module.copy$default((Dependency.Module)$this$asTransitive, null, null, true, 3, null);
        } else if (dependency2 instanceof Dependency.Plugin) {
            dependency = Dependency.Plugin.copy$default((Dependency.Plugin)$this$asTransitive, null, true, 1, null);
        } else if (dependency2 instanceof Dependency.None) {
            dependency = $this$asTransitive;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dependency;
    }

    @NotNull
    public final CharSequence toDebugString(@NotNull String pluginId) {
        StringBuilder stringBuilder;
        block0: {
            IdePlugin idePlugin;
            Intrinsics.checkNotNullParameter(pluginId, "pluginId");
            ResolutionContext resolutionContext = new ResolutionContext(DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p(), null, 2, null);
            StringBuilder $this$apply = stringBuilder = new StringBuilder();
            boolean bl = false;
            IdePlugin idePlugin2 = this.pluginProvider.findPluginById(pluginId);
            if (idePlugin2 == null) break block0;
            IdePlugin plugin = idePlugin = idePlugin2;
            boolean bl2 = false;
            IdePlugin idePlugin3 = plugin;
            Intrinsics.checkNotNullExpressionValue(idePlugin3, "plugin");
            this.toDebugString(this.getDependencyGraph(idePlugin3, resolutionContext), pluginId, 0, new LinkedHashSet(), $this$apply);
        }
        return stringBuilder;
    }

    private final void debugLog(String indent, String message2, Object ... params) {
        this.debugLog(indent, 0, message2, Arrays.copyOf(params, params.length));
    }

    private final void debugLog(String indent, int numericIndex, String message2, Object ... params) {
        if (DependencyTreeKt.access$getLOG$p().isDebugEnabled()) {
            StringBuilder stringBuilder;
            StringBuilder $this$buildString = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$buildString.append(indent);
            if (numericIndex > 0) {
                $this$buildString.append(numericIndex).append(") ");
            }
            $this$buildString.append(message2);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            String msg = string;
            DependencyTreeKt.access$getLOG$p().debug(msg, Arrays.copyOf(params, params.length));
        }
    }

    public DependencyTree(@NotNull PluginProvider pluginProvider) {
        Intrinsics.checkNotNullParameter(pluginProvider, "pluginProvider");
        this.pluginProvider = pluginProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\n2\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0014\u0012\u0004\u0012\u00020\n0\u0013H\u0000\u00a2\u0006\u0002\b\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u00142\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "I", "O", "", "()V", "adjacency", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addEdge", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "contains", "", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "forEachAdjacency", "action", "Lkotlin/Function2;", "", "forEachAdjacency$structure_intellij", "get", "(Ljava/lang/Object;)Ljava/util/List;", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,283:1\n361#2,7:284\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n*L\n264#1,7:284\n*E\n"})
    public static final class DiGraph<I, O> {
        private final HashMap<I, List<O>> adjacency = new HashMap();

        @NotNull
        public final List<O> get(I from) {
            List<Object> list = this.adjacency.get(from);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public final void addEdge(I from, O to) {
            Object object;
            Map $this$getOrPut$iv = this.adjacency;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(from);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Collection collection = (List)object;
            collection.add(to);
        }

        public final boolean contains(I from, O to) {
            List<O> list = this.adjacency.get(from);
            return list != null && list.contains(to);
        }

        public final void forEachAdjacency$structure_intellij(@NotNull Function2<? super I, ? super List<? extends O>, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            Function2<? super I, ? super List<? extends O>, Unit> function2 = action;
            this.adjacency.forEach(new BiConsumer(function2){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function2;
                }

                public final /* synthetic */ void accept(Object p0, Object p1) {
                    Intrinsics.checkNotNullExpressionValue(this.function.invoke(p0, p1), "invoke(...)");
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\tH\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR'\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$ResolutionContext;", "", "missingDependencyListener", "Lkotlin/Function2;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/MissingDependencyListener;", "dependenciesModifier", "Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "(Lkotlin/jvm/functions/Function2;Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;)V", "getDependenciesModifier", "()Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "getMissingDependencyListener", "()Lkotlin/jvm/functions/Function2;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "notifyMissingDependency", "plugin", "dependency", "toString", "", "structure-intellij"})
    private static final class ResolutionContext {
        @NotNull
        private final Function2<IdePlugin, PluginDependency, Unit> missingDependencyListener;
        @NotNull
        private final DependenciesModifier dependenciesModifier;

        public final void notifyMissingDependency(@NotNull IdePlugin plugin, @NotNull PluginDependency dependency) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(dependency, "dependency");
            this.missingDependencyListener.invoke(plugin, dependency);
        }

        @NotNull
        public final Function2<IdePlugin, PluginDependency, Unit> getMissingDependencyListener() {
            return this.missingDependencyListener;
        }

        @NotNull
        public final DependenciesModifier getDependenciesModifier() {
            return this.dependenciesModifier;
        }

        public ResolutionContext(@NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) {
            Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
            Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
            this.missingDependencyListener = missingDependencyListener2;
            this.dependenciesModifier = dependenciesModifier;
        }

        public /* synthetic */ ResolutionContext(Function2 function2, DependenciesModifier dependenciesModifier, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                function2 = DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p();
            }
            if ((n & 2) != 0) {
                dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
            }
            this(function2, dependenciesModifier);
        }

        public ResolutionContext() {
            this(null, null, 3, null);
        }

        @NotNull
        public final Function2<IdePlugin, PluginDependency, Unit> component1() {
            return this.missingDependencyListener;
        }

        @NotNull
        public final DependenciesModifier component2() {
            return this.dependenciesModifier;
        }

        @NotNull
        public final ResolutionContext copy(@NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) {
            Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
            Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
            return new ResolutionContext(missingDependencyListener2, dependenciesModifier);
        }

        public static /* synthetic */ ResolutionContext copy$default(ResolutionContext resolutionContext, Function2 function2, DependenciesModifier dependenciesModifier, int n, Object object) {
            if ((n & 1) != 0) {
                function2 = resolutionContext.missingDependencyListener;
            }
            if ((n & 2) != 0) {
                dependenciesModifier = resolutionContext.dependenciesModifier;
            }
            return resolutionContext.copy(function2, dependenciesModifier);
        }

        @NotNull
        public String toString() {
            return "ResolutionContext(missingDependencyListener=" + this.missingDependencyListener + ", dependenciesModifier=" + this.dependenciesModifier + ")";
        }

        public int hashCode() {
            Function2<IdePlugin, PluginDependency, Unit> function2 = this.missingDependencyListener;
            DependenciesModifier dependenciesModifier = this.dependenciesModifier;
            return (function2 != null ? function2.hashCode() : 0) * 31 + (dependenciesModifier != null ? dependenciesModifier.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ResolutionContext)) break block3;
                    ResolutionContext resolutionContext = (ResolutionContext)object;
                    if (!Intrinsics.areEqual(this.missingDependencyListener, resolutionContext.missingDependencyListener) || !Intrinsics.areEqual(this.dependenciesModifier, resolutionContext.dependenciesModifier)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

