/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.platform;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.ModuleBean;
import com.jetbrains.plugin.structure.intellij.extractor.ModuleUnmarshaller;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolver;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolverKt;
import com.jetbrains.plugin.structure.intellij.platform.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.platform.ModulesResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/platform/BundledModulesResolver;", "Lcom/jetbrains/plugin/structure/intellij/platform/ModulesResolver;", "idePath", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "getIdePath", "()Ljava/nio/file/Path;", "moduleDescriptorsJarPath", "resolveModules", "", "Lcom/jetbrains/plugin/structure/intellij/beans/ModuleBean;", "unmarshallModule", "xmlPath", "structure-intellij"})
public final class BundledModulesResolver
implements ModulesResolver {
    private final Path moduleDescriptorsJarPath;
    @NotNull
    private final Path idePath;
    private final JarFileSystemProvider fileSystemProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ModuleBean> resolveModules() {
        List<ModuleBean> list;
        Closeable closeable = this.fileSystemProvider.getFileSystem(this.moduleDescriptorsJarPath);
        Throwable throwable = null;
        try {
            List<ModuleBean> list2;
            FileSystem jarFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = jarFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, "jarFs.rootDirectories");
            Path path = CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue(path, "jarFs.rootDirectories.first()");
            Path root = path;
            AutoCloseable autoCloseable = Files.list(root);
            Throwable throwable2 = null;
            try {
                Stream files = (Stream)autoCloseable;
                boolean bl2 = false;
                Stream stream = files;
                Intrinsics.checkNotNullExpressionValue(stream, "files");
                list2 = SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.filter(StreamsKt.asSequence(stream), resolveModules.1.1.1.INSTANCE), (Function1)new Function1<Path, ModuleBean>(this){

                    @Nullable
                    public final ModuleBean invoke(@NotNull Path p1) {
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        return BundledModulesResolver.access$unmarshallModule((BundledModulesResolver)this.receiver, p1);
                    }
                }));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return list;
    }

    private final ModuleBean unmarshallModule(Path xmlPath) {
        try {
            return ModuleUnmarshaller.INSTANCE.unmarshall(xmlPath);
        }
        catch (JAXBException e) {
            BundledModulesResolverKt.access$getLOG$p().debug("Cannot unmarshall [{}/{}]: {}", this.moduleDescriptorsJarPath, xmlPath, e.getMessage());
            return null;
        }
    }

    @NotNull
    public final Path getIdePath() {
        return this.idePath;
    }

    public BundledModulesResolver(@NotNull Path idePath, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.idePath = idePath;
        this.fileSystemProvider = fileSystemProvider;
        Path path = this.idePath.resolve("modules").resolve("module-descriptors.jar");
        Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(MODULES_\u2026e(MODULE_DESCRIPTORS_JAR)");
        this.moduleDescriptorsJarPath = path;
        if (!FileUtilKt.exists(this.moduleDescriptorsJarPath)) {
            throw (Throwable)new InvalidIdeException("IDE path [" + this.idePath + "] does not contain 'modules/module-descriptors.jar' file");
        }
    }

    public static final /* synthetic */ ModuleBean access$unmarshallModule(BundledModulesResolver $this, Path xmlPath) {
        return $this.unmarshallModule(xmlPath);
    }
}

