/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.layout;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.layout.CorePluginManager;
import com.jetbrains.plugin.structure.ide.layout.CorePluginManagerKt;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentLoader;
import com.jetbrains.plugin.structure.ide.layout.LoadingResults;
import com.jetbrains.plugin.structure.ide.layout.PluginWithArtifactPathResult;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.resources.JarsResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\nJ\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/ide/layout/CorePluginManager;", "", "pluginLoader", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentLoader;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentLoader;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "descriptorPaths", "", "", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getDescriptorPaths", "(Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)[Ljava/lang/String;", "platformPrefix", "getPlatformPrefix", "(Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)Ljava/lang/String;", "assertCorePluginsPresent", "", "idePath", "Ljava/nio/file/Path;", "loadingResults", "Lcom/jetbrains/plugin/structure/ide/layout/LoadingResults;", "findDescriptor", "jarPath", "ideVersion", "loadCorePlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "loadPlugin", "Lcom/jetbrains/plugin/structure/ide/layout/PluginWithArtifactPathResult;", "platformResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nCorePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorePluginManager.kt\ncom/jetbrains/plugin/structure/ide/layout/CorePluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1603#2,9:97\n1855#2:106\n1856#2:108\n1612#2:109\n1#3:107\n*E\n*S KotlinDebug\n*F\n+ 1 CorePluginManager.kt\ncom/jetbrains/plugin/structure/ide/layout/CorePluginManager\n*L\n48#1,9:97\n48#1:106\n48#1:108\n48#1:109\n48#1:107\n*E\n"})
public final class CorePluginManager {
    private final LayoutComponentLoader pluginLoader;
    private final JarFileSystemProvider jarFileSystemProvider;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IdePlugin> loadCorePlugins(@NotNull Path idePath, @NotNull IdeVersion ideVersion) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Path path = idePath.resolve(CorePluginManagerKt.access$getLIB_DIRECTORY$p());
        Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(LIB_DIRECTORY)");
        List<Path> corePluginJarPaths = FileUtilKt.listJars(path);
        JarsResourceResolver corePluginJarsResolver = new JarsResourceResolver(corePluginJarPaths, this.jarFileSystemProvider);
        Function1 loadPlugin2 = new Function1<Path, PluginWithArtifactPathResult>(this, ideVersion, corePluginJarsResolver){
            final /* synthetic */ CorePluginManager this$0;
            final /* synthetic */ IdeVersion $ideVersion;
            final /* synthetic */ JarsResourceResolver $corePluginJarsResolver;

            @Nullable
            public final PluginWithArtifactPathResult invoke(@NotNull Path jarPath) {
                Intrinsics.checkNotNullParameter(jarPath, "jarPath");
                return CorePluginManager.access$loadPlugin(this.this$0, jarPath, this.$ideVersion, this.$corePluginJarsResolver);
            }
            {
                this.this$0 = corePluginManager2;
                this.$ideVersion = ideVersion;
                this.$corePluginJarsResolver = jarsResourceResolver;
                super(1);
            }
        };
        Iterable $this$mapNotNull$iv = corePluginJarPaths;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object r;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            if (loadPlugin2.invoke(element$iv$iv) == null) continue;
            Object it$iv$iv = r;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List loadedPlugins = (List)destination$iv$iv;
        LoadingResults loadingResults = new LoadingResults(loadedPlugins);
        PluginWithArtifactPathResult.Companion.logFailures$structure_ide(CorePluginManagerKt.access$getLOG$p(), loadingResults.getFailures(), idePath);
        this.assertCorePluginsPresent(idePath, loadingResults);
        return loadingResults.getSuccessfulPlugins();
    }

    private final void assertCorePluginsPresent(Path idePath, LoadingResults loadingResults) {
        if (loadingResults.getSuccessfulPlugins().isEmpty()) {
            throw (Throwable)new InvalidIdeException(idePath, "The 'Core' plugin (ID: 'com.intellij') is expected in the " + idePath + File.separator + CorePluginManagerKt.access$getLIB_DIRECTORY$p());
        }
    }

    private final PluginWithArtifactPathResult loadPlugin(Path jarPath, IdeVersion ideVersion, ResourceResolver platformResourceResolver) {
        PluginWithArtifactPathResult pluginWithArtifactPathResult;
        String string = this.findDescriptor(jarPath, ideVersion);
        if (string != null) {
            String string2;
            String descriptor2 = string2 = string;
            boolean bl = false;
            pluginWithArtifactPathResult = this.pluginLoader.load(jarPath, descriptor2, platformResourceResolver, ideVersion, "com.intellij");
        } else {
            pluginWithArtifactPathResult = null;
        }
        return pluginWithArtifactPathResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findDescriptor(Path jarPath, IdeVersion ideVersion) {
        String string;
        AutoCloseable autoCloseable = new PluginJar(jarPath, this.jarFileSystemProvider);
        Throwable throwable = null;
        try {
            PluginJar pluginJar = (PluginJar)autoCloseable;
            boolean bl = false;
            String[] stringArray = this.getDescriptorPaths(ideVersion);
            PluginDescriptorResult pluginDescriptorResult = pluginJar.getPluginDescriptor(Arrays.copyOf(stringArray, stringArray.length));
            string = pluginDescriptorResult instanceof PluginDescriptorResult.Found ? FileUtilKt.getSimpleName(((PluginDescriptorResult.Found)pluginDescriptorResult).getPath()) : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return string;
    }

    private final String[] getDescriptorPaths(IdeVersion $this$descriptorPaths) {
        descriptorPaths.1 $fun$div$1 = descriptorPaths.1.INSTANCE;
        return new String[]{$fun$div$1.invoke("META-INF", this.getPlatformPrefix($this$descriptorPaths) + "Plugin.xml"), $fun$div$1.invoke("META-INF", "plugin.xml"), $fun$div$1.invoke("META-INF", "PlatformLangPlugin.xml")};
    }

    private final String getPlatformPrefix(IdeVersion $this$platformPrefix) {
        IntelliJPlatformProduct platformProduct = IntelliJPlatformProduct.Companion.fromIdeVersion($this$platformPrefix);
        IntelliJPlatformProduct intelliJPlatformProduct = platformProduct;
        if (intelliJPlatformProduct == null) {
            intelliJPlatformProduct = IntelliJPlatformProduct.IDEA;
        }
        IntelliJPlatformProduct product = intelliJPlatformProduct;
        return product.getPlatformPrefix();
    }

    public CorePluginManager(@NotNull LayoutComponentLoader pluginLoader, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        Intrinsics.checkNotNullParameter(pluginLoader, "pluginLoader");
        Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
        this.pluginLoader = pluginLoader;
        this.jarFileSystemProvider = jarFileSystemProvider;
    }

    public static final /* synthetic */ PluginWithArtifactPathResult access$loadPlugin(CorePluginManager $this, Path jarPath, IdeVersion ideVersion, ResourceResolver platformResourceResolver) {
        return $this.loadPlugin(jarPath, ideVersion, platformResourceResolver);
    }
}

