/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.utils;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.metadata.Attributes;
import kotlinx.metadata.ClassKind;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.Visibility;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/classes/utils/KtClassNode;", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "metadata", "Lkotlinx/metadata/jvm/KotlinClassMetadata$Class;", "(Lorg/objectweb/asm/tree/ClassNode;Lkotlinx/metadata/jvm/KotlinClassMetadata$Class;)V", "cls", "Lkotlinx/metadata/KmClass;", "getCls", "()Lkotlinx/metadata/KmClass;", "isEnumClass", "", "()Z", "isInternal", "name", "", "getName", "()Ljava/lang/String;", "isInternalField", "fieldName", "isInternalFunction", "functionName", "jvmDescriptor", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nKtClassNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtClassNode.kt\ncom/jetbrains/plugin/structure/classes/utils/KtClassNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1747#2,3:36\n1747#2,3:39\n*E\n*S KotlinDebug\n*F\n+ 1 KtClassNode.kt\ncom/jetbrains/plugin/structure/classes/utils/KtClassNode\n*L\n24#1,3:36\n28#1,3:39\n*E\n"})
public final class KtClassNode {
    private final ClassNode classNode;
    private final KotlinClassMetadata.Class metadata;

    @NotNull
    public final String getName() {
        String string = this.classNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "classNode.name");
        return string;
    }

    public final boolean isInternal() {
        return Attributes.getVisibility(this.getCls()) == Visibility.INTERNAL;
    }

    public final boolean isEnumClass() {
        return Attributes.getKind(this.getCls()) == ClassKind.ENUM_CLASS;
    }

    public final boolean isInternalField(@NotNull String fieldName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fieldName, "fieldName");
            Iterable $this$any$iv = this.getCls().getProperties();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KmProperty it = (KmProperty)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getName(), fieldName) && Attributes.getVisibility(it) == Visibility.INTERNAL)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInternalFunction(@NotNull String functionName, @NotNull String jvmDescriptor2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        Intrinsics.checkNotNullParameter(jvmDescriptor2, "jvmDescriptor");
        Iterable $this$any$iv = this.getCls().getFunctions();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KmFunction it = (KmFunction)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getName(), functionName)) {
                JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature(it);
                if (Intrinsics.areEqual(jvmMethodSignature != null ? jvmMethodSignature.getDescriptor() : null, jvmDescriptor2) && Attributes.getVisibility(it) == Visibility.INTERNAL) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final KmClass getCls() {
        return this.metadata.getKmClass();
    }

    public KtClassNode(@NotNull ClassNode classNode, @NotNull KotlinClassMetadata.Class metadata2) {
        Intrinsics.checkNotNullParameter(classNode, "classNode");
        Intrinsics.checkNotNullParameter(metadata2, "metadata");
        this.classNode = classNode;
        this.metadata = metadata2;
    }
}

