/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String PROJECT_NAME_MACRO_NAME = "PROJECT_NAME";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    public static final String DEPRECATED_MODULE_DIR = "$MODULE_DIR$";
    public static final String MODULE_WORKING_DIR_NAME = "MODULE_WORKING_DIR";
    public static final String MODULE_WORKING_DIR = "$MODULE_WORKING_DIR$";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static volatile Map<String, String> ourGlobalMacrosForIde;
    private static volatile Map<String, String> ourGlobalMacrosForStandalone;

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        String moduleDir;
        if (moduleFilePath == null) {
            PathMacroUtil.$$$reportNull$$$0(0);
        }
        if (Strings.isEmpty(moduleDir = PathUtilRt.getParentPath(moduleFilePath))) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath(moduleDir);
        if (!Strings.isEmpty(moduleDirParent) && PathUtilRt.getFileName(moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName(moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        String string2 = Objects.requireNonNull(PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
        if (string2 == null) {
            PathMacroUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        return PathMacroUtil.getGlobalSystemMacros(true);
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros(boolean insideIde) {
        if (insideIde) {
            if (ourGlobalMacrosForIde == null) {
                ourGlobalMacrosForIde = PathMacroUtil.computeGlobalPathMacrosInsideIde();
            }
            Map<String, String> map2 = ourGlobalMacrosForIde;
            if (map2 == null) {
                PathMacroUtil.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (ourGlobalMacrosForStandalone == null) {
            ourGlobalMacrosForStandalone = PathMacroUtil.computeGlobalPathMacrosForStandaloneCode();
        }
        Map<String, String> map3 = ourGlobalMacrosForStandalone;
        if (map3 == null) {
            PathMacroUtil.$$$reportNull$$$0(3);
        }
        return map3;
    }

    private static Map<String, String> computeGlobalPathMacrosForStandaloneCode() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        String homePath = PathManager.getHomePath(false);
        if (homePath != null) {
            result2.put(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName(homePath));
            result2.put(APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName(PathManager.getConfigPath()));
            result2.put(APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName(PathManager.getPluginsPath()));
        }
        result2.put(USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
        return Collections.unmodifiableMap(result2);
    }

    private static Map<String, String> computeGlobalPathMacrosInsideIde() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName(PathManager.getHomePath()));
        result2.put(APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName(PathManager.getConfigPath()));
        result2.put(APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName(PathManager.getPluginsPath()));
        result2.put(USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
        return Collections.unmodifiableMap(result2);
    }

    @NotNull
    private static String computeUserHomePath() {
        String string2 = Strings.trimEnd(FileUtilRt.toSystemIndependentName(SystemProperties.getUserHome()), "/");
        if (string2 == null) {
            PathMacroUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        return PathMacroUtil.getGlobalSystemMacroValue(name, true);
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name, boolean insideIde) {
        return PathMacroUtil.getGlobalSystemMacros(insideIde).get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHomePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSystemMacros";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUserHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

