/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.FieldLocation;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001dR\u0014\u0010!\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0014\u0010\"\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR\u0014\u0010#\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0014\u0010$\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0016R\u0016\u0010+\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldAsm;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "containingClassFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "asmNode", "Lorg/objectweb/asm/tree/FieldNode;", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;Lorg/objectweb/asm/tree/FieldNode;)V", "accessType", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getAccessType", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "kotlin.jvm.PlatformType", "getAnnotations", "()Ljava/util/List;", "getContainingClassFile", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "descriptor", "", "getDescriptor", "()Ljava/lang/String;", "initialValue", "", "getInitialValue", "()Ljava/lang/Object;", "isDeprecated", "", "()Z", "isFinal", "isPackagePrivate", "isPrivate", "isProtected", "isPublic", "isStatic", "isSynthetic", "location", "Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "getLocation", "()Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "name", "getName", "signature", "getSignature", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nFieldAsm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldAsm.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/FieldAsm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class FieldAsm
implements Field {
    @NotNull
    private final ClassFile containingClassFile;
    @NotNull
    private final FieldNode asmNode;

    public FieldAsm(@NotNull ClassFile containingClassFile, @NotNull FieldNode asmNode) {
        Intrinsics.checkNotNullParameter(containingClassFile, "containingClassFile");
        Intrinsics.checkNotNullParameter(asmNode, "asmNode");
        this.containingClassFile = containingClassFile;
        this.asmNode = asmNode;
    }

    @Override
    @NotNull
    public ClassFile getContainingClassFile() {
        return this.containingClassFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FieldLocation getLocation() {
        String string2;
        ClassLocation classLocation = this.getContainingClassFile().getLocation();
        String string3 = this.getName();
        String string4 = this.getDescriptor();
        String string5 = this.getSignature();
        if (string5 != null) {
            void it;
            String string6;
            String string7 = string6 = string5;
            String string8 = string4;
            String string9 = string3;
            ClassLocation classLocation2 = classLocation;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            classLocation = classLocation2;
            string3 = string9;
            string4 = string8;
            string2 = bl2 ? string6 : null;
        } else {
            string2 = null;
        }
        Modifiers modifiers = new Modifiers(this.asmNode.access);
        String string10 = string2;
        String string11 = string4;
        String string12 = string3;
        ClassLocation classLocation3 = classLocation;
        return new FieldLocation(classLocation3, string12, string11, string10, modifiers);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.asmNode.name;
        Intrinsics.checkNotNullExpressionValue(string2, "asmNode.name");
        return string2;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        String string2 = this.asmNode.desc;
        Intrinsics.checkNotNullExpressionValue(string2, "asmNode.desc");
        return string2;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.asmNode.signature;
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        return BytecodeUtilKt.getAccessType(this.asmNode.access);
    }

    @Override
    @NotNull
    public List<AnnotationNode> getAnnotations() {
        List<AnnotationNode> list = this.asmNode.invisibleAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        List<AnnotationNode> list2 = this.asmNode.visibleAnnotations;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    public boolean isStatic() {
        return (this.asmNode.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.asmNode.access & 0x10) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.asmNode.access & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.asmNode.access & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.asmNode.access & 2) != 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return (this.asmNode.access & 1) == 0 && (this.asmNode.access & 4) == 0 && (this.asmNode.access & 2) == 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.asmNode.access & 0x20000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.asmNode.access & 0x1000) != 0;
    }

    @Override
    @Nullable
    public Object getInitialValue() {
        return this.asmNode.value;
    }
}

