/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.deprecated;

import com.jetbrains.pluginverifier.results.location.FieldLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.presentation.FieldTypeOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecationInfo;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedFieldUsage;", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedApiUsage;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "deprecationInfo", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecationInfo;", "(Lcom/jetbrains/pluginverifier/results/reference/FieldReference;Lcom/jetbrains/pluginverifier/results/location/FieldLocation;Lcom/jetbrains/pluginverifier/results/location/Location;Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecationInfo;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class DeprecatedFieldUsage
extends DeprecatedApiUsage {
    @NotNull
    private final FieldReference apiReference;
    @NotNull
    private final FieldLocation apiElement;
    @NotNull
    private final Location usageLocation;

    public DeprecatedFieldUsage(@NotNull FieldReference apiReference, @NotNull FieldLocation apiElement, @NotNull Location usageLocation, @NotNull DeprecationInfo deprecationInfo) {
        Intrinsics.checkNotNullParameter(apiReference, "apiReference");
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        Intrinsics.checkNotNullParameter(deprecationInfo, "deprecationInfo");
        super(deprecationInfo);
        this.apiReference = apiReference;
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public FieldReference getApiReference() {
        return this.apiReference;
    }

    @Override
    @NotNull
    public FieldLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Deprecated field usage";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Deprecated field " + LocationsPresentationKt.formatFieldLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, FieldTypeOption.NO_TYPE) + " access";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("Deprecated field " + LocationsPresentationKt.formatFieldLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, FieldTypeOption.FULL_TYPE) + " is");
        $this$_get_fullDescription__u24lambda_u240.append(" accessed in " + UsageLocationPresentationKt.formatUsageLocation(this.getUsageLocation()));
        if (this.getDeprecationInfo().getForRemoval()) {
            $this$_get_fullDescription__u24lambda_u240.append(". This field will be removed in ");
            String string2 = this.getDeprecationInfo().getUntilVersion();
            if (string2 == null) {
                string2 = "a future release";
            }
            $this$_get_fullDescription__u24lambda_u240.append(string2);
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof DeprecatedFieldUsage && Intrinsics.areEqual(this.getApiReference(), ((DeprecatedFieldUsage)other).getApiReference()) && Intrinsics.areEqual(this.getApiElement(), ((DeprecatedFieldUsage)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((DeprecatedFieldUsage)other).getUsageLocation()) && Intrinsics.areEqual(this.getDeprecationInfo(), ((DeprecatedFieldUsage)other).getDeprecationInfo());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiReference(), this.getApiElement(), this.getUsageLocation(), this.getDeprecationInfo()};
        return Objects.hash(objectArray);
    }
}

