/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.FieldLocation;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.FieldTypeOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0014\u0010\u001d\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/IllegalFieldAccessProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "fieldBytecodeReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "inaccessibleField", "Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "accessor", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "fieldAccess", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "(Lcom/jetbrains/pluginverifier/results/reference/FieldReference;Lcom/jetbrains/pluginverifier/results/location/FieldLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;Lcom/jetbrains/pluginverifier/results/access/AccessType;)V", "getAccessor", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "getFieldAccess", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getFieldBytecodeReference", "()Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInaccessibleField", "()Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class IllegalFieldAccessProblem
extends CompatibilityProblem {
    @NotNull
    private final FieldReference fieldBytecodeReference;
    @NotNull
    private final FieldLocation inaccessibleField;
    @NotNull
    private final MethodLocation accessor;
    @NotNull
    private final Instruction instruction;
    @NotNull
    private final AccessType fieldAccess;

    public IllegalFieldAccessProblem(@NotNull FieldReference fieldBytecodeReference, @NotNull FieldLocation inaccessibleField, @NotNull MethodLocation accessor, @NotNull Instruction instruction, @NotNull AccessType fieldAccess) {
        Intrinsics.checkNotNullParameter(fieldBytecodeReference, "fieldBytecodeReference");
        Intrinsics.checkNotNullParameter(inaccessibleField, "inaccessibleField");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter((Object)fieldAccess, "fieldAccess");
        this.fieldBytecodeReference = fieldBytecodeReference;
        this.inaccessibleField = inaccessibleField;
        this.accessor = accessor;
        this.instruction = instruction;
        this.fieldAccess = fieldAccess;
    }

    @NotNull
    public final FieldReference getFieldBytecodeReference() {
        return this.fieldBytecodeReference;
    }

    @NotNull
    public final FieldLocation getInaccessibleField() {
        return this.inaccessibleField;
    }

    @NotNull
    public final MethodLocation getAccessor() {
        return this.accessor;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @NotNull
    public final AccessType getFieldAccess() {
        return this.fieldAccess;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Illegal field access";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.fieldAccess, this.inaccessibleField};
        return FormatUtilsKt.formatMessage("Illegal access to a {0} field {1}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray;
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object[] objectArray2 = new Object[]{LocationsPresentationKt.formatMethodLocation(this.accessor, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.NO_PARAMETER_NAMES), this.instruction};
        $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("Method {0} contains a *{1}* instruction referencing ", objectArray2));
        String actualFieldPresentation = LocationsPresentationKt.formatFieldLocation(this.inaccessibleField, HostClassOption.FULL_HOST_NAME, FieldTypeOption.FULL_TYPE);
        if (Intrinsics.areEqual(this.fieldBytecodeReference.getHostClass().getClassName(), this.inaccessibleField.getHostClass().getClassName())) {
            objectArray = new Object[]{this.fieldAccess, actualFieldPresentation};
            $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("a {0} field {1} ", objectArray));
        } else {
            objectArray = new Object[]{ReferencesPresentationKt.formatFieldReference(this.fieldBytecodeReference, HostClassOption.FULL_HOST_NAME, FieldTypeOption.FULL_TYPE), this.fieldAccess, actualFieldPresentation};
            $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("{0} which is resolved to a {1} field {2} ", objectArray));
        }
        objectArray = new Object[]{LocationsPresentationKt.formatClassLocation(this.accessor.getHostClass(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS)};
        $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("inaccessible to a class {0}. ", objectArray));
        $this$_get_fullDescription__u24lambda_u240.append("This can lead to **IllegalAccessError** exception at runtime.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IllegalFieldAccessProblem && this.fieldAccess == ((IllegalFieldAccessProblem)other).fieldAccess && Intrinsics.areEqual(this.inaccessibleField, ((IllegalFieldAccessProblem)other).inaccessibleField) && Intrinsics.areEqual(this.accessor, ((IllegalFieldAccessProblem)other).accessor) && this.instruction == ((IllegalFieldAccessProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.fieldAccess, this.inaccessibleField, this.accessor, this.instruction};
        return Objects.hash(objectArray);
    }
}

