/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.response.sarif;

import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dymamic.DynamicPluginStatus;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.response.DependenciesGraphDto;
import com.jetbrains.pluginverifier.response.DynamicPluginStatusDto;
import com.jetbrains.pluginverifier.response.VerificationResultTypeDto;
import com.jetbrains.pluginverifier.response.VerifierServiceResultConverterKt;
import com.jetbrains.pluginverifier.response.sarif.AutomationDetails;
import com.jetbrains.pluginverifier.response.sarif.Driver;
import com.jetbrains.pluginverifier.response.sarif.InspectionResult;
import com.jetbrains.pluginverifier.response.sarif.InvocationStatus;
import com.jetbrains.pluginverifier.response.sarif.PluginVerificationResultSARIF;
import com.jetbrains.pluginverifier.response.sarif.PluginVerifierPropertiesBag;
import com.jetbrains.pluginverifier.response.sarif.Rule;
import com.jetbrains.pluginverifier.response.sarif.Runner;
import com.jetbrains.pluginverifier.response.sarif.SarifInspectionConverterKt;
import com.jetbrains.pluginverifier.response.sarif.SarifRulesConverterKt;
import com.jetbrains.pluginverifier.response.sarif.Tool;
import com.jetbrains.pluginverifier.response.sarif.VersionControlProvenance;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002\u001a(\u0010\u0007\u001a\u00020\b*\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\tH\u0002\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003*\u00020\tH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0002\u001a\n\u0010\u0012\u001a\u00020\b*\u00020\t\u00a8\u0006\u0013"}, d2={"toToolWithRules", "Lcom/jetbrains/pluginverifier/response/sarif/Tool;", "rules", "", "Lcom/jetbrains/pluginverifier/response/sarif/Rule;", "toVersionControlProvenance", "Lcom/jetbrains/pluginverifier/response/sarif/VersionControlProvenance;", "generateReport", "Lcom/jetbrains/pluginverifier/response/sarif/PluginVerificationResultSARIF;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "invocations", "Lcom/jetbrains/pluginverifier/response/sarif/InspectionResult;", "toAutomationDetails", "Lcom/jetbrains/pluginverifier/response/sarif/AutomationDetails;", "toInvocationStatus", "Lcom/jetbrains/pluginverifier/response/sarif/InvocationStatus;", "toPluginVerifierPropertiesBag", "Lcom/jetbrains/pluginverifier/response/sarif/PluginVerifierPropertiesBag;", "toSarif", "verifier-intellij"})
public final class SarifFormatConverterKt {
    @NotNull
    public static final PluginVerificationResultSARIF toSarif(@NotNull PluginVerificationResult $this$toSarif) {
        Intrinsics.checkNotNullParameter($this$toSarif, "<this>");
        PluginVerificationResult pluginVerificationResult = $this$toSarif;
        return pluginVerificationResult instanceof PluginVerificationResult.Verified ? SarifFormatConverterKt.generateReport($this$toSarif, SarifRulesConverterKt.buildRules((PluginVerificationResult.Verified)$this$toSarif), SarifInspectionConverterKt.buildVerifiedInspections((PluginVerificationResult.Verified)$this$toSarif)) : (pluginVerificationResult instanceof PluginVerificationResult.InvalidPlugin ? SarifFormatConverterKt.generateReport($this$toSarif, SarifRulesConverterKt.buildPluginStructureRules((PluginVerificationResult.InvalidPlugin)$this$toSarif), SarifInspectionConverterKt.buildPluginStructureInspections((PluginVerificationResult.InvalidPlugin)$this$toSarif)) : SarifFormatConverterKt.generateReport($this$toSarif, SarifRulesConverterKt.buildSingleRule($this$toSarif), SarifInspectionConverterKt.buildSingleInvocation($this$toSarif)));
    }

    private static final PluginVerificationResultSARIF generateReport(PluginVerificationResult $this$generateReport, List<Rule> rules, List<InspectionResult> invocations) {
        PluginVerifierPropertiesBag pluginVerifierPropertiesBag = SarifFormatConverterKt.toPluginVerifierPropertiesBag($this$generateReport);
        AutomationDetails automationDetails = SarifFormatConverterKt.toAutomationDetails($this$generateReport);
        List<VersionControlProvenance> list = SarifFormatConverterKt.toVersionControlProvenance();
        List<InvocationStatus> list2 = SarifFormatConverterKt.toInvocationStatus($this$generateReport);
        Tool tool = SarifFormatConverterKt.toToolWithRules(rules);
        return new PluginVerificationResultSARIF(null, CollectionsKt.listOf(new Runner(tool, invocations, automationDetails, null, list2, list, pluginVerifierPropertiesBag, 8, null)), 1, null);
    }

    private static final List<InvocationStatus> toInvocationStatus(PluginVerificationResult $this$toInvocationStatus) {
        VerificationResultTypeDto resultType;
        int n;
        PluginVerificationResult pluginVerificationResult = $this$toInvocationStatus;
        if (pluginVerificationResult instanceof PluginVerificationResult.NotFound ? true : pluginVerificationResult instanceof PluginVerificationResult.FailedToDownload) {
            n = 127;
        } else if (pluginVerificationResult instanceof PluginVerificationResult.InvalidPlugin) {
            n = 1;
        } else if (pluginVerificationResult instanceof PluginVerificationResult.Verified) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int code = n;
        boolean executionSuccessful = $this$toInvocationStatus instanceof PluginVerificationResult.Verified ? (resultType = VerifierServiceResultConverterKt.convertResultType((PluginVerificationResult.Verified)$this$toInvocationStatus)) != VerificationResultTypeDto.PROBLEMS && resultType != VerificationResultTypeDto.CRITICAL : false;
        String string2 = $this$toInvocationStatus.getVerificationVerdict();
        return CollectionsKt.listOf(new InvocationStatus(code, string2, executionSuccessful));
    }

    private static final AutomationDetails toAutomationDetails(PluginVerificationResult $this$toAutomationDetails) {
        PluginInfo plugin = $this$toAutomationDetails.getPlugin();
        return new AutomationDetails(plugin.getPresentableName() + " " + plugin.getPresentableSinceUntilRange(), null, 2, null);
    }

    private static final PluginVerifierPropertiesBag toPluginVerifierPropertiesBag(PluginVerificationResult $this$toPluginVerifierPropertiesBag) {
        VerificationResultTypeDto verificationResultTypeDto;
        DynamicPluginStatusDto dynamicPluginStatusDto;
        DependenciesGraphDto dependenciesGraph;
        DependenciesGraphDto dependenciesGraphDto = dependenciesGraph = $this$toPluginVerifierPropertiesBag instanceof PluginVerificationResult.Verified ? VerifierServiceResultConverterKt.convert(((PluginVerificationResult.Verified)$this$toPluginVerifierPropertiesBag).getDependenciesGraph()) : null;
        if ($this$toPluginVerifierPropertiesBag instanceof PluginVerificationResult.Verified) {
            DynamicPluginStatus dynamicPluginStatus = ((PluginVerificationResult.Verified)$this$toPluginVerifierPropertiesBag).getDynamicPluginStatus();
            dynamicPluginStatusDto = dynamicPluginStatus != null ? VerifierServiceResultConverterKt.convert(dynamicPluginStatus) : null;
        } else {
            dynamicPluginStatusDto = null;
        }
        DynamicPluginStatusDto dynamicPluginStatus = dynamicPluginStatusDto;
        PluginVerificationTarget pluginVerificationTarget = $this$toPluginVerifierPropertiesBag.getVerificationTarget();
        Intrinsics.checkNotNull(pluginVerificationTarget, "null cannot be cast to non-null type com.jetbrains.pluginverifier.PluginVerificationTarget.IDE");
        PluginVerificationTarget.IDE ideVersion = (PluginVerificationTarget.IDE)pluginVerificationTarget;
        PluginVerificationResult pluginVerificationResult = $this$toPluginVerifierPropertiesBag;
        if (pluginVerificationResult instanceof PluginVerificationResult.Verified) {
            verificationResultTypeDto = VerifierServiceResultConverterKt.convertResultType((PluginVerificationResult.Verified)$this$toPluginVerifierPropertiesBag);
        } else if (pluginVerificationResult instanceof PluginVerificationResult.NotFound ? true : pluginVerificationResult instanceof PluginVerificationResult.FailedToDownload) {
            verificationResultTypeDto = VerificationResultTypeDto.NON_DOWNLOADABLE;
        } else if (pluginVerificationResult instanceof PluginVerificationResult.InvalidPlugin) {
            verificationResultTypeDto = VerificationResultTypeDto.INVALID_PLUGIN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        VerificationResultTypeDto type2 = verificationResultTypeDto;
        String string2 = ideVersion.getIdeVersion().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.ideVersion.asString()");
        return new PluginVerifierPropertiesBag(string2, ideVersion.getJdkVersion().getJavaVersion(), type2, $this$toPluginVerifierPropertiesBag.getVerificationVerdict(), dependenciesGraph, dynamicPluginStatus);
    }

    private static final List<VersionControlProvenance> toVersionControlProvenance() {
        return CollectionsKt.listOf(new VersionControlProvenance("TODO()", null, 2, null));
    }

    private static final Tool toToolWithRules(List<Rule> rules) {
        return new Tool(new Driver(null, rules, 1, null));
    }
}

