/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.files;

import com.jetbrains.pluginverifier.repository.cleanup.IdleSweepPolicy;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import com.jetbrains.pluginverifier.repository.cleanup.SweepPolicy;
import com.jetbrains.pluginverifier.repository.files.AvailableFile;
import com.jetbrains.pluginverifier.repository.files.FileLockImpl;
import com.jetbrains.pluginverifier.repository.files.FileRepository;
import com.jetbrains.pluginverifier.repository.files.FileRepositoryResult;
import com.jetbrains.pluginverifier.repository.files.SpaceWeight;
import com.jetbrains.pluginverifier.repository.provider.EmptyResourceProvider;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import com.jetbrains.pluginverifier.repository.resources.AvailableResource;
import com.jetbrains.pluginverifier.repository.resources.EvictionPolicy;
import com.jetbrains.pluginverifier.repository.resources.ResourceInfo;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryResult;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B?\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aJ\u0013\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0006\u0010\"\u001a\u00020\u0016R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/repository/files/FileRepository;", "K", "", "resourceProvider", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "Ljava/nio/file/Path;", "sweepPolicy", "Lcom/jetbrains/pluginverifier/repository/cleanup/SweepPolicy;", "presentableName", "", "clock", "Ljava/time/Clock;", "(Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;Lcom/jetbrains/pluginverifier/repository/cleanup/SweepPolicy;Ljava/lang/String;Ljava/time/Clock;)V", "resourceRepository", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl;", "Lcom/jetbrains/pluginverifier/repository/files/SpaceWeight;", "add", "", "key", "resource", "(Ljava/lang/Object;Ljava/nio/file/Path;)Z", "cleanup", "", "getAllExistingKeys", "", "getAvailableFiles", "", "Lcom/jetbrains/pluginverifier/repository/files/AvailableFile;", "getFile", "Lcom/jetbrains/pluginverifier/repository/files/FileRepositoryResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/files/FileRepositoryResult;", "has", "(Ljava/lang/Object;)Z", "remove", "removeAll", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nFileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRepository.kt\ncom/jetbrains/pluginverifier/repository/files/FileRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1557#2:99\n1628#2,3:100\n*S KotlinDebug\n*F\n+ 1 FileRepository.kt\ncom/jetbrains/pluginverifier/repository/files/FileRepository\n*L\n76#1:99\n76#1:100,3\n*E\n"})
public final class FileRepository<K> {
    @NotNull
    private final ResourceRepositoryImpl<Path, K, SpaceWeight> resourceRepository;

    public FileRepository(@NotNull ResourceProvider<? super K, ? extends Path> resourceProvider, @NotNull SweepPolicy<K> sweepPolicy, @NotNull String presentableName2, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(resourceProvider, "resourceProvider");
        Intrinsics.checkNotNullParameter(sweepPolicy, "sweepPolicy");
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.resourceRepository = new ResourceRepositoryImpl<Path, K, ResourceWeight>((EvictionPolicy)sweepPolicy, clock, resourceProvider, new SpaceWeight(SpaceAmount.Companion.getZERO_SPACE()), resourceRepository.1.INSTANCE, resourceRepository.2.INSTANCE, presentableName2);
    }

    public /* synthetic */ FileRepository(ResourceProvider resourceProvider, SweepPolicy sweepPolicy, String string2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            resourceProvider = new EmptyResourceProvider();
        }
        if ((n & 2) != 0) {
            sweepPolicy = new IdleSweepPolicy();
        }
        if ((n & 4) != 0) {
            string2 = "FileRepository";
        }
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(resourceProvider, sweepPolicy, string2, clock);
    }

    @NotNull
    public final FileRepositoryResult getFile(K key) throws InterruptedException {
        FileRepositoryResult fileRepositoryResult;
        ResourceRepositoryResult<Path, SpaceWeight> $this$getFile_u24lambda_u240 = this.resourceRepository.get(key);
        boolean bl = false;
        ResourceRepositoryResult<Path, SpaceWeight> resourceRepositoryResult = $this$getFile_u24lambda_u240;
        if (resourceRepositoryResult instanceof ResourceRepositoryResult.Found) {
            fileRepositoryResult = new FileRepositoryResult.Found(new FileLockImpl(((ResourceRepositoryResult.Found)$this$getFile_u24lambda_u240).getLockedResource()));
        } else if (resourceRepositoryResult instanceof ResourceRepositoryResult.NotFound) {
            fileRepositoryResult = new FileRepositoryResult.NotFound(((ResourceRepositoryResult.NotFound)$this$getFile_u24lambda_u240).getReason());
        } else if (resourceRepositoryResult instanceof ResourceRepositoryResult.Failed) {
            fileRepositoryResult = new FileRepositoryResult.Failed(((ResourceRepositoryResult.Failed)$this$getFile_u24lambda_u240).getReason(), ((ResourceRepositoryResult.Failed)$this$getFile_u24lambda_u240).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return fileRepositoryResult;
    }

    public final boolean add(K key, @NotNull Path resource) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        return this.resourceRepository.add(key, resource);
    }

    public final boolean remove(K key) {
        return this.resourceRepository.remove(key);
    }

    public final void removeAll() {
        this.resourceRepository.removeAll();
    }

    public final boolean has(K key) {
        return this.resourceRepository.has(key);
    }

    @NotNull
    public final Set<K> getAllExistingKeys() {
        return this.resourceRepository.getAllExistingKeys();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AvailableFile<K>> getAvailableFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.resourceRepository.getAvailableResources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvailableResource availableResource = (AvailableResource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$getAvailableFiles_u24lambda_u242_u24lambda_u241 = it;
            boolean bl2 = false;
            collection.add(new AvailableFile($this$getAvailableFiles_u24lambda_u242_u24lambda_u241.getKey(), (ResourceInfo<? extends Path, SpaceWeight>)((ResourceInfo<Path, SpaceWeight>)$this$getAvailableFiles_u24lambda_u242_u24lambda_u241.getResourceInfo()), $this$getAvailableFiles_u24lambda_u242_u24lambda_u241.getUsageStatistic(), $this$getAvailableFiles_u24lambda_u242_u24lambda_u241.isLocked()));
        }
        return (List)destination$iv$iv;
    }

    public final void cleanup() {
        this.resourceRepository.cleanup();
    }

    public FileRepository() {
        this(null, null, null, null, 15, null);
    }
}

