/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.html;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.VersionComparatorUtil;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import com.jetbrains.pluginverifier.dependencies.presentation.DependenciesGraphPrettyPrinter;
import com.jetbrains.pluginverifier.misc.HtmlBuilder;
import com.jetbrains.pluginverifier.output.OutputOptions;
import com.jetbrains.pluginverifier.output.ResultPrinter;
import com.jetbrains.pluginverifier.output.html.HtmlResultPrinter;
import com.jetbrains.pluginverifier.warnings.PluginStructureWarning;
import java.io.Closeable;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\"\u0010\u0010\u001a\u00020\u000f*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001a\u0010\u0014\u001a\u00020\u000f*\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0014\u0010\u0017\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J-\u0010\u0018\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\b2\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u001b\u00a2\u0006\u0002\b\u001cH\u0002J\u001c\u0010\u0018\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002JH\u0010\u001e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u001f*\u00020\u00112\u0006\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"2\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u0002H\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0$0\u001bH\u0002J\u0014\u0010%\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/pluginverifier/output/html/HtmlResultPrinter;", "Lcom/jetbrains/pluginverifier/output/ResultPrinter;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "outputOptions", "Lcom/jetbrains/pluginverifier/output/OutputOptions;", "(Lcom/jetbrains/pluginverifier/PluginVerificationTarget;Lcom/jetbrains/pluginverifier/output/OutputOptions;)V", "getPluginStyle", "", "results", "", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "loadReportCss", "loadReportScript", "printResults", "", "appendPluginResults", "Lcom/jetbrains/pluginverifier/misc/HtmlBuilder;", "pluginResults", "pluginId", "doPrintResults", "printPluginResult", "result", "printProblemsAndWarnings", "printShortAndFullDescription", "shortDescription", "fullDescriptionBuilder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "fullDescription", "printShortAndFullDescriptionItems", "T", "title", "items", "", "mapper", "Lkotlin/Pair;", "printUpdateHeader", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nHtmlResultPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlResultPrinter.kt\ncom/jetbrains/pluginverifier/output/html/HtmlResultPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1747#2,3:209\n800#2,11:212\n1747#2,3:223\n1747#2,3:226\n1747#2,3:229\n*S KotlinDebug\n*F\n+ 1 HtmlResultPrinter.kt\ncom/jetbrains/pluginverifier/output/html/HtmlResultPrinter\n*L\n69#1:209,3\n72#1:212,11\n73#1:223,3\n76#1:226,3\n79#1:229,3\n*E\n"})
public final class HtmlResultPrinter
implements ResultPrinter {
    @NotNull
    private final PluginVerificationTarget verificationTarget;
    @NotNull
    private final OutputOptions outputOptions;

    public HtmlResultPrinter(@NotNull PluginVerificationTarget verificationTarget, @NotNull OutputOptions outputOptions) {
        Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
        Intrinsics.checkNotNullParameter(outputOptions, "outputOptions");
        this.verificationTarget = verificationTarget;
        this.outputOptions = outputOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printResults(@NotNull List<? extends PluginVerificationResult> results) {
        Intrinsics.checkNotNullParameter(results, "results");
        Path reportHtmlFile = this.outputOptions.getTargetReportDirectory(this.verificationTarget).resolve("report.html");
        Intrinsics.checkNotNullExpressionValue(reportHtmlFile, "reportHtmlFile");
        Closeable closeable = new PrintWriter(Files.newBufferedWriter(FileUtilKt.create(reportHtmlFile), new OpenOption[0]));
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            HtmlBuilder htmlBuilder = new HtmlBuilder(it);
            this.doPrintResults(htmlBuilder, results);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void doPrintResults(HtmlBuilder $this$doPrintResults, List<? extends PluginVerificationResult> results) {
        $this$doPrintResults.html(new Function0<Unit>($this$doPrintResults, this, results){
            final /* synthetic */ HtmlBuilder $this_doPrintResults;
            final /* synthetic */ HtmlResultPrinter this$0;
            final /* synthetic */ List<PluginVerificationResult> $results;
            {
                this.$this_doPrintResults = $receiver;
                this.this$0 = $receiver2;
                this.$results = $results;
                super(0);
            }

            public final void invoke() {
                this.$this_doPrintResults.head(new Function0<Unit>(this.$this_doPrintResults, this.this$0){
                    final /* synthetic */ HtmlBuilder $this_doPrintResults;
                    final /* synthetic */ HtmlResultPrinter this$0;
                    {
                        this.$this_doPrintResults = $receiver;
                        this.this$0 = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_doPrintResults.title("Verification result " + HtmlResultPrinter.access$getVerificationTarget$p(this.this$0));
                        HtmlBuilder.script$default(this.$this_doPrintResults, "https://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.9.1.min.js", "text/javascript", null, 4, null);
                        HtmlBuilder.script$default(this.$this_doPrintResults, "https://code.jquery.com/ui/1.9.2/jquery-ui.min.js", "text/javascript", null, 4, null);
                        this.$this_doPrintResults.link("stylesheet", "https://code.jquery.com/ui/1.9.2/themes/base/jquery-ui.css", "text/css");
                        this.$this_doPrintResults.style("text/css", new Function0<Unit>(this.$this_doPrintResults, this.this$0){
                            final /* synthetic */ HtmlBuilder $this_doPrintResults;
                            final /* synthetic */ HtmlResultPrinter this$0;
                            {
                                this.$this_doPrintResults = $receiver;
                                this.this$0 = $receiver2;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_doPrintResults.unsafe(HtmlResultPrinter.access$loadReportCss(this.this$0));
                            }
                        });
                    }
                });
                this.$this_doPrintResults.body(new Function0<Unit>(this.$this_doPrintResults, this.$results, this.this$0){
                    final /* synthetic */ HtmlBuilder $this_doPrintResults;
                    final /* synthetic */ List<PluginVerificationResult> $results;
                    final /* synthetic */ HtmlResultPrinter this$0;
                    {
                        this.$this_doPrintResults = $receiver;
                        this.$results = $results;
                        this.this$0 = $receiver2;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        this.$this_doPrintResults.h2(new Function0<Unit>(this.$this_doPrintResults, this.this$0){
                            final /* synthetic */ HtmlBuilder $this_doPrintResults;
                            final /* synthetic */ HtmlResultPrinter this$0;
                            {
                                this.$this_doPrintResults = $receiver;
                                this.this$0 = $receiver2;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_doPrintResults.unaryPlus(HtmlResultPrinter.access$getVerificationTarget$p(this.this$0).toString());
                            }
                        });
                        if (this.$results.isEmpty()) {
                            this.$this_doPrintResults.unaryPlus("No plugins checked");
                        } else {
                            void $this$forEach$iv;
                            void $this$groupByTo$iv$iv;
                            Iterable $this$sortedBy$iv = this.$results;
                            boolean $i$f$sortedBy = false;
                            Object $this$groupBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                public final int compare(T a, T b) {
                                    PluginVerificationResult it = (PluginVerificationResult)a;
                                    boolean bl = false;
                                    Comparable comparable = (Comparable)((Object)it.getPlugin().getPluginId());
                                    it = (PluginVerificationResult)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getPlugin().getPluginId()));
                                }
                            });
                            boolean $i$f$groupBy = false;
                            Object object = $this$groupBy$iv;
                            Map destination$iv$iv = new LinkedHashMap<K, V>();
                            boolean $i$f$groupByTo = false;
                            for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                Object object2;
                                PluginVerificationResult it = (PluginVerificationResult)element$iv$iv;
                                boolean bl = false;
                                String key$iv$iv = it.getPlugin().getPluginId();
                                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                boolean $i$f$getOrPut = false;
                                V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                if (value$iv$iv$iv == null) {
                                    boolean bl2 = false;
                                    List answer$iv$iv$iv = new ArrayList<E>();
                                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                    object2 = answer$iv$iv$iv;
                                } else {
                                    object2 = value$iv$iv$iv;
                                }
                                List list$iv$iv = (List)object2;
                                list$iv$iv.add(element$iv$iv);
                            }
                            $this$groupBy$iv = destination$iv$iv;
                            HtmlResultPrinter htmlResultPrinter = this.this$0;
                            object = this.$this_doPrintResults;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> entry = element$iv = iterator2.next();
                                boolean bl = false;
                                String pluginId = (String)entry.getKey();
                                List pluginResults = (List)entry.getValue();
                                HtmlResultPrinter.access$appendPluginResults(htmlResultPrinter, (HtmlBuilder)object, pluginResults, pluginId);
                            }
                        }
                        HtmlBuilder.script$default(this.$this_doPrintResults, null, null, new Function0<Unit>(this.$this_doPrintResults, this.this$0){
                            final /* synthetic */ HtmlBuilder $this_doPrintResults;
                            final /* synthetic */ HtmlResultPrinter this$0;
                            {
                                this.$this_doPrintResults = $receiver;
                                this.this$0 = $receiver2;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_doPrintResults.unsafe(HtmlResultPrinter.access$loadReportScript(this.this$0));
                            }
                        }, 3, null);
                    }
                });
            }
        });
    }

    private final void appendPluginResults(HtmlBuilder $this$appendPluginResults, List<? extends PluginVerificationResult> pluginResults, String pluginId) {
        $this$appendPluginResults.div("plugin " + this.getPluginStyle(pluginResults), new Function0<Unit>($this$appendPluginResults, pluginId, pluginResults, this){
            final /* synthetic */ HtmlBuilder $this_appendPluginResults;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List<PluginVerificationResult> $pluginResults;
            final /* synthetic */ HtmlResultPrinter this$0;
            {
                this.$this_appendPluginResults = $receiver;
                this.$pluginId = $pluginId;
                this.$pluginResults = $pluginResults;
                this.this$0 = $receiver2;
                super(0);
            }

            public final void invoke() {
                this.$this_appendPluginResults.h3(new Function0<Unit>(this.$this_appendPluginResults, this.$pluginId){
                    final /* synthetic */ HtmlBuilder $this_appendPluginResults;
                    final /* synthetic */ String $pluginId;
                    {
                        this.$this_appendPluginResults = $receiver;
                        this.$pluginId = $pluginId;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_appendPluginResults.span("pMarker", new Function0<Unit>(this.$this_appendPluginResults){
                            final /* synthetic */ HtmlBuilder $this_appendPluginResults;
                            {
                                this.$this_appendPluginResults = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_appendPluginResults.unaryPlus("    ");
                            }
                        });
                        this.$this_appendPluginResults.unaryPlus(this.$pluginId);
                    }
                });
                HtmlBuilder.div$default(this.$this_appendPluginResults, null, new Function0<Unit>(this.$pluginResults, this.this$0, this.$this_appendPluginResults){
                    final /* synthetic */ List<PluginVerificationResult> $pluginResults;
                    final /* synthetic */ HtmlResultPrinter this$0;
                    final /* synthetic */ HtmlBuilder $this_appendPluginResults;
                    {
                        this.$pluginResults = $pluginResults;
                        this.this$0 = $receiver;
                        this.$this_appendPluginResults = $receiver2;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        Iterable iterable = this.$pluginResults;
                        Comparator<String> comparator = VersionComparatorUtil.COMPARATOR;
                        Intrinsics.checkNotNullExpressionValue(comparator, "COMPARATOR");
                        Object object = comparator;
                        object = CollectionsKt.sortedWith(iterable, new Comparator((Comparator)object){
                            final /* synthetic */ Comparator $comparator;
                            {
                                this.$comparator = $comparator;
                            }

                            public final int compare(T a, T b) {
                                PluginVerificationResult pluginVerificationResult = (PluginVerificationResult)b;
                                Comparator comparator = this.$comparator;
                                boolean bl = false;
                                PluginVerificationResult it = (PluginVerificationResult)a;
                                String string2 = it.getPlugin().getVersion();
                                bl = false;
                                String string3 = it.getPlugin().getVersion();
                                return comparator.compare(string2, string3);
                            }
                        });
                        HtmlResultPrinter htmlResultPrinter = this.this$0;
                        HtmlBuilder htmlBuilder = this.$this_appendPluginResults;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            PluginVerificationResult it = (PluginVerificationResult)element$iv;
                            boolean bl = false;
                            HtmlResultPrinter.access$printPluginResult(htmlResultPrinter, htmlBuilder, it);
                        }
                    }
                }, 1, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String getPluginStyle(List<? extends PluginVerificationResult> results) {
        boolean bl;
        block20: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List verifiedResults;
            block19: {
                boolean bl3;
                block18: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Object element$iv2;
                    boolean bl4;
                    block17: {
                        Iterable $this$any$iv2 = results;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                PluginVerificationResult it = (PluginVerificationResult)element$iv2;
                                boolean bl5 = false;
                                if (!(it instanceof PluginVerificationResult.InvalidPlugin)) continue;
                                bl4 = true;
                                break block17;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        return "badPlugin";
                    }
                    Iterable $this$filterIsInstance$iv = results;
                    boolean $i$f$filterIsInstance = false;
                    element$iv2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PluginVerificationResult.Verified)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    verifiedResults = (List)destination$iv$iv;
                    $this$any$iv = verifiedResults;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            PluginVerificationResult.Verified it = (PluginVerificationResult.Verified)element$iv3;
                            boolean bl6 = false;
                            if (!it.getHasCompatibilityProblems()) continue;
                            bl3 = true;
                            break block18;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return "pluginHasProblems";
                }
                $this$any$iv = verifiedResults;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        PluginVerificationResult.Verified it = (PluginVerificationResult.Verified)element$iv3;
                        boolean bl7 = false;
                        if (!it.getHasDirectMissingMandatoryDependencies()) continue;
                        bl2 = true;
                        break block19;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return "missingDeps";
            }
            $this$any$iv = verifiedResults;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    PluginVerificationResult.Verified it = (PluginVerificationResult.Verified)element$iv3;
                    boolean bl8 = false;
                    if (!it.getHasCompatibilityWarnings()) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            return "warnings";
        }
        return "pluginOk";
    }

    private final void printPluginResult(HtmlBuilder $this$printPluginResult, PluginVerificationResult result2) {
        String string2;
        PluginVerificationResult pluginVerificationResult = result2;
        if (pluginVerificationResult instanceof PluginVerificationResult.Verified) {
            string2 = ((PluginVerificationResult.Verified)result2).getHasCompatibilityWarnings() ? "warnings" : (((PluginVerificationResult.Verified)result2).getHasDirectMissingMandatoryDependencies() ? "missingDeps" : (((PluginVerificationResult.Verified)result2).getHasCompatibilityProblems() ? "updateHasProblems" : "updateOk"));
        } else if (pluginVerificationResult instanceof PluginVerificationResult.InvalidPlugin) {
            string2 = "badPlugin";
        } else if (pluginVerificationResult instanceof PluginVerificationResult.NotFound) {
            string2 = "notFound";
        } else if (pluginVerificationResult instanceof PluginVerificationResult.FailedToDownload) {
            string2 = "failedToDownload";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String resultStyle = string2;
        $this$printPluginResult.div("update " + resultStyle, new Function0<Unit>($this$printPluginResult, this, result2){
            final /* synthetic */ HtmlBuilder $this_printPluginResult;
            final /* synthetic */ HtmlResultPrinter this$0;
            final /* synthetic */ PluginVerificationResult $result;
            {
                this.$this_printPluginResult = $receiver;
                this.this$0 = $receiver2;
                this.$result = $result;
                super(0);
            }

            public final void invoke() {
                this.$this_printPluginResult.h3(new Function0<Unit>(this.this$0, this.$this_printPluginResult, this.$result){
                    final /* synthetic */ HtmlResultPrinter this$0;
                    final /* synthetic */ HtmlBuilder $this_printPluginResult;
                    final /* synthetic */ PluginVerificationResult $result;
                    {
                        this.this$0 = $receiver;
                        this.$this_printPluginResult = $receiver2;
                        this.$result = $result;
                        super(0);
                    }

                    public final void invoke() {
                        HtmlResultPrinter.access$printUpdateHeader(this.this$0, this.$this_printPluginResult, this.$result);
                    }
                });
                HtmlBuilder.div$default(this.$this_printPluginResult, null, new Function0<Unit>(this.this$0, this.$this_printPluginResult, this.$result){
                    final /* synthetic */ HtmlResultPrinter this$0;
                    final /* synthetic */ HtmlBuilder $this_printPluginResult;
                    final /* synthetic */ PluginVerificationResult $result;
                    {
                        this.this$0 = $receiver;
                        this.$this_printPluginResult = $receiver2;
                        this.$result = $result;
                        super(0);
                    }

                    public final void invoke() {
                        HtmlResultPrinter.access$printProblemsAndWarnings(this.this$0, this.$this_printPluginResult, this.$result);
                    }
                }, 1, null);
            }
        });
    }

    private final void printUpdateHeader(HtmlBuilder $this$printUpdateHeader, PluginVerificationResult result2) {
        $this$printUpdateHeader.span("uMarker", new Function0<Unit>($this$printUpdateHeader){
            final /* synthetic */ HtmlBuilder $this_printUpdateHeader;
            {
                this.$this_printUpdateHeader = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_printUpdateHeader.unaryPlus("    ");
            }
        });
        $this$printUpdateHeader.unaryPlus(result2.getPlugin().getVersion());
        $this$printUpdateHeader.small(new Function0<Unit>($this$printUpdateHeader, result2){
            final /* synthetic */ HtmlBuilder $this_printUpdateHeader;
            final /* synthetic */ PluginVerificationResult $result;
            {
                this.$this_printUpdateHeader = $receiver;
                this.$result = $result;
                super(0);
            }

            public final void invoke() {
                this.$this_printUpdateHeader.unaryPlus(this.$result.getPlugin().toString());
            }
        });
        $this$printUpdateHeader.small(new Function0<Unit>($this$printUpdateHeader, result2){
            final /* synthetic */ HtmlBuilder $this_printUpdateHeader;
            final /* synthetic */ PluginVerificationResult $result;
            {
                this.$this_printUpdateHeader = $receiver;
                this.$result = $result;
                super(0);
            }

            public final void invoke() {
                this.$this_printUpdateHeader.unaryPlus(this.$result.getVerificationVerdict());
            }
        });
    }

    private final void printProblemsAndWarnings(HtmlBuilder $this$printProblemsAndWarnings, PluginVerificationResult result2) {
        PluginVerificationResult $this$printProblemsAndWarnings_u24lambda_u245 = result2;
        boolean bl = false;
        PluginVerificationResult pluginVerificationResult = $this$printProblemsAndWarnings_u24lambda_u245;
        if (pluginVerificationResult instanceof PluginVerificationResult.InvalidPlugin) {
            this.printShortAndFullDescription($this$printProblemsAndWarnings, CollectionsKt.joinToString$default(((PluginVerificationResult.InvalidPlugin)$this$printProblemsAndWarnings_u24lambda_u245).getPluginStructureErrors(), null, null, null, 0, null, null, 63, null), result2.getPlugin().getPluginId());
        } else if (pluginVerificationResult instanceof PluginVerificationResult.NotFound) {
            this.printShortAndFullDescription($this$printProblemsAndWarnings, "Plugin " + result2.getPlugin() + " is not found in the Repository", ((PluginVerificationResult.NotFound)$this$printProblemsAndWarnings_u24lambda_u245).getNotFoundReason());
        } else if (pluginVerificationResult instanceof PluginVerificationResult.FailedToDownload) {
            this.printShortAndFullDescription($this$printProblemsAndWarnings, "Plugin " + result2.getPlugin() + " is not downloaded from the Repository", ((PluginVerificationResult.FailedToDownload)$this$printProblemsAndWarnings_u24lambda_u245).getFailedToDownloadReason());
        } else if (pluginVerificationResult instanceof PluginVerificationResult.Verified) {
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Compatibility problems", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getCompatibilityProblems(), printProblemsAndWarnings.1.1.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Compatibility warnings", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getCompatibilityWarnings(), printProblemsAndWarnings.1.2.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Deprecated API usages", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getDeprecatedUsages(), printProblemsAndWarnings.1.3.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Experimental API usages", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getExperimentalApiUsages(), printProblemsAndWarnings.1.4.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Internal API usages", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getInternalApiUsages(), printProblemsAndWarnings.1.5.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Non-extendable API usages", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getNonExtendableApiUsages(), printProblemsAndWarnings.1.6.INSTANCE);
            this.printShortAndFullDescriptionItems($this$printProblemsAndWarnings, "Override-only API usages", ((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getOverrideOnlyMethodUsages(), printProblemsAndWarnings.1.7.INSTANCE);
            if (!((Collection)((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getPluginStructureWarnings()).isEmpty()) {
                this.printShortAndFullDescription($this$printProblemsAndWarnings, "Plugin structure defects", (Function1<? super HtmlBuilder, Unit>)new Function1<HtmlBuilder, Unit>($this$printProblemsAndWarnings_u24lambda_u245){
                    final /* synthetic */ PluginVerificationResult $this_with;
                    {
                        this.$this_with = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HtmlBuilder $this$printShortAndFullDescription) {
                        Intrinsics.checkNotNullParameter($this$printShortAndFullDescription, "$this$printShortAndFullDescription");
                        $this$printShortAndFullDescription.ul(new Function0<Unit>(this.$this_with, $this$printShortAndFullDescription){
                            final /* synthetic */ PluginVerificationResult $this_with;
                            final /* synthetic */ HtmlBuilder $this_printShortAndFullDescription;
                            {
                                this.$this_with = $receiver;
                                this.$this_printShortAndFullDescription = $this_printShortAndFullDescription;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$forEach$iv;
                                Iterable iterable = ((PluginVerificationResult.Verified)this.$this_with).getPluginStructureWarnings();
                                HtmlBuilder htmlBuilder = this.$this_printShortAndFullDescription;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PluginStructureWarning it = (PluginStructureWarning)element$iv;
                                    boolean bl = false;
                                    htmlBuilder.li(new Function0<Unit>(htmlBuilder, it){
                                        final /* synthetic */ HtmlBuilder $this_printShortAndFullDescription;
                                        final /* synthetic */ PluginStructureWarning $it;
                                        {
                                            this.$this_printShortAndFullDescription = $this_printShortAndFullDescription;
                                            this.$it = $it;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.$this_printShortAndFullDescription.unaryPlus(this.$it.getMessage());
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
            if (!((Collection)((PluginVerificationResult.Verified)$this$printProblemsAndWarnings_u24lambda_u245).getDirectMissingMandatoryDependencies()).isEmpty()) {
                this.printShortAndFullDescription($this$printProblemsAndWarnings, "Missing dependencies", (Function1<? super HtmlBuilder, Unit>)new Function1<HtmlBuilder, Unit>($this$printProblemsAndWarnings_u24lambda_u245){
                    final /* synthetic */ PluginVerificationResult $this_with;
                    {
                        this.$this_with = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HtmlBuilder $this$printShortAndFullDescription) {
                        Intrinsics.checkNotNullParameter($this$printShortAndFullDescription, "$this$printShortAndFullDescription");
                        Iterable $this$forEach$iv = ((PluginVerificationResult.Verified)this.$this_with).getDirectMissingMandatoryDependencies();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            MissingDependency it = (MissingDependency)element$iv;
                            boolean bl = false;
                            $this$printShortAndFullDescription.unaryPlus(it.getMissingReason());
                        }
                    }
                });
            }
            this.printShortAndFullDescription($this$printProblemsAndWarnings, "Dependencies used on verification", (Function1<? super HtmlBuilder, Unit>)new Function1<HtmlBuilder, Unit>($this$printProblemsAndWarnings_u24lambda_u245){
                final /* synthetic */ PluginVerificationResult $this_with;
                {
                    this.$this_with = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HtmlBuilder $this$printShortAndFullDescription) {
                    Intrinsics.checkNotNullParameter($this$printShortAndFullDescription, "$this$printShortAndFullDescription");
                    String graphPresentation = new DependenciesGraphPrettyPrinter(((PluginVerificationResult.Verified)this.$this_with).getDependenciesGraph()).prettyPresentation();
                    Iterable $this$forEach$iv = StringsKt.lines(graphPresentation);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String line = (String)element$iv;
                        boolean bl = false;
                        $this$printShortAndFullDescription.unaryPlus(line);
                        $this$printShortAndFullDescription.br();
                    }
                }
            });
        }
    }

    private final String loadReportScript() {
        URL uRL = HtmlResultPrinter.class.getResource("/reportScript.js");
        Intrinsics.checkNotNullExpressionValue(uRL, "HtmlResultPrinter::class\u2026ource(\"/reportScript.js\")");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL2);
        return new String(byArray, charset);
    }

    private final String loadReportCss() {
        URL uRL = HtmlResultPrinter.class.getResource("/reportCss.css");
        Intrinsics.checkNotNullExpressionValue(uRL, "HtmlResultPrinter::class\u2026esource(\"/reportCss.css\")");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL2);
        return new String(byArray, charset);
    }

    private final <T> void printShortAndFullDescriptionItems(HtmlBuilder $this$printShortAndFullDescriptionItems, String title2, Set<? extends T> items, Function1<? super T, Pair<String, String>> mapper) {
        if (items.isEmpty()) {
            return;
        }
        $this$printShortAndFullDescriptionItems.p(new Function0<Unit>(this, $this$printShortAndFullDescriptionItems, title2, items, mapper){
            final /* synthetic */ HtmlResultPrinter this$0;
            final /* synthetic */ HtmlBuilder $this_printShortAndFullDescriptionItems;
            final /* synthetic */ String $title;
            final /* synthetic */ Set<T> $items;
            final /* synthetic */ Function1<T, Pair<String, String>> $mapper;
            {
                this.this$0 = $receiver;
                this.$this_printShortAndFullDescriptionItems = $receiver2;
                this.$title = $title;
                this.$items = $items;
                this.$mapper = $mapper;
                super(0);
            }

            public final void invoke() {
                HtmlResultPrinter.access$printShortAndFullDescription(this.this$0, this.$this_printShortAndFullDescriptionItems, this.$title, new Function1<HtmlBuilder, Unit>(this.$items, this.$mapper, this.this$0){
                    final /* synthetic */ Set<T> $items;
                    final /* synthetic */ Function1<T, Pair<String, String>> $mapper;
                    final /* synthetic */ HtmlResultPrinter this$0;
                    {
                        this.$items = $items;
                        this.$mapper = $mapper;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull HtmlBuilder $this$printShortAndFullDescription) {
                        void $this$forEach$iv;
                        void $this$groupByTo$iv$iv;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter($this$printShortAndFullDescription, "$this$printShortAndFullDescription");
                        Iterable iterable = this.$items;
                        Function1<T, Pair<String, String>> transform$iv = this.$mapper;
                        boolean $i$f$map22 = false;
                        Iterator<Map.Entry<K, V>> iterator2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
                        }
                        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy = false;
                        Object $this$groupBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                            public final int compare(T a, T b) {
                                Pair it = (Pair)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                                it = (Pair)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getFirst())));
                            }
                        });
                        boolean $i$f$groupBy = false;
                        Iterable $i$f$map22 = $this$groupBy$iv;
                        Map destination$iv$iv2 = new LinkedHashMap<K, V>();
                        boolean $i$f$groupByTo = false;
                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                            Object object;
                            Pair it = (Pair)element$iv$iv;
                            boolean bl = false;
                            String key$iv$iv = (String)it.getFirst();
                            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                            boolean $i$f$getOrPut = false;
                            V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl2 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object = answer$iv$iv$iv;
                            } else {
                                object = value$iv$iv$iv;
                            }
                            List list$iv$iv = (List)object;
                            list$iv$iv.add(element$iv$iv);
                        }
                        $this$groupBy$iv = destination$iv$iv2;
                        HtmlResultPrinter htmlResultPrinter = this.this$0;
                        boolean $i$f$forEach = false;
                        for (Map.Entry<K, V> element$iv : $this$forEach$iv.entrySet()) {
                            Map.Entry<K, V> entry = element$iv;
                            boolean bl = false;
                            String shortDesc = (String)entry.getKey();
                            List fullDescriptions = (List)entry.getValue();
                            String allProblems = CollectionsKt.joinToString$default(fullDescriptions, "\n", null, null, 0, null, null, 62, null);
                            HtmlResultPrinter.access$printShortAndFullDescription(htmlResultPrinter, $this$printShortAndFullDescription, shortDesc, allProblems);
                        }
                    }
                });
            }
        });
    }

    private final void printShortAndFullDescription(HtmlBuilder $this$printShortAndFullDescription, String shortDescription, String fullDescription2) {
        this.printShortAndFullDescription($this$printShortAndFullDescription, shortDescription, (Function1<? super HtmlBuilder, Unit>)new Function1<HtmlBuilder, Unit>(fullDescription2){
            final /* synthetic */ String $fullDescription;
            {
                this.$fullDescription = $fullDescription;
                super(1);
            }

            public final void invoke(@NotNull HtmlBuilder $this$printShortAndFullDescription) {
                Intrinsics.checkNotNullParameter($this$printShortAndFullDescription, "$this$printShortAndFullDescription");
                $this$printShortAndFullDescription.unaryPlus(this.$fullDescription);
            }
        });
    }

    private final void printShortAndFullDescription(HtmlBuilder $this$printShortAndFullDescription, String shortDescription, Function1<? super HtmlBuilder, Unit> fullDescriptionBuilder) {
        $this$printShortAndFullDescription.div("shortDescription", new Function0<Unit>($this$printShortAndFullDescription, shortDescription, fullDescriptionBuilder){
            final /* synthetic */ HtmlBuilder $this_printShortAndFullDescription;
            final /* synthetic */ String $shortDescription;
            final /* synthetic */ Function1<HtmlBuilder, Unit> $fullDescriptionBuilder;
            {
                this.$this_printShortAndFullDescription = $receiver;
                this.$shortDescription = $shortDescription;
                this.$fullDescriptionBuilder = $fullDescriptionBuilder;
                super(0);
            }

            public final void invoke() {
                this.$this_printShortAndFullDescription.unaryPlus(this.$shortDescription);
                this.$this_printShortAndFullDescription.unaryPlus(" ");
                this.$this_printShortAndFullDescription.a("#", "detailsLink", new Function0<Unit>(this.$this_printShortAndFullDescription){
                    final /* synthetic */ HtmlBuilder $this_printShortAndFullDescription;
                    {
                        this.$this_printShortAndFullDescription = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_printShortAndFullDescription.unaryPlus("details");
                    }
                });
                this.$this_printShortAndFullDescription.div("longDescription", new Function0<Unit>(this.$fullDescriptionBuilder, this.$this_printShortAndFullDescription){
                    final /* synthetic */ Function1<HtmlBuilder, Unit> $fullDescriptionBuilder;
                    final /* synthetic */ HtmlBuilder $this_printShortAndFullDescription;
                    {
                        this.$fullDescriptionBuilder = $fullDescriptionBuilder;
                        this.$this_printShortAndFullDescription = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$fullDescriptionBuilder.invoke(this.$this_printShortAndFullDescription);
                    }
                });
            }
        });
    }

    public static final /* synthetic */ PluginVerificationTarget access$getVerificationTarget$p(HtmlResultPrinter $this) {
        return $this.verificationTarget;
    }

    public static final /* synthetic */ String access$loadReportCss(HtmlResultPrinter $this) {
        return $this.loadReportCss();
    }

    public static final /* synthetic */ String access$loadReportScript(HtmlResultPrinter $this) {
        return $this.loadReportScript();
    }

    public static final /* synthetic */ void access$appendPluginResults(HtmlResultPrinter $this, HtmlBuilder $receiver, List pluginResults, String pluginId) {
        $this.appendPluginResults($receiver, pluginResults, pluginId);
    }

    public static final /* synthetic */ void access$printPluginResult(HtmlResultPrinter $this, HtmlBuilder $receiver, PluginVerificationResult result2) {
        $this.printPluginResult($receiver, result2);
    }

    public static final /* synthetic */ void access$printUpdateHeader(HtmlResultPrinter $this, HtmlBuilder $receiver, PluginVerificationResult result2) {
        $this.printUpdateHeader($receiver, result2);
    }

    public static final /* synthetic */ void access$printProblemsAndWarnings(HtmlResultPrinter $this, HtmlBuilder $receiver, PluginVerificationResult result2) {
        $this.printProblemsAndWarnings($receiver, result2);
    }

    public static final /* synthetic */ void access$printShortAndFullDescription(HtmlResultPrinter $this, HtmlBuilder $receiver, String shortDescription, Function1 fullDescriptionBuilder) {
        $this.printShortAndFullDescription($receiver, shortDescription, fullDescriptionBuilder);
    }

    public static final /* synthetic */ void access$printShortAndFullDescription(HtmlResultPrinter $this, HtmlBuilder $receiver, String shortDescription, String fullDescription2) {
        $this.printShortAndFullDescription($receiver, shortDescription, fullDescription2);
    }
}

