/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.options;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.remapping.JsonUrlProblemLevelRemappingManager;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.dependencies.resolution.LastVersionSelector;
import com.jetbrains.pluginverifier.dependencies.resolution.PluginVersionSelector;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.PluginParsingConfiguration;
import com.jetbrains.pluginverifier.options.PluginParsingConfigurationResolution;
import com.jetbrains.pluginverifier.options.PluginsParsing;
import com.jetbrains.pluginverifier.options.PluginsSet;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.local.LocalPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import com.jetbrains.pluginverifier.tasks.InvalidPluginFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ\u000e\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u001c2\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Lcom/jetbrains/pluginverifier/options/PluginsParsing;", "", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "pluginsSet", "Lcom/jetbrains/pluginverifier/options/PluginsSet;", "configuration", "Lcom/jetbrains/pluginverifier/options/PluginParsingConfiguration;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;Lcom/jetbrains/pluginverifier/options/PluginsSet;Lcom/jetbrains/pluginverifier/options/PluginParsingConfiguration;)V", "pluginParsingConfigurationResolution", "Lcom/jetbrains/pluginverifier/options/PluginParsingConfigurationResolution;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getProblemResolver", "(Lcom/jetbrains/pluginverifier/options/PluginParsingConfiguration;)Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "addAllCompatibleVersionsOfPlugin", "", "pluginId", "", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "addLastCompatibleVersionOfPlugin", "addLastPluginVersion", "addPluginBySpec", "spec", "basePath", "Ljava/nio/file/Path;", "ideVersions", "", "addPluginFile", "pluginFile", "validateDescriptor", "", "addPluginVersion", "version", "addPluginsFromCmdOpts", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "addPluginsListedInFile", "pluginsListFile", "addUpdateById", "updateId", "", "reportLocalPluginTelemetry", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "telemetry", "Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "tryFindPluginByPath", "baseFilePath", "linePath", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nPluginsParsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginsParsing.kt\ncom/jetbrains/pluginverifier/options/PluginsParsing\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1#2:246\n1549#3:247\n1620#3,3:248\n819#3:251\n847#3,2:252\n819#3:254\n847#3,2:255\n1855#3,2:257\n1855#3,2:259\n1855#3,2:261\n*S KotlinDebug\n*F\n+ 1 PluginsParsing.kt\ncom/jetbrains/pluginverifier/options/PluginsParsing\n*L\n89#1:247\n89#1:248,3\n90#1:251\n90#1:252,2\n91#1:254\n91#1:255,2\n113#1:257,2\n125#1:259,2\n148#1:261,2\n*E\n"})
public final class PluginsParsing {
    @NotNull
    private final PluginRepository pluginRepository;
    @NotNull
    private final PluginVerificationReportage reportage;
    @NotNull
    private final PluginsSet pluginsSet;
    @NotNull
    private final PluginParsingConfiguration configuration;
    @NotNull
    private final PluginParsingConfigurationResolution pluginParsingConfigurationResolution;

    public PluginsParsing(@NotNull PluginRepository pluginRepository, @NotNull PluginVerificationReportage reportage, @NotNull PluginsSet pluginsSet, @NotNull PluginParsingConfiguration configuration) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        Intrinsics.checkNotNullParameter(pluginsSet, "pluginsSet");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.pluginRepository = pluginRepository;
        this.reportage = reportage;
        this.pluginsSet = pluginsSet;
        this.configuration = configuration;
        this.pluginParsingConfigurationResolution = new PluginParsingConfigurationResolution();
    }

    public /* synthetic */ PluginsParsing(PluginRepository pluginRepository, PluginVerificationReportage pluginVerificationReportage, PluginsSet pluginsSet, PluginParsingConfiguration pluginParsingConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            pluginParsingConfiguration = new PluginParsingConfiguration(null, null, 3, null);
        }
        this(pluginRepository, pluginVerificationReportage, pluginsSet, pluginParsingConfiguration);
    }

    public final void addPluginsFromCmdOpts(@NotNull CmdOpts opts, @NotNull IdeVersion ideVersion) {
        Path pluginsToCheckFile;
        Path path;
        Intrinsics.checkNotNullParameter(opts, "opts");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        for (String pluginId : opts.getPluginToCheckAllBuilds()) {
            this.addAllCompatibleVersionsOfPlugin(pluginId, ideVersion);
        }
        for (String pluginId : opts.getPluginToCheckLastBuild()) {
            this.addLastCompatibleVersionOfPlugin(pluginId, ideVersion);
        }
        String string2 = opts.getPluginsToCheckFile();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = pluginsToCheckFile = null;
        }
        if (pluginsToCheckFile != null) {
            this.addPluginsListedInFile(pluginsToCheckFile, CollectionsKt.listOf(ideVersion));
        }
    }

    public final void addUpdateById(int updateId) {
        UpdateInfo updateInfo2 = (UpdateInfo)RetryUtilKt.retry$default(this.pluginRepository, "get plugin info for #" + updateId, null, new Function1<PluginRepository, UpdateInfo>(this, updateId){
            final /* synthetic */ PluginsParsing this$0;
            final /* synthetic */ int $updateId;
            {
                this.this$0 = $receiver;
                this.$updateId = $updateId;
                super(1);
            }

            @Nullable
            public final UpdateInfo invoke(@NotNull PluginRepository $this$retry) {
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                PluginRepository pluginRepository = PluginsParsing.access$getPluginRepository$p(this.this$0);
                MarketplaceRepository marketplaceRepository = pluginRepository instanceof MarketplaceRepository ? (MarketplaceRepository)pluginRepository : null;
                return marketplaceRepository != null ? marketplaceRepository.getPluginInfoByUpdateId(this.$updateId) : null;
            }
        }, 2, null);
        if (updateInfo2 == null) {
            throw new IllegalArgumentException("Update #" + updateId + " is not found in the " + this.pluginRepository);
        }
        UpdateInfo updateInfo3 = updateInfo2;
        this.pluginsSet.schedulePlugin(updateInfo3);
    }

    public final void addLastPluginVersion(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        LastVersionSelector selector = new LastVersionSelector();
        PluginVersionSelector.Result selectResult2 = (PluginVersionSelector.Result)RetryUtilKt.retry$default(this, "Latest version of " + pluginId, null, new Function1<PluginsParsing, PluginVersionSelector.Result>(selector, pluginId){
            final /* synthetic */ LastVersionSelector $selector;
            final /* synthetic */ String $pluginId;
            {
                this.$selector = $selector;
                this.$pluginId = $pluginId;
                super(1);
            }

            @NotNull
            public final PluginVersionSelector.Result invoke(@NotNull PluginsParsing $this$retry) {
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                return this.$selector.selectPluginVersion(this.$pluginId, PluginsParsing.access$getPluginRepository$p($this$retry));
            }
        }, 2, null);
        if (selectResult2 instanceof PluginVersionSelector.Result.Selected) {
            this.pluginsSet.schedulePlugin(((PluginVersionSelector.Result.Selected)selectResult2).getPluginInfo());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addPluginsListedInFile(@NotNull Path pluginsListFile, @NotNull List<? extends IdeVersion> ideVersions) {
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(pluginsListFile, "pluginsListFile");
        Intrinsics.checkNotNullParameter(ideVersions, "ideVersions");
        this.reportage.logVerificationStage("Reading plugins list to check from file " + pluginsListFile.toAbsolutePath() + " against IDE versions " + CollectionsKt.joinToString$default(ideVersions, null, null, null, 0, null, addPluginsListedInFile.1.INSTANCE, 31, null));
        Iterable iterable = FileUtilKt.readLines$default(pluginsListFile, null, 1, null);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default(it, "//", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List specs = (List)destination$iv$iv;
        for (String spec : specs) {
            this.addPluginBySpec(spec, pluginsListFile, ideVersions);
        }
    }

    public final void addPluginBySpec(@NotNull String spec, @NotNull Path basePath, @NotNull List<? extends IdeVersion> ideVersions) {
        Path pluginFile;
        Path path;
        Intrinsics.checkNotNullParameter(spec, "spec");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(ideVersions, "ideVersions");
        if (StringsKt.startsWith$default((CharSequence)spec, '$', false, 2, null) || StringsKt.endsWith$default((CharSequence)spec, '$', false, 2, null)) {
            char[] cArray = new char[]{'$'};
            String pluginId = ((Object)StringsKt.trim((CharSequence)StringsKt.trim(spec, cArray))).toString();
            Iterable $this$forEach$iv = ideVersions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeVersion it = (IdeVersion)element$iv;
                boolean bl = false;
                this.addLastCompatibleVersionOfPlugin(pluginId, it);
            }
            return;
        }
        if (StringsKt.startsWith$default(spec, "#", false, 2, null)) {
            Integer n = StringsKt.toIntOrNull(StringsKt.substringAfter$default(spec, "#", null, 2, null));
            if (n == null) {
                return;
            }
            int updateId = n;
            this.addUpdateById(updateId);
            return;
        }
        if (StringsKt.startsWith$default(spec, "id:", false, 2, null)) {
            String pluginId = StringsKt.substringAfter$default(spec, "id:", null, 2, null);
            Iterable $this$forEach$iv = ideVersions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeVersion it = (IdeVersion)element$iv;
                boolean bl = false;
                this.addAllCompatibleVersionsOfPlugin(pluginId, it);
            }
            return;
        }
        if (StringsKt.startsWith$default(spec, "version:", false, 2, null)) {
            String idAndVersion = StringsKt.substringAfter$default(spec, "version:", null, 2, null);
            String id = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default(idAndVersion, ":", null, 2, null))).toString();
            String version = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default(idAndVersion, ":", null, 2, null))).toString();
            if (!(((CharSequence)version).length() > 0)) {
                boolean $i$a$-require-PluginsParsing$addPluginBySpec$42 = false;
                String $i$a$-require-PluginsParsing$addPluginBySpec$42 = "Empty version specified for a plugin to be checked: {" + spec + "}";
                throw new IllegalArgumentException($i$a$-require-PluginsParsing$addPluginBySpec$42.toString());
            }
            this.addPluginVersion(id, version);
            return;
        }
        if (StringsKt.startsWith$default(spec, "path:", false, 2, null)) {
            String linePath = StringsKt.substringAfter$default(spec, "path:", null, 2, null);
            path = this.tryFindPluginByPath(basePath, linePath);
            if (path == null) {
                throw new IllegalArgumentException("Invalid path: " + linePath);
            }
        } else {
            path = this.tryFindPluginByPath(basePath, spec);
        }
        if ((pluginFile = path) != null) {
            this.addPluginFile(pluginFile, true);
        } else {
            Iterable $this$forEach$iv = ideVersions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeVersion it = (IdeVersion)element$iv;
                boolean bl = false;
                this.addAllCompatibleVersionsOfPlugin(spec, it);
            }
        }
    }

    private final Path tryFindPluginByPath(Path baseFilePath, String linePath) {
        Path path;
        try {
            path = Paths.get(linePath, new String[0]);
        }
        catch (Exception e) {
            return null;
        }
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue(path2, "path");
        if (FileUtilKt.exists(path2)) {
            return path2;
        }
        Path siblingPath = baseFilePath.resolveSibling(linePath);
        Intrinsics.checkNotNullExpressionValue(siblingPath, "siblingPath");
        if (FileUtilKt.exists(siblingPath)) {
            return siblingPath;
        }
        return null;
    }

    private final void addAllCompatibleVersionsOfPlugin(String pluginId, IdeVersion ideVersion) {
        String stepName;
        List compatibleVersions2 = (List)RetryUtilKt.retry$default(this.pluginRepository, stepName = "All versions of plugin '" + pluginId + "' compatible with " + ideVersion, null, new Function1<PluginRepository, List<? extends PluginInfo>>(pluginId, ideVersion){
            final /* synthetic */ String $pluginId;
            final /* synthetic */ IdeVersion $ideVersion;
            {
                this.$pluginId = $pluginId;
                this.$ideVersion = $ideVersion;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PluginInfo> invoke(@NotNull PluginRepository $this$retry) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                Iterable iterable = $this$retry.getAllVersionsOfPlugin(this.$pluginId);
                IdeVersion ideVersion = this.$ideVersion;
                boolean $i$f$filter = false;
                void var5_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    PluginInfo it = (PluginInfo)element$iv$iv;
                    boolean bl = false;
                    if (!it.isCompatibleWith(ideVersion)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, 2, null);
        this.reportage.logVerificationStage(stepName + ": " + (compatibleVersions2.isEmpty() ? "no compatible versions" : CollectionsKt.joinToString$default(compatibleVersions2, null, null, null, 0, null, addAllCompatibleVersionsOfPlugin.1.INSTANCE, 31, null)));
        this.pluginsSet.schedulePlugins(compatibleVersions2);
    }

    private final void addPluginVersion(String pluginId, String version) {
        PluginInfo pluginInfo;
        Object object;
        Object v0;
        String stepName;
        block3: {
            stepName = "Plugin '" + pluginId + "' of version '" + version + "'";
            List allVersionsOfPlugin2 = (List)RetryUtilKt.retry$default(this.pluginRepository, stepName, null, new Function1<PluginRepository, List<? extends PluginInfo>>(pluginId){
                final /* synthetic */ String $pluginId;
                {
                    this.$pluginId = $pluginId;
                    super(1);
                }

                @NotNull
                public final List<PluginInfo> invoke(@NotNull PluginRepository $this$retry) {
                    Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                    return $this$retry.getAllVersionsOfPlugin(this.$pluginId);
                }
            }, 2, null);
            Iterable iterable = allVersionsOfPlugin2;
            for (Object t2 : iterable) {
                PluginInfo it = (PluginInfo)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getVersion(), version)) continue;
                v0 = t2;
                break block3;
            }
            v0 = null;
        }
        if ((object = (pluginInfo = (PluginInfo)v0)) == null || (object = ((PluginInfo)object).getPresentableName()) == null) {
            object = "no version '" + version + "' of plugin '" + pluginId + "' available";
        }
        this.reportage.logVerificationStage(stepName + ": " + (String)object);
        if (pluginInfo == null) {
            return;
        }
        this.pluginsSet.schedulePlugin(pluginInfo);
    }

    private final void addLastCompatibleVersionOfPlugin(String pluginId, IdeVersion ideVersion) {
        String stepName = "Last version of plugin '" + pluginId + "' compatible with " + ideVersion;
        PluginInfo lastVersion2 = (PluginInfo)RetryUtilKt.retry$default(this.pluginRepository, stepName, null, new Function1<PluginRepository, PluginInfo>(ideVersion, pluginId){
            final /* synthetic */ IdeVersion $ideVersion;
            final /* synthetic */ String $pluginId;
            {
                this.$ideVersion = $ideVersion;
                this.$pluginId = $pluginId;
                super(1);
            }

            @Nullable
            public final PluginInfo invoke(@NotNull PluginRepository $this$retry) {
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                return $this$retry.getLastCompatibleVersionOfPlugin(this.$ideVersion, this.$pluginId);
            }
        }, 2, null);
        Object object = lastVersion2;
        if (object == null || (object = ((PluginInfo)object).getPresentableName()) == null) {
            object = "no compatible version";
        }
        this.reportage.logVerificationStage(stepName + ": " + (String)object);
        if (lastVersion2 == null) {
            return;
        }
        this.pluginsSet.schedulePlugin(lastVersion2);
    }

    public final void addPluginFile(@NotNull Path pluginFile, boolean validateDescriptor) {
        PluginCreationResult pluginCreationResult;
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        if (!FileUtilKt.exists(pluginFile)) {
            throw new RuntimeException("Plugin file '" + pluginFile + "' with absolute path '" + pluginFile.toAbsolutePath() + "' doesn't exist");
        }
        String string2 = "Reading plugin to check from %s";
        Object[] objectArray = new Object[]{pluginFile};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        this.reportage.logVerificationStage(string3);
        PluginCreationResult $this$addPluginFile_u24lambda_u2410 = pluginCreationResult = IdePluginManager.createPlugin$default(IdePluginManager.Companion.createManager(), pluginFile, validateDescriptor, null, this.getProblemResolver(this.configuration), 4, null);
        boolean bl = false;
        PluginCreationResult pluginCreationResult2 = $this$addPluginFile_u24lambda_u2410;
        if (pluginCreationResult2 instanceof PluginCreationSuccess) {
            Unit unit;
            this.pluginsSet.scheduleLocalPlugin((IdePlugin)((PluginCreationSuccess)$this$addPluginFile_u24lambda_u2410).getPlugin());
            Unit it = unit = Unit.INSTANCE;
            boolean bl2 = false;
            this.reportLocalPluginTelemetry((IdePlugin)((PluginCreationSuccess)$this$addPluginFile_u24lambda_u2410).getPlugin(), ((PluginCreationSuccess)$this$addPluginFile_u24lambda_u2410).getTelemetry());
        } else if (pluginCreationResult2 instanceof PluginCreationFail) {
            this.reportage.logVerificationStage("Plugin is invalid in " + pluginFile + ": " + CollectionsKt.joinToString$default(((PluginCreationFail)$this$addPluginFile_u24lambda_u2410).getErrorsAndWarnings(), null, null, null, 0, null, null, 63, null));
            this.pluginsSet.getInvalidPluginFiles().add(new InvalidPluginFile(pluginFile, ((PluginCreationFail)$this$addPluginFile_u24lambda_u2410).getErrorsAndWarnings()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void reportLocalPluginTelemetry(IdePlugin plugin, PluginTelemetry telemetry) {
        this.reportage.reportTelemetry(new LocalPluginInfo(plugin), telemetry);
    }

    private final PluginCreationResultResolver getProblemResolver(PluginParsingConfiguration $this$problemResolver) {
        return this.pluginParsingConfigurationResolution.resolveProblemLevelMapping($this$problemResolver, JsonUrlProblemLevelRemappingManager.Companion.fromClassPathJson());
    }

    public static final /* synthetic */ PluginRepository access$getPluginRepository$p(PluginsParsing $this) {
        return $this.pluginRepository;
    }
}

