/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.misc;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.misc.RecoverStrategy;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ*\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0001\u0010\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/pluginverifier/misc/Retry;", "T", "", "presentableBlockName", "", "maxAttempts", "", "recover", "Lcom/jetbrains/pluginverifier/misc/RecoverStrategy;", "obj", "(Ljava/lang/String;ILcom/jetbrains/pluginverifier/misc/RecoverStrategy;Ljava/lang/Object;)V", "getMaxAttempts", "()I", "getObj", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPresentableBlockName", "()Ljava/lang/String;", "getRecover", "()Lcom/jetbrains/pluginverifier/misc/RecoverStrategy;", "retry", "R", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "verifier-repository"})
final class Retry<T> {
    @NotNull
    private final String presentableBlockName;
    private final int maxAttempts;
    @NotNull
    private final RecoverStrategy recover;
    private final T obj;

    public Retry(@NotNull String presentableBlockName, int maxAttempts, @NotNull RecoverStrategy recover, T obj) {
        Intrinsics.checkNotNullParameter(presentableBlockName, "presentableBlockName");
        Intrinsics.checkNotNullParameter(recover, "recover");
        this.presentableBlockName = presentableBlockName;
        this.maxAttempts = maxAttempts;
        this.recover = recover;
        this.obj = obj;
    }

    @NotNull
    public final String getPresentableBlockName() {
        return this.presentableBlockName;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    @NotNull
    public final RecoverStrategy getRecover() {
        return this.recover;
    }

    public final T getObj() {
        return this.obj;
    }

    public final <R> R retry(@NotNull Function1<? super T, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        int attempt = 1;
        int n = this.maxAttempts;
        if (attempt <= n) {
            while (true) {
                try {
                    return body.invoke(this.obj);
                }
                catch (Throwable e) {
                    LanguageUtilsKt.rethrowIfInterrupted(e);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = attempt;
                    objectArray[1] = this.maxAttempts;
                    objectArray[2] = this.presentableBlockName;
                    String string2 = e.getMessage();
                    objectArray[3] = string2 != null ? (Serializable)((Object)string2) : (Serializable)e.getClass();
                    RetryUtilKt.access$getLOG$p().warn("Retry #{} of {} to invoke '{}' failed with '{}'", objectArray);
                    if (attempt == this.maxAttempts) {
                        String error = "Failed to invoke '" + this.presentableBlockName + "' in all " + this.maxAttempts + " attempts, see nested exception for details";
                        throw new RuntimeException(error, e);
                    }
                    this.recover.recover(e, attempt);
                    if (attempt == n) break;
                    ++attempt;
                    continue;
                }
                break;
            }
        }
        throw new IllegalStateException("Should not be reached".toString());
    }
}

