/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.misc;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.pluginverifier.misc.RestApiFailed;
import com.jetbrains.pluginverifier.misc.RestApiOk;
import com.jetbrains.pluginverifier.misc.RestApiResult;
import com.jetbrains.pluginverifier.misc.RestApisKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.bouncycastle.cms.CMSSignedData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\b\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J8\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00150\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J8\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00150\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/misc/RestApis;", "", "()V", "httpClient", "Ljava/net/http/HttpClient;", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "get", "Lcom/jetbrains/pluginverifier/misc/RestApiResult;", "T", "url", "", "payloadType", "Ljava/lang/Class;", "timeout", "Ljava/time/Duration;", "Ljava/net/http/HttpRequest;", "getBytes", "", "getList", "", "elementClass", "getRawString", "getSigned", "type", "getSignedList", "getTypeTokenForList", "Lcom/fasterxml/jackson/databind/type/CollectionType;", "verifier-repository"})
public final class RestApis {
    @NotNull
    private final HttpClient httpClient = RestApisKt.createHttpClient$default(null, 1, null);
    private final ObjectMapper jackson = ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @NotNull
    public final RestApiResult<String> getRawString(@NotNull String url, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        HttpRequest request = this.get(url, timeout2);
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            String string2 = response.body();
            Intrinsics.checkNotNullExpressionValue(string2, "response.body()");
            return new RestApiFailed(string2, response.statusCode());
        }
        String string3 = response.body();
        Intrinsics.checkNotNullExpressionValue(string3, "response.body()");
        return new RestApiOk<String>(string3);
    }

    public static /* synthetic */ RestApiResult getRawString$default(RestApis restApis, String string2, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.getRawString(string2, duration);
    }

    @NotNull
    public final <T> RestApiResult<T> get(@NotNull String url, @NotNull Class<T> payloadType, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        HttpRequest request = this.get(url, timeout2);
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            String string2 = response.body();
            Intrinsics.checkNotNullExpressionValue(string2, "response.body()");
            return new RestApiFailed(string2, response.statusCode());
        }
        String responseJson = response.body();
        T payloadObject = this.jackson.readValue(responseJson, payloadType);
        return new RestApiOk<T>(payloadObject);
    }

    public static /* synthetic */ RestApiResult get$default(RestApis restApis, String string2, Class clazz, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.get(string2, clazz, duration);
    }

    @NotNull
    public final <T> RestApiResult<List<T>> getList(@NotNull String url, @NotNull Class<T> elementClass, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(elementClass, "elementClass");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        HttpRequest request = this.get(url, timeout2);
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            String string2 = response.body();
            Intrinsics.checkNotNullExpressionValue(string2, "response.body()");
            return new RestApiFailed(string2, response.statusCode());
        }
        String responseString = response.body();
        CollectionType listTypeToken = TypeFactory.defaultInstance().constructCollectionType(List.class, elementClass);
        Object t2 = this.jackson.readValue(responseString, (JavaType)listTypeToken);
        Intrinsics.checkNotNullExpressionValue(t2, "jackson.readValue(responseString, listTypeToken)");
        List list = (List)t2;
        return new RestApiOk<List>(list);
    }

    public static /* synthetic */ RestApiResult getList$default(RestApis restApis, String string2, Class clazz, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.getList(string2, clazz, duration);
    }

    @NotNull
    public final <T> RestApiResult<T> getSigned(@NotNull String url, @NotNull Class<T> type2, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        RestApiResult<byte[]> byteResult = this.getBytes(url, timeout2);
        if (!(byteResult instanceof RestApiOk)) {
            if (byteResult instanceof RestApiFailed) {
                return new RestApiFailed(byteResult, ((RestApiFailed)byteResult).getStatusCode());
            }
            throw new NoWhenBranchMatchedException();
        }
        byte[] payloadBytes = (byte[])((RestApiOk)byteResult).getPayload();
        Object object = new CMSSignedData(payloadBytes).getSignedContent().getContent();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.ByteArray");
        byte[] signedContent = (byte[])object;
        InputStream inputStream2 = new XZCompressorInputStream(new ByteArrayInputStream(signedContent));
        Charset charset = Charsets.UTF_8;
        T result2 = this.jackson.readValue((Reader)new InputStreamReader(inputStream2, charset), type2);
        return new RestApiOk<T>(result2);
    }

    public static /* synthetic */ RestApiResult getSigned$default(RestApis restApis, String string2, Class clazz, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.getSigned(string2, clazz, duration);
    }

    @NotNull
    public final <T> RestApiResult<List<T>> getSignedList(@NotNull String url, @NotNull Class<T> elementClass, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(elementClass, "elementClass");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        RestApiResult<byte[]> byteResult = this.getBytes(url, timeout2);
        if (!(byteResult instanceof RestApiOk)) {
            if (byteResult instanceof RestApiFailed) {
                return new RestApiFailed(byteResult, ((RestApiFailed)byteResult).getStatusCode());
            }
            throw new NoWhenBranchMatchedException();
        }
        byte[] payloadBytes = (byte[])((RestApiOk)byteResult).getPayload();
        Object object = new CMSSignedData(payloadBytes).getSignedContent().getContent();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.ByteArray");
        byte[] signedContent = (byte[])object;
        InputStream inputStream2 = new XZCompressorInputStream(new ByteArrayInputStream(signedContent));
        Charset charset = Charsets.UTF_8;
        Object t2 = this.jackson.readValue((Reader)new InputStreamReader(inputStream2, charset), (JavaType)this.getTypeTokenForList(elementClass));
        Intrinsics.checkNotNullExpressionValue(t2, "jackson.readValue(XZComp\u2026kenForList(elementClass))");
        List list = (List)t2;
        return new RestApiOk<List>(list);
    }

    public static /* synthetic */ RestApiResult getSignedList$default(RestApis restApis, String string2, Class clazz, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.getSignedList(string2, clazz, duration);
    }

    @NotNull
    public final RestApiResult<byte[]> getBytes(@NotNull String url, @NotNull Duration timeout2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        HttpRequest httpGet = this.get(url, timeout2);
        HttpResponse<byte[]> response = this.httpClient.send(httpGet, HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() != 200) {
            byte[] byArray = response.body();
            Intrinsics.checkNotNullExpressionValue(byArray, "response.body()");
            return new RestApiFailed(byArray, response.statusCode());
        }
        byte[] byArray = response.body();
        Intrinsics.checkNotNullExpressionValue(byArray, "response.body()");
        return new RestApiOk<byte[]>(byArray);
    }

    public static /* synthetic */ RestApiResult getBytes$default(RestApis restApis, String string2, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
            duration = duration2;
        }
        return restApis.getBytes(string2, duration);
    }

    private final HttpRequest get(String url, Duration timeout2) {
        HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(url)).timeout(timeout2).build();
        Intrinsics.checkNotNullExpressionValue(httpRequest, "newBuilder().GET()\n     \u2026meout)\n          .build()");
        return httpRequest;
    }

    private final <T> CollectionType getTypeTokenForList(Class<T> elementClass) {
        CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(List.class, elementClass);
        Intrinsics.checkNotNullExpressionValue(collectionType, "defaultInstance().constr\u2026class.java, elementClass)");
        return collectionType;
    }
}

