/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.ide.IdeDescriptorsCache;
import com.jetbrains.pluginverifier.ide.IdeFilesBank;
import com.jetbrains.pluginverifier.repository.cache.ResourceCache;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntry;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntryResult;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheKt;
import com.jetbrains.pluginverifier.repository.cleanup.SizeWeight;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache;", "Ljava/io/Closeable;", "cacheSize", "", "ideFilesBank", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank;", "defaultJdkPath", "Ljava/nio/file/Path;", "(ILcom/jetbrains/pluginverifier/ide/IdeFilesBank;Ljava/nio/file/Path;)V", "descriptorsCache", "Lcom/jetbrains/pluginverifier/repository/cache/ResourceCache;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "Lcom/jetbrains/pluginverifier/repository/cleanup/SizeWeight;", "close", "", "getIdeDescriptorCacheEntry", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result;", "ideVersion", "IdeDescriptorResourceProvider", "Result", "verifier-intellij"})
public final class IdeDescriptorsCache
implements Closeable {
    @NotNull
    private final ResourceCache<IdeDescriptor, IdeVersion, SizeWeight> descriptorsCache;

    public IdeDescriptorsCache(int cacheSize, @NotNull IdeFilesBank ideFilesBank, @NotNull Path defaultJdkPath) {
        Intrinsics.checkNotNullParameter(ideFilesBank, "ideFilesBank");
        Intrinsics.checkNotNullParameter(defaultJdkPath, "defaultJdkPath");
        this.descriptorsCache = ResourceCacheKt.createSizeLimitedResourceCache(cacheSize, new IdeDescriptorResourceProvider(ideFilesBank, defaultJdkPath), descriptorsCache.1.INSTANCE, "IdeDescriptorsCache");
    }

    @NotNull
    public final Result getIdeDescriptorCacheEntry(@NotNull IdeVersion ideVersion) throws InterruptedException {
        Result result2;
        ResourceCacheEntryResult<IdeDescriptor, SizeWeight> resourceCacheEntryResult;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        ResourceCacheEntryResult<IdeDescriptor, SizeWeight> $this$getIdeDescriptorCacheEntry_u24lambda_u240 = resourceCacheEntryResult = this.descriptorsCache.getResourceCacheEntry(ideVersion);
        boolean bl = false;
        ResourceCacheEntryResult<IdeDescriptor, SizeWeight> resourceCacheEntryResult2 = $this$getIdeDescriptorCacheEntry_u24lambda_u240;
        if (resourceCacheEntryResult2 instanceof ResourceCacheEntryResult.Found) {
            result2 = new Result.Found(((ResourceCacheEntryResult.Found)$this$getIdeDescriptorCacheEntry_u24lambda_u240).getResourceCacheEntry());
        } else if (resourceCacheEntryResult2 instanceof ResourceCacheEntryResult.Failed) {
            result2 = new Result.Failed(((ResourceCacheEntryResult.Failed)$this$getIdeDescriptorCacheEntry_u24lambda_u240).getMessage(), ((ResourceCacheEntryResult.Failed)$this$getIdeDescriptorCacheEntry_u24lambda_u240).getError());
        } else if (resourceCacheEntryResult2 instanceof ResourceCacheEntryResult.NotFound) {
            result2 = new Result.NotFound(((ResourceCacheEntryResult.NotFound)$this$getIdeDescriptorCacheEntry_u24lambda_u240).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    @Override
    public void close() {
        this.descriptorsCache.close();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$IdeDescriptorResourceProvider;", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "ideFilesBank", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank;", "defaultJdkPath", "Ljava/nio/file/Path;", "(Lcom/jetbrains/pluginverifier/ide/IdeFilesBank;Ljava/nio/file/Path;)V", "provide", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "key", "verifier-intellij"})
    private static final class IdeDescriptorResourceProvider
    implements ResourceProvider<IdeVersion, IdeDescriptor> {
        @NotNull
        private final IdeFilesBank ideFilesBank;
        @NotNull
        private final Path defaultJdkPath;

        public IdeDescriptorResourceProvider(@NotNull IdeFilesBank ideFilesBank, @NotNull Path defaultJdkPath) {
            Intrinsics.checkNotNullParameter(ideFilesBank, "ideFilesBank");
            Intrinsics.checkNotNullParameter(defaultJdkPath, "defaultJdkPath");
            this.ideFilesBank = ideFilesBank;
            this.defaultJdkPath = defaultJdkPath;
        }

        @Override
        @NotNull
        public ProvideResult<IdeDescriptor> provide(@NotNull IdeVersion key) {
            ProvideResult provideResult;
            Intrinsics.checkNotNullParameter(key, "key");
            IdeFilesBank.Result result2 = this.ideFilesBank.getIdeFile(key);
            if (result2 instanceof IdeFilesBank.Result.Found) {
                IdeDescriptor ideDescriptor;
                FileLock ideLock = ((IdeFilesBank.Result.Found)result2).getIdeFileLock();
                try {
                    ideDescriptor = IdeDescriptor.Companion.create(ideLock.getFile(), this.defaultJdkPath, ideLock);
                }
                catch (Exception e) {
                    LanguageUtilsKt.closeLogged((Closeable)ideLock);
                    LanguageUtilsKt.rethrowIfInterrupted(e);
                    return new ProvideResult.Failed("Unable to open IDE " + key + ": " + e.getMessage(), e);
                }
                IdeDescriptor ideDescriptor2 = ideDescriptor;
                provideResult = new ProvideResult.Provided<IdeDescriptor>(ideDescriptor2);
            } else if (result2 instanceof IdeFilesBank.Result.NotFound) {
                provideResult = new ProvideResult.NotFound("IDE " + key + " is not found: " + ((IdeFilesBank.Result.NotFound)result2).getReason());
            } else if (result2 instanceof IdeFilesBank.Result.Failed) {
                provideResult = new ProvideResult.Failed("IDE " + key + " can't be downloaded: " + ((IdeFilesBank.Result.Failed)result2).getReason(), ((IdeFilesBank.Result.Failed)result2).getException());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return provideResult;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result;", "Ljava/io/Closeable;", "()V", "Failed", "Found", "NotFound", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$Failed;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$Found;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$NotFound;", "verifier-intellij"})
    public static abstract class Result
    implements Closeable {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$Failed;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result;", "reason", "", "error", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "getReason", "()Ljava/lang/String;", "close", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "verifier-intellij"})
        public static final class Failed
        extends Result {
            @NotNull
            private final String reason;
            @NotNull
            private final Throwable error;

            public Failed(@NotNull String reason, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                Intrinsics.checkNotNullParameter(error, "error");
                super(null);
                this.reason = reason;
                this.error = error;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @Override
            public void close() {
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Throwable component2() {
                return this.error;
            }

            @NotNull
            public final Failed copy(@NotNull String reason, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                Intrinsics.checkNotNullParameter(error, "error");
                return new Failed(reason, error);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, String string2, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = failed.reason;
                }
                if ((n & 2) != 0) {
                    throwable = failed.error;
                }
                return failed.copy(string2, throwable);
            }

            @NotNull
            public String toString() {
                return "Failed(reason=" + this.reason + ", error=" + this.error + ")";
            }

            public int hashCode() {
                int result2 = this.reason.hashCode();
                result2 = result2 * 31 + this.error.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                if (!Intrinsics.areEqual(this.reason, failed.reason)) {
                    return false;
                }
                return Intrinsics.areEqual(this.error, failed.error);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$Found;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result;", "resourceCacheEntry", "Lcom/jetbrains/pluginverifier/repository/cache/ResourceCacheEntry;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "Lcom/jetbrains/pluginverifier/repository/cleanup/SizeWeight;", "(Lcom/jetbrains/pluginverifier/repository/cache/ResourceCacheEntry;)V", "ideDescriptor", "getIdeDescriptor", "()Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "close", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "verifier-intellij"})
        public static final class Found
        extends Result {
            @NotNull
            private final ResourceCacheEntry<IdeDescriptor, SizeWeight> resourceCacheEntry;

            public Found(@NotNull ResourceCacheEntry<IdeDescriptor, SizeWeight> resourceCacheEntry) {
                Intrinsics.checkNotNullParameter(resourceCacheEntry, "resourceCacheEntry");
                super(null);
                this.resourceCacheEntry = resourceCacheEntry;
            }

            @NotNull
            public final IdeDescriptor getIdeDescriptor() {
                return this.resourceCacheEntry.getResource();
            }

            @Override
            public void close() {
                this.resourceCacheEntry.close();
            }

            private final ResourceCacheEntry<IdeDescriptor, SizeWeight> component1() {
                return this.resourceCacheEntry;
            }

            @NotNull
            public final Found copy(@NotNull ResourceCacheEntry<IdeDescriptor, SizeWeight> resourceCacheEntry) {
                Intrinsics.checkNotNullParameter(resourceCacheEntry, "resourceCacheEntry");
                return new Found(resourceCacheEntry);
            }

            public static /* synthetic */ Found copy$default(Found found, ResourceCacheEntry resourceCacheEntry, int n, Object object) {
                if ((n & 1) != 0) {
                    resourceCacheEntry = found.resourceCacheEntry;
                }
                return found.copy(resourceCacheEntry);
            }

            @NotNull
            public String toString() {
                return "Found(resourceCacheEntry=" + this.resourceCacheEntry + ")";
            }

            public int hashCode() {
                return this.resourceCacheEntry.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Found)) {
                    return false;
                }
                Found found = (Found)other;
                return Intrinsics.areEqual(this.resourceCacheEntry, found.resourceCacheEntry);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result$NotFound;", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptorsCache$Result;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "close", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "verifier-intellij"})
        public static final class NotFound
        extends Result {
            @NotNull
            private final String reason;

            public NotFound(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @Override
            public void close() {
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final NotFound copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                return new NotFound(reason);
            }

            public static /* synthetic */ NotFound copy$default(NotFound notFound, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = notFound.reason;
                }
                return notFound.copy(string2);
            }

            @NotNull
            public String toString() {
                return "NotFound(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotFound)) {
                    return false;
                }
                NotFound notFound = (NotFound)other;
                return Intrinsics.areEqual(this.reason, notFound.reason);
            }
        }
    }
}

