/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.base.problems.NotNumber;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.ProductDescriptorBean;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseVersionAndPluginVersionMismatch;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseVersionWrongFormat;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.version.ProductReleaseVersion;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier;", "", "()V", "verify", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "descriptorPath", "", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "verifyPluginVersionAndReleaseVersionMatch", "", "productReleaseVersion", "Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;", "MajorMinorVersion", "VerificationResult", "structure-intellij"})
public final class ProductReleaseVersionVerifier {
    @NotNull
    public final VerificationResult verify(@NotNull PluginBean plugin, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar2) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemRegistrar2, "problemRegistrar");
        if (plugin.productDescriptor == null) {
            return VerificationResult.NotApplicable.INSTANCE;
        }
        ProductDescriptorBean productDescriptorBean = plugin.productDescriptor;
        String releaseVersionValue = productDescriptorBean != null ? productDescriptorBean.releaseVersion : null;
        Object object = releaseVersionValue;
        if (object == null || object.length() == 0) {
            Object it = object = new VerificationResult.Invalid("Attribute 'release-version' is missing");
            boolean bl = false;
            problemRegistrar2.registerProblem(new PropertyNotSpecified("release-version", descriptorPath));
            return (VerificationResult)object;
        }
        try {
            VerificationResult verificationResult;
            Object $this$run = object = ProductReleaseVersion.Companion.parse(releaseVersionValue);
            boolean bl = false;
            if (((ProductReleaseVersion)$this$run).isSingleDigit()) {
                VerificationResult.Invalid invalid;
                VerificationResult.Invalid it = invalid = new VerificationResult.Invalid("Attribute 'release-version' must have two or more digits: '" + releaseVersionValue + "'");
                boolean bl2 = false;
                problemRegistrar2.registerProblem(new ReleaseVersionWrongFormat(descriptorPath, releaseVersionValue));
                verificationResult = invalid;
            } else {
                this.verifyPluginVersionAndReleaseVersionMatch(plugin, (ProductReleaseVersion)$this$run, descriptorPath, problemRegistrar2);
                verificationResult = new VerificationResult.Valid((ProductReleaseVersion)$this$run);
            }
            object = verificationResult;
        }
        catch (NumberFormatException e) {
            VerificationResult.Invalid invalid;
            VerificationResult.Invalid it = invalid = new VerificationResult.Invalid("Attribute 'release-version' is not an integer: '" + releaseVersionValue + "'");
            boolean bl = false;
            problemRegistrar2.registerProblem(new NotNumber("release-version", descriptorPath));
            object = invalid;
        }
        return object;
    }

    private final void verifyPluginVersionAndReleaseVersionMatch(PluginBean plugin, ProductReleaseVersion productReleaseVersion, String descriptorPath, ProblemRegistrar problemRegistrar2) {
        if (plugin.pluginVersion == null) {
            return;
        }
        MajorMinorVersion majorMinorVersion = MajorMinorVersion.Companion.parse(plugin);
        if (majorMinorVersion == null) {
            return;
        }
        MajorMinorVersion pluginVersion = majorMinorVersion;
        if (!pluginVersion.matches(productReleaseVersion)) {
            String string2 = plugin.pluginVersion;
            Intrinsics.checkNotNullExpressionValue(string2, "plugin.pluginVersion");
            problemRegistrar2.registerProblem(new ReleaseVersionAndPluginVersionMismatch(descriptorPath, productReleaseVersion, string2));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$MajorMinorVersion;", "", "major", "", "minor", "(II)V", "getMajor", "()I", "getMinor", "component1", "component2", "copy", "equals", "", "other", "hashCode", "matches", "productReleaseVersion", "Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;", "toString", "", "Companion", "structure-intellij"})
    private static final class MajorMinorVersion {
        private final int major;
        private final int minor;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final boolean matches(@NotNull ProductReleaseVersion productReleaseVersion) {
            Intrinsics.checkNotNullParameter(productReleaseVersion, "productReleaseVersion");
            return this.major == productReleaseVersion.getMajor() && this.minor == productReleaseVersion.getMinor();
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public MajorMinorVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        @NotNull
        public final MajorMinorVersion copy(int major, int minor) {
            return new MajorMinorVersion(major, minor);
        }

        public static /* synthetic */ MajorMinorVersion copy$default(MajorMinorVersion majorMinorVersion, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = majorMinorVersion.major;
            }
            if ((n3 & 2) != 0) {
                n2 = majorMinorVersion.minor;
            }
            return majorMinorVersion.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "MajorMinorVersion(major=" + this.major + ", minor=" + this.minor + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.major) * 31 + Integer.hashCode(this.minor);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MajorMinorVersion)) break block3;
                    MajorMinorVersion majorMinorVersion = (MajorMinorVersion)object;
                    if (this.major != majorMinorVersion.major || this.minor != majorMinorVersion.minor) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$MajorMinorVersion$Companion;", "", "()V", "parse", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$MajorMinorVersion;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "structure-intellij"})
        public static final class Companion {
            @Nullable
            public final MajorMinorVersion parse(@NotNull PluginBean plugin) {
                int n;
                Intrinsics.checkNotNullParameter(plugin, "plugin");
                String string2 = plugin.pluginVersion;
                Intrinsics.checkNotNullExpressionValue(string2, "plugin.pluginVersion");
                List pluginVersionParts = StringsKt.split$default((CharSequence)string2, new String[]{"."}, false, 0, 6, null);
                Integer n2 = StringsKt.toIntOrNull((String)pluginVersionParts.get(0));
                if (n2 == null) {
                    return null;
                }
                int major = n2;
                if (pluginVersionParts.size() > 1) {
                    Integer n3 = StringsKt.toIntOrNull((String)StringsKt.split$default((CharSequence)pluginVersionParts.get(1), new String[]{"-"}, false, 0, 6, null).get(0));
                    n = n3 != null ? n3 : 0;
                } else {
                    n = 0;
                }
                int minor = n;
                return new MajorMinorVersion(major, minor);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult;", "", "()V", "Invalid", "NotApplicable", "Valid", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$Invalid;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$NotApplicable;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$Valid;", "structure-intellij"})
    public static abstract class VerificationResult {
        private VerificationResult() {
        }

        public /* synthetic */ VerificationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$Valid;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult;", "version", "Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;", "(Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;)V", "getVersion", "()Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Valid
        extends VerificationResult {
            @NotNull
            private final ProductReleaseVersion version;

            @NotNull
            public final ProductReleaseVersion getVersion() {
                return this.version;
            }

            public Valid(@NotNull ProductReleaseVersion version) {
                Intrinsics.checkNotNullParameter(version, "version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final ProductReleaseVersion component1() {
                return this.version;
            }

            @NotNull
            public final Valid copy(@NotNull ProductReleaseVersion version) {
                Intrinsics.checkNotNullParameter(version, "version");
                return new Valid(version);
            }

            public static /* synthetic */ Valid copy$default(Valid valid, ProductReleaseVersion productReleaseVersion, int n, Object object) {
                if ((n & 1) != 0) {
                    productReleaseVersion = valid.version;
                }
                return valid.copy(productReleaseVersion);
            }

            @NotNull
            public String toString() {
                return "Valid(version=" + this.version + ")";
            }

            public int hashCode() {
                ProductReleaseVersion productReleaseVersion = this.version;
                return productReleaseVersion != null ? ((Object)productReleaseVersion).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Valid)) break block3;
                        Valid valid = (Valid)object;
                        if (!Intrinsics.areEqual(this.version, valid.version)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$Invalid;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-intellij"})
        public static final class Invalid
        extends VerificationResult {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Invalid(@NotNull String message2) {
                Intrinsics.checkNotNullParameter(message2, "message");
                super(null);
                this.message = message2;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Invalid copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter(message2, "message");
                return new Invalid(message2);
            }

            public static /* synthetic */ Invalid copy$default(Invalid invalid, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = invalid.message;
                }
                return invalid.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Invalid(message=" + this.message + ")";
            }

            public int hashCode() {
                String string2 = this.message;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Invalid)) break block3;
                        Invalid invalid = (Invalid)object;
                        if (!Intrinsics.areEqual(this.message, invalid.message)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult$NotApplicable;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier$VerificationResult;", "()V", "structure-intellij"})
        public static final class NotApplicable
        extends VerificationResult {
            @NotNull
            public static final NotApplicable INSTANCE;

            private NotApplicable() {
                super(null);
            }

            static {
                NotApplicable notApplicable;
                INSTANCE = notApplicable = new NotApplicable();
            }
        }
    }
}

