/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.dependencies;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTree;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.PluginAware;
import com.jetbrains.plugin.structure.intellij.plugin.module.IdeModule;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bJ\f\u0010\"\u001a\u00020\u0013*\u00020\u0013H\u0002J.\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\n\u0010$\u001a\u00060\bj\u0002`\u0012H\u0002J@\u0010#\u001a\u00020\u0006*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\n\u0010$\u001a\u00060\bj\u0002`\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&2\b\b\u0002\u0010'\u001a\u00020\nH\u0002J\u0014\u0010(\u001a\u00020\u0013*\u00020\u00032\u0006\u0010$\u001a\u00020\bH\u0002JN\u0010\u001f\u001a\u00020\u0006*\u0012\u0012\b\u0012\u00060\bj\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\n\u0010$\u001a\u00060\bj\u0002`\u00122\u0006\u0010)\u001a\u00020\n2\u0010\u0010*\u001a\f\u0012\b\u0012\u00060\bj\u0002`\u00120&2\n\u0010+\u001a\u00060,j\u0002`-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree;", "", "pluginProvider", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;)V", "debugLog", "", "indent", "", "additionalIndentSize", "", "message", "params", "", "(Ljava/lang/String;ILjava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "getDependencyGraph", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/PluginId;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "graph", "resolutionDepth", "getTransitiveDependencies", "", "ignore", "", "dependency", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "missingId", "toDebugString", "", "pluginId", "asTransitive", "collectDependencies", "id", "dependencies", "", "layer", "getPluginOrModule", "indentSize", "visited", "printer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "DiGraph", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1#2:165\n1864#3,3:166\n1855#3,2:169\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n*L\n36#1,3:166\n107#1,2:169\n*E\n"})
public final class DependencyTree {
    private final PluginProvider pluginProvider;

    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull IdePlugin plugin) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        String string2 = plugin.getPluginId();
        if (string2 == null) {
            boolean bl = false;
            String string3 = this.missingId(plugin);
            throw new IllegalArgumentException(string3.toString());
        }
        String pluginId = string2;
        DiGraph<String, Dependency> graph = this.getDependencyGraph(plugin);
        return this.collectDependencies(graph, pluginId);
    }

    private final DiGraph<String, Dependency> getDependencyGraph(IdePlugin plugin) {
        DiGraph<String, Dependency> graph = new DiGraph<String, Dependency>();
        this.getDependencyGraph(plugin, graph, 0);
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    private final void getDependencyGraph(IdePlugin plugin, DiGraph<String, Dependency> graph, int resolutionDepth) {
        IdePlugin $this$with = plugin;
        boolean bl = false;
        String string2 = $this$with.getPluginId();
        if (string2 != null) {
            String pluginId = string2;
            String indent = StringsKt.repeat("  ", resolutionDepth);
            this.debugLog(indent, "Resolving {} dependencies for '{}': {}", $this$with.getDependencies().size(), pluginId, CollectionsKt.joinToString$default($this$with.getDependencies(), null, null, null, 0, null, getDependencyGraph.1.1.INSTANCE, 31, null));
            Iterable $this$forEachIndexed$iv = $this$with.getDependencies();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void dep;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PluginDependency pluginDependency = (PluginDependency)item$iv;
                int i = n;
                boolean bl2 = false;
                Dependency dependencyPlugin = this.getPluginOrModule(this.pluginProvider, dep.getId());
                if (this.ignore(plugin, (PluginDependency)dep)) {
                    this.debugLog(indent, i + 1, "Ignoring dependency '{}' in its modules", dep.getId());
                    continue;
                }
                if (graph.contains(pluginId, dependencyPlugin)) {
                    this.debugLog(indent, i + 1, "Resolved cached dependency '{}'", dep.getId());
                    continue;
                }
                this.debugLog(indent, i + 1, "Resolving dependency for '{}'", dep.getId());
                Dependency dependency = dependencyPlugin;
                if (dependency instanceof Dependency.Module || dependency instanceof Dependency.Plugin) {
                    if (!(dependencyPlugin instanceof PluginAware) || dependencyPlugin.matches(pluginId)) continue;
                    graph.addEdge(pluginId, dependencyPlugin);
                    this.getDependencyGraph(((PluginAware)((Object)dependencyPlugin)).getPlugin(), graph, resolutionDepth + 1);
                    continue;
                }
                if (!(dependency instanceof Dependency.None)) continue;
                this.debugLog(indent, "Plugin '{}' depends on a plugin '{}' that is not resolved in the IDE. Skipping", pluginId, dep.getId());
            }
        }
    }

    private final boolean ignore(IdePlugin plugin, PluginDependency dependency) {
        return dependency.isModule() && plugin.getDefinedModules().contains(dependency.getId());
    }

    private final String missingId(IdePlugin plugin) {
        String string2 = plugin.getPluginName();
        if (string2 == null) {
            string2 = "unknown name";
        }
        String name = string2;
        Path path = plugin.getOriginalFile();
        Comparable originalFile = path != null ? (Comparable)path : (Comparable)((Object)"unknown plugin artifact path");
        return "Plugin must have an ID. Name: " + name + ". Path: " + originalFile;
    }

    private final Set<Dependency> collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id) {
        Set set;
        Set $this$apply = set = (Set)new LinkedHashSet();
        boolean bl = false;
        DependencyTree.collectDependencies$default(this, $this$collectDependencies, id, $this$apply, 0, 4, null);
        return set;
    }

    private final void collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id, Set<Dependency> dependencies, int layer) {
        for (Dependency dependency : $this$collectDependencies.get(id)) {
            String depId;
            if (!(dependency instanceof PluginAware)) continue;
            Intrinsics.checkNotNull(((PluginAware)((Object)dependency)).getPlugin().getPluginId());
            Dependency dep = layer == 0 ? dependency : this.asTransitive(dependency);
            if (dependencies.contains(dep)) continue;
            Collection collection = dependencies;
            collection.add(dep);
            this.collectDependencies($this$collectDependencies, depId, dependencies, layer + 1);
        }
    }

    static /* synthetic */ void collectDependencies$default(DependencyTree dependencyTree, DiGraph diGraph, String string2, Set set, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        dependencyTree.collectDependencies(diGraph, string2, set, n);
    }

    private final Dependency getPluginOrModule(PluginProvider $this$getPluginOrModule, String id) {
        Dependency dependency;
        IdePlugin plugin = $this$getPluginOrModule.findPluginById(id);
        if (plugin != null) {
            dependency = plugin instanceof IdeModule ? new Dependency.Module(plugin, id, false, 4, null) : new Dependency.Plugin(plugin, false, 2, null);
        } else {
            IdePlugin idePlugin = $this$getPluginOrModule.findPluginByModule(id);
            if (idePlugin != null) {
                IdePlugin idePlugin2;
                IdePlugin it = idePlugin2 = idePlugin;
                boolean bl = false;
                IdePlugin idePlugin3 = it;
                Intrinsics.checkNotNullExpressionValue(idePlugin3, "it");
                dependency = new Dependency.Module(idePlugin3, id, false, 4, null);
            } else {
                dependency = Dependency.None.INSTANCE;
            }
        }
        return dependency;
    }

    private final void toDebugString(DiGraph<String, Dependency> $this$toDebugString, String id, int indentSize, Set<String> visited, StringBuilder printer) {
        String indent = StringsKt.repeat("  ", indentSize);
        Iterable $this$forEach$iv = $this$toDebugString.get(id);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            Object object;
            String depId;
            Dependency dep = (Dependency)element$iv;
            boolean bl = false;
            if (!(dep instanceof PluginAware)) continue;
            Intrinsics.checkNotNull(((PluginAware)((Object)dep)).getPlugin().getPluginId());
            if (!visited.contains(depId)) {
                object = visited;
                object.add(depId);
                object = printer;
                string2 = indent + "* " + dep;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
                this.toDebugString($this$toDebugString, depId, indentSize + 1, visited, printer);
                continue;
            }
            object = printer;
            string2 = indent + "* " + dep + " (already visited)";
            StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
        }
    }

    private final Dependency asTransitive(Dependency $this$asTransitive) {
        Dependency dependency;
        Dependency dependency2 = $this$asTransitive;
        if (dependency2 instanceof Dependency.Module) {
            dependency = Dependency.Module.copy$default((Dependency.Module)$this$asTransitive, null, null, true, 3, null);
        } else if (dependency2 instanceof Dependency.Plugin) {
            dependency = Dependency.Plugin.copy$default((Dependency.Plugin)$this$asTransitive, null, true, 1, null);
        } else if (dependency2 instanceof Dependency.None) {
            dependency = $this$asTransitive;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dependency;
    }

    @NotNull
    public final CharSequence toDebugString(@NotNull String pluginId) {
        StringBuilder stringBuilder;
        block0: {
            IdePlugin idePlugin;
            Intrinsics.checkNotNullParameter(pluginId, "pluginId");
            StringBuilder $this$apply = stringBuilder = new StringBuilder();
            boolean bl = false;
            IdePlugin idePlugin2 = this.pluginProvider.findPluginById(pluginId);
            if (idePlugin2 == null) break block0;
            IdePlugin plugin = idePlugin = idePlugin2;
            boolean bl2 = false;
            IdePlugin idePlugin3 = plugin;
            Intrinsics.checkNotNullExpressionValue(idePlugin3, "plugin");
            this.toDebugString(this.getDependencyGraph(idePlugin3), pluginId, 0, new LinkedHashSet(), $this$apply);
        }
        return stringBuilder;
    }

    private final void debugLog(String indent, String message2, Object ... params) {
        this.debugLog(indent, 0, message2, Arrays.copyOf(params, params.length));
    }

    private final void debugLog(String indent, int additionalIndentSize, String message2, Object ... params) {
        if (DependencyTreeKt.access$getLOG$p().isDebugEnabled()) {
            StringBuilder stringBuilder;
            String additionalIndent = additionalIndentSize > 0 ? "  " + (additionalIndentSize + 1) + ") " : "";
            StringBuilder $this$buildString = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$buildString.append(indent);
            $this$buildString.append(additionalIndent);
            $this$buildString.append(message2);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            String msg = string2;
            DependencyTreeKt.access$getLOG$p().debug(msg, Arrays.copyOf(params, params.length));
        }
    }

    public DependencyTree(@NotNull PluginProvider pluginProvider) {
        Intrinsics.checkNotNullParameter(pluginProvider, "pluginProvider");
        this.pluginProvider = pluginProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "I", "O", "", "()V", "adjacency", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addEdge", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "contains", "", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "get", "", "(Ljava/lang/Object;)Ljava/util/List;", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n361#2,7:165\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n*L\n159#1,7:165\n*E\n"})
    private static final class DiGraph<I, O> {
        private final HashMap<I, List<O>> adjacency = new HashMap();

        @NotNull
        public final List<O> get(I from) {
            List<Object> list = this.adjacency.get(from);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public final void addEdge(I from, O to) {
            Object object;
            Map $this$getOrPut$iv = this.adjacency;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(from);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Collection collection = (List)object;
            collection.add(to);
        }

        public final boolean contains(I from, O to) {
            List<O> list = this.adjacency.get(from);
            return list != null && list.contains(to);
        }
    }
}

