/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependencyKt;
import com.jetbrains.plugin.structure.base.problems.IncorrectZipOrJarFile;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.telemetry.MutablePluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.Classpath;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.JarFilesResourceResolver;
import com.jetbrains.plugin.structure.intellij.plugin.Module;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalDependencyResolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginFileNotFoundException;
import com.jetbrains.plugin.structure.intellij.plugin.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.DescriptorResource;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScanner;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.intellij.problems.AnyProblemToWarningPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002IJB!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J:\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J0\u0010&\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010'\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0)2\u0006\u0010+\u001a\u00020\u0006H\u0002J,\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020!2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J(\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JD\u00104\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u00105\u001a\u00020\u001cH\u0002JD\u00106\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u00105\u001a\u00020\u001cH\u0002J:\u00107\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J:\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u001eH\u0002J(\u0010>\u001a\u00020;2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010@\u001a\u00020;2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010A\u001a\u00020B*\u00020CH\u0002J\u001c\u0010D\u001a\u00020;*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010E\u001a\u00020FH\u0002J\f\u0010G\u001a\u00020H*\u00020HH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "myResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "THIRD_PARTY_LIBRARIES_FILE_NAME", "", "contentModuleScanner", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "optionalDependencyResolver", "Lcom/jetbrains/plugin/structure/intellij/plugin/OptionalDependencyResolver;", "createBundledModule", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "descriptorPath", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "createBundledPlugin", "fallbackPluginId", "createPlugin", "validateDescriptor", "", "extractZipAndCreatePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "getDescriptorResource", "Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/DescriptorResource;", "module", "Lcom/jetbrains/plugin/structure/intellij/plugin/Module$InlineModule;", "getInvalidPluginFileCreator", "pluginFileName", "getPluginCreator", "getPluginCreatorWithResult", "getThirdPartyDependenciesFromDir", "", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "pluginDirectory", "loadIconsFromDir", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "loadModuleFromDescriptorResource", "moduleId", "descriptorResource", "parentPlugin", "loadModuleInfoFromJarFile", "jarFile", "loadPluginInfoFromDirectory", "hasDotNetDirectory", "loadPluginInfoFromJarFile", "loadPluginInfoFromJarOrDirectory", "loadPluginInfoFromLibDirectory", "root", "logPluginCreationWarnings", "", "pluginId", "pluginCreator", "resolveContentModules", "currentPlugin", "resolveOptionalDependencies", "loadXml", "Lorg/jdom2/Document;", "Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult$Found;", "setTelemetry", "pluginCreationDurationInMillis", "", "withResolvedClasspath", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$CreationResult;", "Companion", "CreationResult", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,589:1\n11653#2,9:590\n13579#2:599\n13580#2:601\n11662#2:602\n1#3:600\n1#3:609\n766#4:603\n857#4,2:604\n766#4:606\n857#4,2:607\n17#5,6:610\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n*L\n242#1,9:590\n242#1:599\n242#1:601\n242#1:602\n242#1:600\n269#1:603\n269#1,2:604\n303#1:606\n303#1,2:607\n463#1,6:610\n*E\n"})
public final class IdePluginManager
implements PluginManager<IdePlugin> {
    private final String THIRD_PARTY_LIBRARIES_FILE_NAME;
    private final OptionalDependencyResolver optionalDependencyResolver;
    private final ContentModuleScanner contentModuleScanner;
    private final ResourceResolver myResourceResolver;
    private final Path extractDirectory;
    private final JarFileSystemProvider fileSystemProvider;
    private static final Logger LOG;
    @NotNull
    public static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    public static final String META_INF = "META-INF";
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadPluginInfoFromJarFile(Path jarFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
        Object object;
        try {
            PluginCreator pluginCreator;
            object = new PluginJar(jarFile, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                PluginDescriptorResult descriptor2 = jar.getPluginDescriptor("META-INF/" + descriptorPath);
                if (descriptor2 instanceof PluginDescriptorResult.Found) {
                    try {
                        PluginCreator pluginCreator4;
                        Document descriptorXml = this.loadXml((PluginDescriptorResult.Found)descriptor2);
                        PluginCreator $this$apply = pluginCreator4 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName(jarFile), descriptorPath, parentPlugin, validateDescriptor, descriptorXml, ((PluginDescriptorResult.Found)descriptor2).getPath(), resourceResolver, problemResolver);
                        boolean bl2 = false;
                        $this$apply.setIcons(jar.getIcons());
                        $this$apply.setThirdPartyDependencies(jar.getThirdPartyDependencies());
                        $this$apply.setHasDotNetPart(hasDotNetDirectory);
                        pluginCreator3 = pluginCreator4;
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to read descriptor [" + descriptorPath + "] from [" + jarFile + "]", e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                    boolean bl3 = false;
                    LOG.debug("Unable to resolve descriptor [{}] from [{}] ({})", descriptorPath, jarFile, descriptor2);
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            LOG.warn("Unable to extract {} (searching for {}): {}", jarFile, descriptorPath, LanguageUtilsKt.getShortExceptionMessage(e));
            object = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    static /* synthetic */ PluginCreator loadPluginInfoFromJarFile$default(IdePluginManager idePluginManager, Path path, String string2, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return idePluginManager.loadPluginInfoFromJarFile(path, string2, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadModuleInfoFromJarFile(Path jarFile, String descriptorPath, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        Object object;
        try {
            PluginCreator pluginCreator;
            object = new PluginJar(jarFile, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                PluginDescriptorResult descriptor2 = jar.getPluginDescriptor(descriptorPath);
                if (descriptor2 instanceof PluginDescriptorResult.Found) {
                    try {
                        Document descriptorXml = this.loadXml((PluginDescriptorResult.Found)descriptor2);
                        pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName(jarFile), descriptorPath, null, false, descriptorXml, ((PluginDescriptorResult.Found)descriptor2).getPath(), resourceResolver, problemResolver);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to read descriptor [" + descriptorPath + "] from [" + jarFile + "]", e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                    boolean bl2 = false;
                    LOG.debug("Unable to resolve descriptor [{}] from [{}] ({})", descriptorPath, jarFile, descriptor2);
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            LOG.warn("Unable to extract {} (searching for {}): {}", jarFile, descriptorPath, LanguageUtilsKt.getShortExceptionMessage(e));
            object = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadModuleFromDescriptorResource(String moduleId, DescriptorResource descriptorResource, PluginCreator parentPlugin, ResourceResolver resourceResolver) {
        PluginCreator pluginCreator;
        Closeable closeable = descriptorResource.getInputStream();
        Throwable throwable = null;
        try {
            PluginCreator pluginCreator2;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            try {
                PluginCreator pluginCreator3;
                AnyProblemToWarningPluginCreationResultResolver problemResolver = AnyProblemToWarningPluginCreationResultResolver.INSTANCE;
                Document document2 = JDOMUtil.loadDocument(it);
                Intrinsics.checkNotNullExpressionValue(document2, "JDOMUtil.loadDocument(it)");
                Document descriptorXml = document2;
                PluginCreator it2 = pluginCreator3 = PluginCreator.Companion.createPlugin(descriptorResource, parentPlugin, descriptorXml, resourceResolver, problemResolver);
                boolean bl2 = false;
                this.logPluginCreationWarnings(moduleId, it2);
                pluginCreator2 = pluginCreator3;
            }
            catch (IOException e) {
                DescriptorResource descriptorResource2;
                DescriptorResource $this$with = descriptorResource2 = descriptorResource;
                boolean bl3 = false;
                LOG.warn("Unable to read descriptor stream (source: '" + $this$with.getUri() + "')", e);
                UnableToReadDescriptor problem = new UnableToReadDescriptor($this$with.getFileName(), e.getLocalizedMessage());
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin($this$with.getArtifactFileName(), $this$with.getFileName(), (PluginProblem)problem);
            }
            pluginCreator = pluginCreator2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return pluginCreator;
    }

    static /* synthetic */ PluginCreator loadModuleFromDescriptorResource$default(IdePluginManager idePluginManager, String string2, DescriptorResource descriptorResource, PluginCreator pluginCreator, ResourceResolver resourceResolver, int n, Object object) {
        if ((n & 4) != 0) {
            pluginCreator = null;
        }
        return idePluginManager.loadModuleFromDescriptorResource(string2, descriptorResource, pluginCreator, resourceResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Document loadXml(PluginDescriptorResult.Found $this$loadXml) {
        Document document2;
        Closeable closeable = $this$loadXml.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Document document3 = JDOMUtil.loadDocument(it);
            document2 = document3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(document2, "inputStream.use {\n      \u2026il.loadDocument(it)\n    }");
        return document2;
    }

    private final PluginCreator loadPluginInfoFromDirectory(Path pluginDirectory, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
        PluginCreator pluginCreator;
        Path descriptorFile;
        Path path = descriptorFile = pluginDirectory.resolve(META_INF).resolve(FileUtilKt.withPathSeparatorOf(descriptorPath, pluginDirectory));
        Intrinsics.checkNotNullExpressionValue(path, "descriptorFile");
        if (!FileUtilKt.exists(path)) {
            pluginCreator = this.loadPluginInfoFromLibDirectory(pluginDirectory, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver);
        } else {
            PluginCreator pluginCreator2;
            try {
                PluginCreator pluginCreator3;
                Document document2 = JDOMUtil.loadDocument(Files.newInputStream(descriptorFile, new OpenOption[0]));
                Intrinsics.checkNotNullExpressionValue(document2, "JDOMUtil.loadDocument(Fi\u2026utStream(descriptorFile))");
                Document document3 = document2;
                List<PluginIcon> icons = this.loadIconsFromDir(pluginDirectory);
                List<ThirdPartyDependency> dependencies = this.getThirdPartyDependenciesFromDir(pluginDirectory);
                PluginCreator $this$apply = pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName(pluginDirectory), descriptorPath, parentPlugin, validateDescriptor, document3, descriptorFile, resourceResolver, problemResolver);
                boolean bl = false;
                $this$apply.setIcons(icons);
                $this$apply.setThirdPartyDependencies(dependencies);
                $this$apply.setHasDotNetPart(hasDotNetDirectory);
                pluginCreator2 = pluginCreator3;
            }
            catch (JDOMParseException e) {
                LOG.info("Unable to parse plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnexpectedDescriptorElements(e.getLineNumber(), descriptorPath));
            }
            catch (Exception e) {
                LOG.info("Unable to read plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, descriptorPath));
            }
            pluginCreator = pluginCreator2;
        }
        return pluginCreator;
    }

    static /* synthetic */ PluginCreator loadPluginInfoFromDirectory$default(IdePluginManager idePluginManager, Path path, String string2, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return idePluginManager.loadPluginInfoFromDirectory(path, string2, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
    }

    private final List<ThirdPartyDependency> getThirdPartyDependenciesFromDir(Path pluginDirectory) {
        Path path;
        Path path2 = path = pluginDirectory.resolve(META_INF).resolve(this.THIRD_PARTY_LIBRARIES_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue(path2, "path");
        return ThirdPartyDependencyKt.parseThirdPartyDependenciesByPath(path2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginIcon> loadIconsFromDir(Path pluginDirectory) throws IOException {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            PluginIcon pluginIcon2;
            Path iconFile;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            Path path = iconFile = pluginDirectory.resolve(META_INF).resolve(IdePluginManager.Companion.getIconFileName((IconTheme)theme));
            Intrinsics.checkNotNullExpressionValue(path, "iconFile");
            if (FileUtilKt.exists(path)) {
                byte[] byArray = Files.readAllBytes(iconFile);
                Intrinsics.checkNotNullExpressionValue(byArray, "Files.readAllBytes(iconFile)");
                pluginIcon2 = new PluginIcon((IconTheme)theme, byArray, FileUtilKt.getSimpleName(iconFile));
            } else {
                pluginIcon2 = null;
            }
            if (pluginIcon2 == null) continue;
            PluginIcon it$iv$iv = pluginIcon = pluginIcon2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PluginCreator loadPluginInfoFromLibDirectory(Path root, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv2;
        Path libDir = root.resolve("lib");
        Path path = root.resolve("dotnet");
        Intrinsics.checkNotNullExpressionValue(path, "root.resolve(\"dotnet\")");
        boolean hasDotNetDirectory = FileUtilKt.exists(path);
        Path path2 = libDir;
        Intrinsics.checkNotNullExpressionValue(path2, "libDir");
        if (!FileUtilKt.isDirectory(path2)) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
        }
        List<Path> files2 = FileUtilKt.listFiles(libDir);
        if (files2.isEmpty()) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginLibDirectoryIsEmpty());
        }
        Iterable $this$filter$iv2 = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            Path it = (Path)element$iv$iv2;
            boolean bl = false;
            if (!FileUtilKt.isJar(it)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List jarFiles = (List)destination$iv$iv;
        ResourceResolver libResourceResolver = new JarFilesResourceResolver(jarFiles);
        ResourceResolver compositeResolver = new CompositeResourceResolver(CollectionsKt.listOf(libResourceResolver, resourceResolver));
        List results = new ArrayList();
        for (Path file2 : files2) {
            PluginCreator pluginCreator2;
            if (FileUtilKt.isJar(file2) || FileUtilKt.isZip(file2)) {
                pluginCreator2 = this.loadPluginInfoFromJarFile(file2, descriptorPath, validateDescriptor, compositeResolver, parentPlugin, problemResolver, hasDotNetDirectory);
            } else {
                if (!FileUtilKt.isDirectory(file2)) continue;
                pluginCreator2 = this.loadPluginInfoFromDirectory(file2, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
            }
            PluginCreator innerCreator = pluginCreator2;
            results.add(new CreationResult(root, innerCreator));
        }
        Iterable $i$f$filterTo22 = results;
        boolean $i$f$filter2 = false;
        element$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            CreationResult $dstr$_u24__u24$r = (CreationResult)element$iv$iv3;
            boolean bl = false;
            PluginCreator r = $dstr$_u24__u24$r.component2();
            if (!(r.isSuccess() || IdePluginManager.Companion.hasOnlyInvalidDescriptorErrors(r))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List possibleResults = (List)destination$iv$iv2;
        switch (possibleResults.size()) {
            case 0: {
                pluginCreator = PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                break;
            }
            case 1: {
                pluginCreator = this.withResolvedClasspath((CreationResult)possibleResults.get(0)).getCreator();
                break;
            }
            default: {
                PluginCreator first2 = ((CreationResult)possibleResults.get(0)).getCreator();
                PluginCreator second2 = ((CreationResult)possibleResults.get(1)).getCreator();
                PluginProblem multipleDescriptorsProblem = new MultiplePluginDescriptors(first2.getDescriptorPath(), first2.getPluginFileName(), second2.getDescriptorPath(), second2.getPluginFileName());
                pluginCreator = PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, multipleDescriptorsProblem);
            }
        }
        return pluginCreator;
    }

    private final PluginCreator loadPluginInfoFromJarOrDirectory(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        LOG.debug("Loading {} with descriptor [{}]", (Object)pluginFile, (Object)descriptorPath);
        String systemIndependentDescriptorPath = FileUtilKt.toSystemIndependentName(descriptorPath);
        if (FileUtilKt.isDirectory(pluginFile)) {
            pluginCreator = IdePluginManager.loadPluginInfoFromDirectory$default(this, pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null);
        } else if (FileUtilKt.isJar(pluginFile)) {
            pluginCreator = IdePluginManager.loadPluginInfoFromJarFile$default(this, pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        return pluginCreator;
    }

    private final void resolveOptionalDependencies(Path pluginFile, PluginCreator pluginCreator, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (pluginCreator.isSuccess()) {
            this.optionalDependencyResolver.resolveOptionalDependencies(pluginCreator, pluginFile, resourceResolver, problemResolver);
        }
    }

    private final void resolveContentModules(Path pluginFile, PluginCreator currentPlugin, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (currentPlugin.isSuccess()) {
            ArrayList<Module> contentModules = currentPlugin.getContentModules();
            for (Module module : contentModules) {
                PluginCreator moduleCreator;
                Module module2 = module;
                if (module2 instanceof Module.FileBasedModule) {
                    String configFile = ((Module.FileBasedModule)module).getConfigFile();
                    moduleCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, configFile, false, resourceResolver, currentPlugin, problemResolver);
                    currentPlugin.addModuleDescriptor(module.getName(), module.getLoadingRule(), configFile, moduleCreator);
                    continue;
                }
                if (!(module2 instanceof Module.InlineModule)) continue;
                Module module3 = module;
                Intrinsics.checkNotNullExpressionValue(module3, "module");
                DescriptorResource moduleDescriptorResource = this.getDescriptorResource((Module.InlineModule)module3, pluginFile, currentPlugin.getDescriptorPath());
                moduleCreator = this.loadModuleFromDescriptorResource(module.getName(), moduleDescriptorResource, currentPlugin, resourceResolver);
                currentPlugin.addModuleDescriptor$structure_intellij((Module.InlineModule)module, module.getLoadingRule(), moduleDescriptorResource, moduleCreator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator extractZipAndCreatePlugin(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        ExtractorResult extractorResult;
        ExtractorResult extractorResult2;
        try {
            extractorResult2 = PluginExtractor.INSTANCE.extractPlugin(pluginFile, this.extractDirectory);
        }
        catch (Exception e) {
            LOG.info("Unable to extract plugin zip " + FileUtilKt.getSimpleName(pluginFile), e);
            return PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName(pluginFile), descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        extractorResult2 = extractorResult = extractorResult2;
        if (extractorResult2 instanceof ExtractorResult.Success) {
            Closeable closeable = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            Throwable throwable = null;
            try {
                ExtractedPlugin $dstr$extractedFile = (ExtractedPlugin)closeable;
                boolean bl = false;
                Path extractedFile = $dstr$extractedFile.component1();
                PluginCreator pluginCreator2 = FileUtilKt.isJar(extractedFile) || FileUtilKt.isDirectory(extractedFile) ? this.getPluginCreator(extractedFile, descriptorPath, validateDescriptor, resourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName(pluginFile), descriptorPath);
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else if (extractorResult2 instanceof ExtractorResult.Fail) {
            pluginCreator = PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName(pluginFile), descriptorPath, ((ExtractorResult.Fail)extractorResult).getPluginProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreator;
    }

    @Override
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        return IdePluginManager.createPlugin$default(this, pluginFile, true, null, null, 12, null);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile, boolean validateDescriptor, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) throws PluginFileNotFoundException {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor, descriptorPath, problemResolver);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createPlugin$default(IdePluginManager idePluginManager, Path path, boolean bl, String string2, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 4) != 0) {
            string2 = PLUGIN_XML;
        }
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createPlugin(path, bl, string2, pluginCreationResultResolver);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledPlugin(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver, @Nullable String fallbackPluginId) throws PluginFileNotFoundException {
        PluginCreator pluginCreator;
        block0: {
            String string2;
            Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            pluginCreator = this.getPluginCreatorWithResult(pluginFile, false, descriptorPath, problemResolver);
            String string3 = ideVersion.asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue(string3, "ideVersion.asStringWithoutProductCode()");
            pluginCreator.setPluginVersion(string3);
            String string4 = fallbackPluginId;
            if (string4 == null) break block0;
            String it = string2 = string4;
            boolean bl = false;
            pluginCreator.setPluginIdIfNull(it);
        }
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledPlugin$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string2, PluginCreationResultResolver pluginCreationResultResolver, String string3, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        return idePluginManager.createBundledPlugin(path, ideVersion, string2, pluginCreationResultResolver, string3);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledModule(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator $this$apply = pluginCreator = this.loadModuleInfoFromJarFile(pluginFile, descriptorPath, this.myResourceResolver, problemResolver);
        boolean bl = false;
        String string2 = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.asStringWithoutProductCode()");
        $this$apply.setPluginVersion(string2);
        $this$apply.setOriginalFile(pluginFile);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledModule$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string2, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createBundledModule(path, ideVersion, string2, pluginCreationResultResolver);
    }

    private final PluginCreator getPluginCreatorWithResult(Path pluginFile, boolean validateDescriptor, String descriptorPath, PluginCreationResultResolver problemResolver) throws PluginFileNotFoundException {
        long l;
        if (!FileUtilKt.exists(pluginFile)) {
            throw (Throwable)new PluginFileNotFoundException(pluginFile);
        }
        PluginCreator pluginCreator = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        pluginCreator = FileUtilKt.isZip(pluginFile) ? this.extractZipAndCreatePlugin(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : (FileUtilKt.isJar(pluginFile) || FileUtilKt.isDirectory(pluginFile) ? this.getPluginCreator(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName(pluginFile), descriptorPath));
        pluginCreator.setOriginalFile(pluginFile);
        long pluginCreationDuration = l = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        this.setTelemetry(pluginCreator, pluginFile, pluginCreationDuration);
        return pluginCreator;
    }

    private final PluginCreator getPluginCreator(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, descriptorPath, validateDescriptor, resourceResolver, null, problemResolver);
        this.resolveOptionalDependencies(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        this.resolveContentModules(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        return pluginCreator;
    }

    private final PluginCreator getInvalidPluginFileCreator(String pluginFileName, String descriptorPath) {
        return PluginCreator.Companion.createInvalidPlugin(pluginFileName, descriptorPath, (PluginProblem)new IncorrectZipOrJarFile(pluginFileName));
    }

    private final void setTelemetry(PluginCreator $this$setTelemetry, Path pluginFile, long pluginCreationDurationInMillis) {
        MutablePluginTelemetry mutablePluginTelemetry;
        MutablePluginTelemetry $this$with = mutablePluginTelemetry = $this$setTelemetry.getTelemetry();
        boolean bl = false;
        $this$with.setParsingDuration(Duration.ofMillis(pluginCreationDurationInMillis));
        $this$with.setArchiveFileSize(FileUtilKt.getPluginSize(pluginFile));
    }

    private final DescriptorResource getDescriptorResource(Module.InlineModule module, Path pluginFile, String descriptorPath) {
        String parentUriStr = FileUtilKt.isJar(pluginFile) ? "jar:" + pluginFile.toUri().toString() + "!" + FileUtilKt.toSystemIndependentName(descriptorPath) : pluginFile.toUri().toString() + "/" + FileUtilKt.toSystemIndependentName(descriptorPath);
        String uriStr = parentUriStr + "#modules/" + module.getName();
        String string2 = module.getTextContent();
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return new DescriptorResource(new ByteArrayInputStream(byArray), new URI(uriStr), new URI(parentUriStr));
    }

    private final void logPluginCreationWarnings(String pluginId, PluginCreator pluginCreator) {
        PluginCreationResult<IdePlugin> pluginCreationResult = pluginCreator.getPluginCreationResult();
        Logger logger = LOG;
        Intrinsics.checkNotNullExpressionValue(logger, "LOG");
        if (logger.isDebugEnabled() && pluginCreationResult instanceof PluginCreationSuccess) {
            String warningMessage2 = CollectionsKt.joinToString$default(((PluginCreationSuccess)pluginCreationResult).getWarnings(), "\n", null, null, 0, null, logPluginCreationWarnings.warningMessage.1.INSTANCE, 30, null);
            LOG.debug("Plugin or module '" + pluginId + "' has plugin problems: " + warningMessage2);
        }
    }

    private final CreationResult withResolvedClasspath(CreationResult $this$withResolvedClasspath) {
        CreationResult creationResult;
        CreationResult $this$apply = creationResult = $this$withResolvedClasspath;
        boolean bl = false;
        ContentModules contentModules = this.contentModuleScanner.getContentModules($this$apply.getArtifact());
        Classpath classpath = contentModules.asClasspath();
        $this$apply.getCreator().setClasspath(classpath);
        return creationResult;
    }

    private IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider) {
        this.myResourceResolver = myResourceResolver;
        this.extractDirectory = extractDirectory;
        this.fileSystemProvider = fileSystemProvider;
        this.THIRD_PARTY_LIBRARIES_FILE_NAME = "dependencies.json";
        Function6 function6 = new Function6<Path, String, Boolean, ResourceResolver, PluginCreator, PluginCreationResultResolver, PluginCreator>(this){

            @NotNull
            public final PluginCreator invoke(@NotNull Path p1, @NotNull String p2, boolean p3, @NotNull ResourceResolver p4, @Nullable PluginCreator p5, @NotNull PluginCreationResultResolver p6) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                Intrinsics.checkNotNullParameter(p4, "p4");
                Intrinsics.checkNotNullParameter(p6, "p6");
                return IdePluginManager.access$loadPluginInfoFromJarOrDirectory((IdePluginManager)this.receiver, p1, p2, p3, p4, p5, p6);
            }
        };
        this.optionalDependencyResolver = new OptionalDependencyResolver(new PluginLoader(function6){
            private final /* synthetic */ Function6 function;
            {
                this.function = function6;
            }

            public final /* synthetic */ PluginCreator load(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
                Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
                Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
                Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
                Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
                R r = this.function.invoke(pluginFile, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver);
                Intrinsics.checkNotNullExpressionValue(r, "invoke(...)");
                return (PluginCreator)r;
            }

            public Function getFunctionDelegate() {
                return this.function;
            }

            public boolean equals(Object object) {
                return object instanceof PluginLoader && object instanceof FunctionAdapter && Intrinsics.areEqual(this.function, ((FunctionAdapter)object).getFunctionDelegate());
            }

            public int hashCode() {
                return this.function.hashCode();
            }
        });
        this.contentModuleScanner = new ContentModuleScanner();
    }

    /* synthetic */ IdePluginManager(ResourceResolver resourceResolver, Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(resourceResolver, path, jarFileSystemProvider);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(IdePluginManager.class);
    }

    @Override
    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        return PluginManager.DefaultImpls.createPlugin(this, pluginFile);
    }

    public static final /* synthetic */ PluginCreator access$loadPluginInfoFromJarOrDirectory(IdePluginManager $this, Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        return $this.loadPluginInfoFromJarOrDirectory(pluginFile, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver);
    }

    public /* synthetic */ IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider, DefaultConstructorMarker $constructor_marker) {
        this(myResourceResolver, extractDirectory, fileSystemProvider);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager() {
        return Companion.createManager();
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
        return Companion.createManager(resourceResolver);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull Path extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
        return Companion.createManager(resourceResolver, extractDirectory, fileSystemProvider);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull File extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$CreationResult;", "", "artifact", "Ljava/nio/file/Path;", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;)V", "getArtifact", "()Ljava/nio/file/Path;", "getCreator", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "structure-intellij"})
    private static final class CreationResult {
        @NotNull
        private final Path artifact;
        @NotNull
        private final PluginCreator creator;

        @NotNull
        public final Path getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final PluginCreator getCreator() {
            return this.creator;
        }

        public CreationResult(@NotNull Path artifact, @NotNull PluginCreator creator) {
            Intrinsics.checkNotNullParameter(artifact, "artifact");
            Intrinsics.checkNotNullParameter(creator, "creator");
            this.artifact = artifact;
            this.creator = creator;
        }

        @NotNull
        public final Path component1() {
            return this.artifact;
        }

        @NotNull
        public final PluginCreator component2() {
            return this.creator;
        }

        @NotNull
        public final CreationResult copy(@NotNull Path artifact, @NotNull PluginCreator creator) {
            Intrinsics.checkNotNullParameter(artifact, "artifact");
            Intrinsics.checkNotNullParameter(creator, "creator");
            return new CreationResult(artifact, creator);
        }

        public static /* synthetic */ CreationResult copy$default(CreationResult creationResult, Path path, PluginCreator pluginCreator, int n, Object object) {
            if ((n & 1) != 0) {
                path = creationResult.artifact;
            }
            if ((n & 2) != 0) {
                pluginCreator = creationResult.creator;
            }
            return creationResult.copy(path, pluginCreator);
        }

        @NotNull
        public String toString() {
            return "CreationResult(artifact=" + this.artifact + ", creator=" + this.creator + ")";
        }

        public int hashCode() {
            Path path = this.artifact;
            PluginCreator pluginCreator = this.creator;
            return (path != null ? ((Object)path).hashCode() : 0) * 31 + (pluginCreator != null ? pluginCreator.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CreationResult)) break block3;
                    CreationResult creationResult = (CreationResult)object;
                    if (!Intrinsics.areEqual(this.artifact, creationResult.artifact) || !Intrinsics.areEqual(this.creator, creationResult.creator)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_INF", "", "PLUGIN_XML", "createManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/io/File;", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "getIconFileName", "iconTheme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "hasOnlyInvalidDescriptorErrors", "", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,589:1\n1726#2,3:590\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion\n*L\n582#1,3:590\n*E\n"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager() {
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            return this.createManager(resourceResolver, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, extractDirectory);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return new IdePluginManager(resourceResolver, extractDirectory, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
            return new IdePluginManager(resourceResolver, extractDirectory, fileSystemProvider, null);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            ResourceResolver resourceResolver = DefaultResourceResolver.INSTANCE;
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        private final boolean hasOnlyInvalidDescriptorErrors(PluginCreator creator) {
            boolean bl;
            block7: {
                PluginCreationResult<IdePlugin> pluginCreationResult = creator.getPluginCreationResult();
                if (pluginCreationResult instanceof PluginCreationSuccess) {
                    bl = false;
                } else if (pluginCreationResult instanceof PluginCreationFail) {
                    List<PluginProblem> errorsAndWarnings = ((PluginCreationFail)pluginCreationResult).getErrorsAndWarnings();
                    Iterable $this$all$iv = errorsAndWarnings;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PluginProblem it = (PluginProblem)element$iv;
                            boolean bl2 = false;
                            if (it.getLevel() != PluginProblem.Level.ERROR || PluginProblemsKt.isInvalidDescriptorProblem(it)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        private final String getIconFileName(IconTheme iconTheme) {
            return "pluginIcon" + iconTheme.getSuffix() + ".svg";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

