/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"createPathVariables", "", "", "getRepositoryLibrariesJars", "", "Ljava/nio/file/Path;", "projectPath", "loadProject", "Lorg/jetbrains/jps/model/JpsProject;", "pathVariables", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nRepositoryLibrariesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryLibrariesUtil.kt\ncom/jetbrains/plugin/structure/ide/RepositoryLibrariesUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1360#2:47\n1446#2,5:48\n1549#2:53\n1620#2,3:54\n1655#2,8:57\n766#2:65\n857#2,2:66\n1#3:68\n*E\n*S KotlinDebug\n*F\n+ 1 RepositoryLibrariesUtil.kt\ncom/jetbrains/plugin/structure/ide/RepositoryLibrariesUtilKt\n*L\n26#1:47\n26#1,5:48\n27#1:53\n27#1,3:54\n28#1,8:57\n29#1:65\n29#1,2:66\n*E\n"})
public final class RepositoryLibrariesUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> getRepositoryLibrariesJars(@NotNull Path projectPath) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        JpsLibrary it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(projectPath, "projectPath");
        Map<String, String> pathVariables = RepositoryLibrariesUtilKt.createPathVariables();
        JpsProject project = RepositoryLibrariesUtilKt.loadProject(projectPath, pathVariables);
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies(project).productionOnly().runtimeOnly();
        Intrinsics.checkNotNullExpressionValue(jpsJavaDependenciesEnumerator, "JpsJavaExtensionService.\u2026Only()\n    .runtimeOnly()");
        Set<JpsLibrary> set = jpsJavaDependenciesEnumerator.getLibraries();
        Intrinsics.checkNotNullExpressionValue(set, "JpsJavaExtensionService.\u2026timeOnly()\n    .libraries");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (JpsLibrary)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles(JpsOrderRootType.COMPILED);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = ((File)((Object)it)).toPath();
            collection.add(path);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        Iterable<String> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Path it2 = (Path)e$iv;
            boolean bl = false;
            String key$iv = ((Object)it2).toString();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$filter$iv = list$iv;
        boolean $i$f$filter = false;
        set$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it3 = (Path)element$iv$iv;
            boolean bl = false;
            Path path = it3;
            Intrinsics.checkNotNullExpressionValue(path, "it");
            if (!FileUtilKt.isJar(path)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final JpsProject loadProject(Path projectPath, Map<String, String> pathVariables) {
        JpsModel model;
        System.setProperty("idea.home.path", ((Object)projectPath.toAbsolutePath()).toString());
        JpsModel jpsModel = model = JpsElementFactory.getInstance().createModel();
        Intrinsics.checkNotNullExpressionValue(jpsModel, "model");
        JpsProjectLoader.loadProject(jpsModel.getProject(), pathVariables, ((Object)projectPath.toAbsolutePath()).toString());
        JpsProject jpsProject = model.getProject();
        Intrinsics.checkNotNullExpressionValue(jpsProject, "model.project");
        return jpsProject;
    }

    private static final Map<String, String> createPathVariables() {
        Object object;
        block3: {
            block2: {
                String string2;
                object = System.getProperty("MAVEN_REPOSITORY");
                if (object == null) break block2;
                String it = string2 = object;
                boolean bl = false;
                object = Paths.get(it, new String[0]);
                if (object != null) break block3;
            }
            object = Paths.get(SystemProperties.getUserHome(), new String[0]).resolve(".m2").resolve("repository");
        }
        Object mavenRepoFile = object;
        String string3 = FileUtil.toSystemIndependentName(((Object)mavenRepoFile.toAbsolutePath()).toString());
        Intrinsics.checkNotNullExpressionValue(string3, "FileUtil.toSystemIndepen\u2026bsolutePath().toString())");
        String m2Repo = string3;
        return MapsKt.mapOf(TuplesKt.to("MAVEN_REPOSITORY", m2Repo));
    }
}

