/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ParametersListUtil {
    @NotNull
    public static String join(@NotNull List<String> parameters2) {
        return ParametersListUtil.encode(parameters2);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        return ParametersListUtil.parse(parameterString, false);
    }

    @NotNull
    private static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                if (!keepQuotes) continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params;
    }

    @NotNull
    private static String encode(@NotNull List<String> parameters2) {
        StringBuilder buffer = new StringBuilder();
        for (String parameter : parameters2) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(ParametersListUtil.encode(parameter));
        }
        return buffer.toString();
    }

    @NotNull
    private static String encode(@NotNull String parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(parameter);
        ParametersListUtil.escapeQuotes(builder);
        if (builder.length() == 0 || ParametersListUtil.indexOf(builder, ' ') >= 0 || ParametersListUtil.indexOf(builder, '|') >= 0) {
            ParametersListUtil.quote(builder);
        }
        return builder.toString();
    }

    private static void quote(@NotNull StringBuilder builder) {
        ParametersListUtil.quote(builder, '\"');
    }

    private static void quote(@NotNull StringBuilder builder, char quotingChar) {
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    private static void escapeQuotes(@NotNull StringBuilder buf) {
        ParametersListUtil.escapeChar(buf, '\"');
    }

    private static void escapeChar(@NotNull StringBuilder buf, char character) {
        int idx = 0;
        while ((idx = ParametersListUtil.indexOf(buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    private static int indexOf(@NotNull CharSequence s2, char c) {
        return ParametersListUtil.indexOf(s2, c, 0, s2.length());
    }

    private static int indexOf(@NotNull CharSequence s2, char c, int start) {
        return ParametersListUtil.indexOf(s2, c, start, s2.length());
    }

    private static int indexOf(@NotNull CharSequence s2, char c, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s2.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

