/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.contentBuilder;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ChildrenOwnerSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilder;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilderImpl;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilderKt;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.DirectorySpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.FileSpec;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J)\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J/\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\u0002\b\u0012H\u0002J)\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e*\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl;", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilder;", "result", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ChildrenOwnerSpec;", "(Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ChildrenOwnerSpec;)V", "addChild", "", "name", "", "spec", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "buildHierarchy", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl$SingleChildSpec;", "specs", "", "dir", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "localDirectory", "Ljava/nio/file/Path;", "dirs", "file", "textProvider", "Lkotlin/Function0;", "localFile", "", "text", "resolveDirs", "pathElements", "zip", "windowedPairs", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl$ParentAndChild;", "ParentAndChild", "SingleChildSpec", "structure-base"})
@SourceDebugExtension(value={"SMAP\nContentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentBuilder.kt\ncom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n1559#3:154\n1590#3,4:155\n*E\n*S KotlinDebug\n*F\n+ 1 ContentBuilder.kt\ncom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl\n*L\n118#1:154\n118#1,4:155\n*E\n"})
final class ContentBuilderImpl
implements ContentBuilder {
    private final ChildrenOwnerSpec result;

    @Override
    public void file(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.file(name, "");
    }

    @Override
    public void file(@NotNull String name, @NotNull Function0<String> textProvider) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(textProvider, "textProvider");
        this.file(name, textProvider.invoke());
    }

    @Override
    public void file(@NotNull String name, @NotNull String text) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(text, "text");
        String string2 = text;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this.file(name, byArray);
    }

    @Override
    public void file(@NotNull String name, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        this.addChild(name, new FileSpec(content));
    }

    @Override
    public void file(@NotNull String name, @NotNull Path localFile) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(localFile, "localFile");
        this.file(name, FileUtilKt.readBytes(localFile));
    }

    @Override
    public void dir(@NotNull String name, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec directorySpec = ContentBuilderKt.buildDirectoryContent(content);
        this.addChild(name, directorySpec);
    }

    @Override
    public void dirs(@NotNull String name, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        List pathElements = StringsKt.split$default((CharSequence)name, new String[]{"/"}, false, 0, 6, null);
        switch (pathElements.size()) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("Cannot have empty name");
            }
            case 1: {
                this.dir((String)CollectionsKt.first(pathElements), content);
                break;
            }
            case 2: {
                this.dir((String)CollectionsKt.first(pathElements), (Function1<? super ContentBuilder, Unit>)new Function1<ContentBuilder, Unit>(pathElements, content){
                    final /* synthetic */ List $pathElements;
                    final /* synthetic */ Function1 $content;

                    public final void invoke(@NotNull ContentBuilder $this$dir) {
                        Intrinsics.checkNotNullParameter($this$dir, "$receiver");
                        $this$dir.dir((String)this.$pathElements.get(1), this.$content);
                    }
                    {
                        this.$pathElements = list;
                        this.$content = function1;
                        super(1);
                    }
                });
                break;
            }
            default: {
                String firstElement = (String)CollectionsKt.first(pathElements);
                List<String> rest = CollectionsKt.drop(pathElements, 1);
                this.addChild(firstElement, this.resolveDirs(rest, content));
            }
        }
    }

    @Override
    public void dir(@NotNull String name, @NotNull Path localDirectory) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(localDirectory, "localDirectory");
        boolean bl = FileUtilKt.isDirectory(localDirectory);
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Not a directory: " + localDirectory;
            throw new IllegalStateException(string2.toString());
        }
        this.dir(name, (Function1<? super ContentBuilder, Unit>)new Function1<ContentBuilder, Unit>(localDirectory){
            final /* synthetic */ Path $localDirectory;

            public final void invoke(@NotNull ContentBuilder $this$dir) {
                Intrinsics.checkNotNullParameter($this$dir, "$receiver");
                List<Path> list = FileUtilKt.listFiles(this.$localDirectory);
                List<Path> list2 = list;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                for (Path child : list2) {
                    if (FileUtilKt.isFile(child)) {
                        $this$dir.file(FileUtilKt.getSimpleName(child), child);
                        continue;
                    }
                    if (FileUtilKt.isDirectory(child)) {
                        $this$dir.dir(FileUtilKt.getSimpleName(child), child);
                        continue;
                    }
                    throw (Throwable)new IllegalArgumentException("Unknown file type: " + child.toAbsolutePath());
                }
            }
            {
                this.$localDirectory = path;
                super(1);
            }
        });
    }

    @Override
    public void zip(@NotNull String name, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec zipFileContent = ContentBuilderKt.buildZipFileContent(content);
        this.addChild(name, zipFileContent);
    }

    private final void addChild(String name, ContentSpec spec) {
        this.result.addChild(name, spec);
    }

    /*
     * WARNING - void declaration
     */
    private final SingleChildSpec resolveDirs(List<String> pathElements, Function1<? super ContentBuilder, Unit> content) {
        void $this$mapIndexedTo$iv$iv;
        List<ParentAndChild> parentAndChildPairs = this.windowedPairs(pathElements);
        Iterable $this$mapIndexed$iv = parentAndChildPairs;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parent;
            void i;
            void $dstr$parent$child;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ParentAndChild parentAndChild = (ParentAndChild)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = $dstr$parent$child.component1();
            String child = $dstr$parent$child.component2();
            ContentSpec childContent = i < CollectionsKt.getLastIndex(parentAndChildPairs) ? (ContentSpec)new DirectorySpec() : ContentBuilderKt.buildDirectoryContent(content);
            SingleChildSpec singleChildSpec = new SingleChildSpec((String)parent, child, childContent);
            collection.add(singleChildSpec);
        }
        List directorySpecs = (List)destination$iv$iv;
        return this.buildHierarchy(directorySpecs);
    }

    private final SingleChildSpec buildHierarchy(List<SingleChildSpec> specs) {
        ArrayDeque<SingleChildSpec> arrayDeque;
        ArrayDeque<SingleChildSpec> $this$with = arrayDeque = new ArrayDeque<SingleChildSpec>((Collection)specs);
        boolean bl = false;
        while ($this$with.size() > 1) {
            SingleChildSpec child = (SingleChildSpec)$this$with.removeLast();
            SingleChildSpec parent = (SingleChildSpec)$this$with.removeLast();
            $this$with.addLast(SingleChildSpec.copy$default(parent, null, child, 1, null));
        }
        return (SingleChildSpec)$this$with.first();
    }

    private final List<ParentAndChild> windowedPairs(List<String> $this$windowedPairs) {
        return CollectionsKt.windowed$default($this$windowedPairs, 2, 0, false, windowedPairs.1.INSTANCE, 6, null);
    }

    public ContentBuilderImpl(@NotNull ChildrenOwnerSpec result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.result = result2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl$ParentAndChild;", "", "parent", "", "child", "(Ljava/lang/String;Ljava/lang/String;)V", "getChild", "()Ljava/lang/String;", "getParent", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-base"})
    private static final class ParentAndChild {
        @NotNull
        private final String parent;
        @NotNull
        private final String child;

        @NotNull
        public final String getParent() {
            return this.parent;
        }

        @NotNull
        public final String getChild() {
            return this.child;
        }

        public ParentAndChild(@NotNull String parent, @NotNull String child) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(child, "child");
            this.parent = parent;
            this.child = child;
        }

        @NotNull
        public final String component1() {
            return this.parent;
        }

        @NotNull
        public final String component2() {
            return this.child;
        }

        @NotNull
        public final ParentAndChild copy(@NotNull String parent, @NotNull String child) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(child, "child");
            return new ParentAndChild(parent, child);
        }

        public static /* synthetic */ ParentAndChild copy$default(ParentAndChild parentAndChild, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = parentAndChild.parent;
            }
            if ((n & 2) != 0) {
                string3 = parentAndChild.child;
            }
            return parentAndChild.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "ParentAndChild(parent=" + this.parent + ", child=" + this.child + ")";
        }

        public int hashCode() {
            String string2 = this.parent;
            String string3 = this.child;
            return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParentAndChild)) break block3;
                    ParentAndChild parentAndChild = (ParentAndChild)object;
                    if (!Intrinsics.areEqual(this.parent, parentAndChild.parent) || !Intrinsics.areEqual(this.child, parentAndChild.child)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl$SingleChildSpec;", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "name", "", "child", "childContent", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;)V", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;)V", "getChild", "()Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "generate", "", "target", "Ljava/nio/file/Path;", "hashCode", "", "toString", "structure-base"})
    private static final class SingleChildSpec
    implements ContentSpec {
        @NotNull
        private final String name;
        @NotNull
        private final ContentSpec child;

        @Override
        public void generate(@NotNull Path target) {
            Path childFile;
            Intrinsics.checkNotNullParameter(target, "target");
            FileUtilKt.createDir(target);
            Path path = childFile = target.resolve(this.name);
            Intrinsics.checkNotNullExpressionValue(path, "childFile");
            this.child.generate(path);
        }

        @NotNull
        public String toString() {
            return this.name + "/" + this.child;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ContentSpec getChild() {
            return this.child;
        }

        public SingleChildSpec(@NotNull String name, @NotNull ContentSpec child) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(child, "child");
            this.name = name;
            this.child = child;
        }

        public SingleChildSpec(@NotNull String name, @NotNull String child, @NotNull ContentSpec childContent) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(child, "child");
            Intrinsics.checkNotNullParameter(childContent, "childContent");
            this(name, new SingleChildSpec(child, childContent));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ContentSpec component2() {
            return this.child;
        }

        @NotNull
        public final SingleChildSpec copy(@NotNull String name, @NotNull ContentSpec child) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(child, "child");
            return new SingleChildSpec(name, child);
        }

        public static /* synthetic */ SingleChildSpec copy$default(SingleChildSpec singleChildSpec, String string2, ContentSpec contentSpec, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = singleChildSpec.name;
            }
            if ((n & 2) != 0) {
                contentSpec = singleChildSpec.child;
            }
            return singleChildSpec.copy(string2, contentSpec);
        }

        public int hashCode() {
            String string2 = this.name;
            ContentSpec contentSpec = this.child;
            return (string2 != null ? string2.hashCode() : 0) * 31 + (contentSpec != null ? contentSpec.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SingleChildSpec)) break block3;
                    SingleChildSpec singleChildSpec = (SingleChildSpec)object;
                    if (!Intrinsics.areEqual(this.name, singleChildSpec.name) || !Intrinsics.areEqual(this.child, singleChildSpec.child)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

