/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/ZipDecompressor;", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor;", "zipFile", "Ljava/nio/file/Path;", "sizeLimit", "", "(Ljava/nio/file/Path;Ljava/lang/Long;)V", "stream", "Ljava/util/zip/ZipInputStream;", "closeNextEntryStream", "", "entryStream", "Ljava/io/InputStream;", "closeStream", "nextEntry", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "nextEntryStream", "openStream", "structure-base"})
public final class ZipDecompressor
extends Decompressor {
    private ZipInputStream stream;
    private final Path zipFile;

    @Override
    public void openStream() {
        InputStream inputStream2 = FileUtilKt.inputStream(this.zipFile);
        int n = 8192;
        this.stream = new ZipInputStream(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
    }

    @Override
    @Nullable
    public Decompressor.Entry nextEntry() {
        ZipInputStream zipInputStream = this.stream;
        if (zipInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException("stream");
        }
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            return null;
        }
        ZipEntry nextEntry = zipEntry;
        Decompressor.Type type2 = nextEntry.isDirectory() ? Decompressor.Type.DIR : Decompressor.Type.FILE;
        String string2 = nextEntry.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "nextEntry.name");
        return new Decompressor.Entry(string2, type2);
    }

    @Override
    public void closeNextEntryStream(@NotNull InputStream entryStream) {
        Intrinsics.checkNotNullParameter(entryStream, "entryStream");
    }

    @Override
    @Nullable
    public InputStream nextEntryStream() {
        ZipInputStream zipInputStream = this.stream;
        if (zipInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException("stream");
        }
        return zipInputStream;
    }

    @Override
    public void closeStream() {
        ZipInputStream zipInputStream = this.stream;
        if (zipInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException("stream");
        }
        zipInputStream.close();
    }

    public ZipDecompressor(@NotNull Path zipFile, @Nullable Long sizeLimit) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        super(sizeLimit, null);
        this.zipFile = zipFile;
    }
}

