/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class RefCountingRecordsTable
extends AbstractRecordsTable {
    private static final int VERSION = 1;
    private static final int REF_COUNT_OFFSET = 16;
    private static final int RECORD_SIZE = 20;
    private static final byte[] ZEROES = new byte[20];

    RefCountingRecordsTable(@NotNull Path recordsFile, PagePool pool) throws IOException {
        if (recordsFile == null) {
            RefCountingRecordsTable.$$$reportNull$$$0(0);
        }
        super(recordsFile, pool);
    }

    @Override
    protected int getImplVersion() {
        return 1;
    }

    @Override
    protected int getRecordSize() {
        return 20;
    }

    @Override
    protected byte[] getZeros() {
        return ZEROES;
    }

    public void incRefCount(int record) {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        this.myStorage.putInt(offset, this.myStorage.getInt(offset) + 1);
    }

    public boolean decRefCount(int record) {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        int count2 = this.myStorage.getInt(offset);
        assert (count2 > 0);
        this.myStorage.putInt(offset, --count2);
        return count2 == 0;
    }

    public int getRefCount(int record) {
        return this.myStorage.getInt(this.getOffset(record, 16));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordsFile", "com/intellij/util/io/storage/RefCountingRecordsTable", "<init>"));
    }
}

