/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public final class TrigramBuilder {
    private TrigramBuilder() {
    }

    public static boolean processTrigrams(@NotNull CharSequence text, @NotNull TrigramProcessor consumer) {
        if (text == null) {
            TrigramBuilder.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TrigramBuilder.$$$reportNull$$$0(1);
        }
        AddonlyIntSet set = new AddonlyIntSet();
        int index = 0;
        char[] fileTextArray = CharArrayUtil.fromSequenceWithoutCopying(text);
        while (index != text.length()) {
            char c;
            char c2 = c = fileTextArray != null ? fileTextArray[index] : text.charAt(index);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c))) {
                ++index;
                continue;
            }
            int identifierStart = index;
            while (++index != text.length()) {
                char c3;
                char c4 = c3 = fileTextArray != null ? fileTextArray[index] : text.charAt(index);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3)) continue;
                break;
            }
            int tc1 = 0;
            int tc2 = 0;
            int i = identifierStart;
            int iters = 0;
            while (i < index) {
                char c5 = StringUtil.toLowerCase(fileTextArray != null ? fileTextArray[i] : text.charAt(i));
                int tc3 = (tc2 << 8) + c5;
                tc2 = (tc1 << 8) + c5;
                tc1 = c5;
                if (iters >= 2) {
                    set.add(tc3);
                }
                ++i;
                ++iters;
            }
        }
        return consumer.consumeTrigramsCount(set.size()) && set.forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/util/text/TrigramBuilder";
        objectArray[2] = "processTrigrams";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddonlyIntSet {
        private int size;
        private int[] data;
        private int shift;
        private int mask;
        private boolean hasZeroKey;

        AddonlyIntSet() {
            this(21);
        }

        AddonlyIntSet(int expectedSize) {
            int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
            this.shift = Integer.numberOfLeadingZeros(powerOfTwo) + 1;
            this.mask = powerOfTwo - 1;
            this.data = new int[powerOfTwo];
        }

        public int size() {
            return this.size;
        }

        private int hash(int h2, int[] a) {
            h2 ^= h2 >>> 20 ^ h2 >>> 12;
            return (h2 ^ h2 >>> 7 ^ h2 >>> 4) & this.mask;
        }

        public void add(int key) {
            if (key == 0) {
                if (!this.hasZeroKey) {
                    ++this.size;
                }
                this.hasZeroKey = true;
                return;
            }
            if (this.size >= 2 * this.data.length / 3) {
                this.rehash();
            }
            if (this.doPut(this.data, key)) {
                ++this.size;
            }
        }

        private boolean doPut(int[] a, int o) {
            int obj;
            int index = this.hash(o, a);
            while ((obj = a[index]) != 0 && obj != o) {
                if (index == 0) {
                    index = a.length;
                }
                --index;
            }
            a[index] = o;
            return obj == 0;
        }

        private void rehash() {
            --this.shift;
            int[] b = new int[this.data.length << 1];
            this.mask = b.length - 1;
            int i = this.data.length;
            while (--i >= 0) {
                int ns = this.data[i];
                if (ns == 0) continue;
                this.doPut(b, ns);
            }
            this.data = b;
        }

        public boolean contains(int key) {
            int v;
            if (key == 0) {
                return this.hasZeroKey;
            }
            int index = this.hash(key, this.data);
            while ((v = this.data[index]) != 0) {
                if (v == key) {
                    return true;
                }
                if (index == 0) {
                    index = this.data.length;
                }
                --index;
            }
            return false;
        }

        public boolean forEach(@NotNull IntPredicate consumer) {
            if (consumer == null) {
                AddonlyIntSet.$$$reportNull$$$0(0);
            }
            if (this.hasZeroKey && !consumer.test(0)) {
                return false;
            }
            for (int o : this.data) {
                if (o == 0 || consumer.test(o)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/text/TrigramBuilder$AddonlyIntSet", "forEach"));
        }
    }

    public static abstract class TrigramProcessor
    implements IntPredicate {
        public boolean consumeTrigramsCount(int count2) {
            return true;
        }
    }
}

