/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class LowMemoryWatcherManager
implements Disposable {
    private static final long MEM_THRESHOLD = 0x500000L;
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final Future<?> myMemoryPoolMXBeansFuture;
    private final Consumer<Boolean> myJanitor;
    private final NotificationListener myLowMemoryListener;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(LowMemoryWatcherManager.class);
        if (logger == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        this.myJanitor = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "com/intellij/openapi/util/LowMemoryWatcherManager$1", "accept"));
            }
        };
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if (LowMemoryWatcher.notificationsSuppressed()) {
                    return;
                }
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.accept(memoryCollectionThreshold));
                            if (LowMemoryWatcherManager.this.mySubmitted.isDone()) {
                                LowMemoryWatcherManager.this.mySubmitted = null;
                            }
                        }
                    }
                }
            }
        };
        this.myExecutorService = Boolean.getBoolean("low.memory.watcher.sync") ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.myMemoryPoolMXBeansFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        Future<?> future = backendExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                        long max;
                        long threshold;
                        if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((float)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                        bean.setUsageThreshold(threshold);
                        bean.setCollectionUsageThreshold(threshold);
                    }
                    ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.myLowMemoryListener, null, null);
                }
                catch (Throwable e) {
                    LowMemoryWatcherManager.getLogger().info("Errors initializing LowMemoryWatcher: ", e);
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(3);
        }
        return future;
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.myMemoryPoolMXBeansFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (Exception e) {
            LowMemoryWatcherManager.getLogger().error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    @TestOnly
    public void waitForInitComplete(int timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.myMemoryPoolMXBeansFuture.get(timeout2, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

