/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.FixedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FrequentEventDetector {
    private static final Logger LOG = Logger.getInstance(FrequentEventDetector.class);
    private long myStartedCounting;
    private final AtomicInteger myEventsPosted;
    private final AtomicInteger myLastTraceId;
    private final Map<String, Integer> myRecentTraces;
    private final int myEventCountThreshold;
    private final int myTimeSpanMs;
    private final Level myLevel;
    private static final AtomicInteger disableRequests = new AtomicInteger();

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs) {
        this(eventCountThreshold, timeSpanMs, Level.INFO);
    }

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs, @NotNull Level level) {
        if (level == null) {
            FrequentEventDetector.$$$reportNull$$$0(0);
        }
        this.myStartedCounting = System.currentTimeMillis();
        this.myEventsPosted = new AtomicInteger();
        this.myLastTraceId = new AtomicInteger();
        this.myRecentTraces = new FixedHashMap<String, Integer>(50);
        this.myEventCountThreshold = eventCountThreshold;
        this.myTimeSpanMs = timeSpanMs;
        this.myLevel = level;
    }

    @Nullable
    public String getMessageOnEvent(@NotNull Object event) {
        if (event == null) {
            FrequentEventDetector.$$$reportNull$$$0(1);
        }
        if (disableRequests.get() == 0 && this.myEventsPosted.incrementAndGet() > this.myEventCountThreshold && this.manyEventsHappenedInSmallTimeSpan()) {
            return this.generateMessage(event);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manyEventsHappenedInSmallTimeSpan() {
        boolean shouldLog = false;
        AtomicInteger atomicInteger = this.myEventsPosted;
        synchronized (atomicInteger) {
            if (this.myEventsPosted.get() > this.myEventCountThreshold) {
                long timeNow = System.currentTimeMillis();
                shouldLog = timeNow - this.myStartedCounting < (long)this.myTimeSpanMs;
                this.myEventsPosted.set(0);
                this.myStartedCounting = timeNow;
            }
        }
        return shouldLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @NonNls
    private String generateMessage(@NotNull Object event) {
        int traceId;
        boolean logTrace;
        if (event == null) {
            FrequentEventDetector.$$$reportNull$$$0(2);
        }
        String trace = ExceptionUtil.getThrowableText(new Throwable());
        AtomicInteger atomicInteger = this.myEventsPosted;
        synchronized (atomicInteger) {
            Integer existingTraceId = this.myRecentTraces.get(trace);
            boolean bl = logTrace = existingTraceId == null;
            if (logTrace) {
                traceId = this.myLastTraceId.incrementAndGet();
                this.myRecentTraces.put(trace, traceId);
            } else {
                traceId = existingTraceId;
            }
        }
        String string2 = "Too many events posted, #" + traceId + ". Event: " + event + (logTrace ? "\n" + trace : "");
        if (string2 == null) {
            FrequentEventDetector.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public void logMessage(@NotNull String message2) {
        if (message2 == null) {
            FrequentEventDetector.$$$reportNull$$$0(4);
        }
        if (this.myLevel == Level.INFO) {
            LOG.info(message2);
        } else if (this.myLevel == Level.WARN) {
            LOG.warn(message2);
        } else {
            LOG.error(message2);
        }
    }

    public void eventHappened(@NotNull Object event) {
        String message2;
        if (event == null) {
            FrequentEventDetector.$$$reportNull$$$0(5);
        }
        if ((message2 = this.getMessageOnEvent(event)) != null) {
            this.logMessage(message2);
        }
    }

    @TestOnly
    public static void disableUntil(@NotNull Disposable reenable) {
        if (reenable == null) {
            FrequentEventDetector.$$$reportNull$$$0(6);
        }
        disableRequests.incrementAndGet();
        Disposer.register(reenable, () -> disableRequests.decrementAndGet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/FrequentEventDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reenable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/FrequentEventDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageOnEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateMessage";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "eventHappened";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disableUntil";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

