/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.ValidationException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.impl.StreamExceptionBase;
import com.fasterxml.aalto.out.OutputElement;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.TextUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.ri.Stax2WriterImpl;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import org.codehaus.stax2.ri.typed.ValueEncoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.ValidatorPair;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationProblem;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public abstract class StreamWriterBase
extends Stax2WriterImpl
implements NamespaceContext,
ValidationContext {
    protected final WriterConfig _config;
    protected NamespaceContext _rootNsContext;
    protected boolean _cfgCheckStructure;
    protected boolean _cfgCheckContent;
    protected boolean _cfgCheckAttrs;
    protected final boolean _cfgCDataAsText;
    protected WNameTable _symbols;
    protected final XmlWriter _xmlWriter;
    protected ValueEncoderFactory _valueEncoderFactory;
    protected XMLValidator _validator = null;
    protected int _vldContent = 4;
    protected ValidationProblemHandler _vldProblemHandler = null;
    protected State _state = State.PROLOG;
    protected OutputElement _currElem = OutputElement.createRoot();
    protected boolean _stateAnyOutput = false;
    protected boolean _stateStartElementOpen = false;
    protected boolean _stateEmptyElement = false;
    protected String _dtdRootElemName = null;
    protected OutputElement _outputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    protected int _poolSize = 0;

    protected StreamWriterBase(WriterConfig cfg, XmlWriter writer, WNameTable symbols) {
        this._config = cfg;
        this._xmlWriter = writer;
        this._symbols = symbols;
        this._cfgCheckStructure = cfg.willCheckStructure();
        this._cfgCheckContent = cfg.willCheckContent();
        this._cfgCheckAttrs = cfg.willCheckAttributes();
        this._cfgCDataAsText = false;
    }

    @Override
    public void close() throws XMLStreamException {
        this._finishDocument(false);
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this._xmlWriter.flush();
        }
        catch (IOException ie) {
            throw new IoStreamException(ie);
        }
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this._config.getProperty(name, true);
    }

    @Override
    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        if (this._state != State.PROLOG) {
            StreamWriterBase.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this._rootNsContext = ctxt;
    }

    @Override
    public final void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        if (prefix.equals("xml")) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix.equals("xmlns")) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
        }
        if (uri.length() == 0 && !this._config.isXml11()) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this._setPrefix(prefix, uri);
    }

    protected abstract void _setPrefix(String var1, String var2);

    @Override
    public final void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this._writeAttribute(this._symbols.findSymbol(localName), value);
    }

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    @Override
    public void writeCData(String data2) throws XMLStreamException {
        if (this._cfgCDataAsText) {
            this.writeCharacters(data2);
            return;
        }
        this._verifyWriteCData();
        if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(data2, false);
        }
        try {
            int ix = this._xmlWriter.writeCData(data2);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text, start, len);
            return;
        }
        if (this._vldContent <= 1) {
            if (this._vldContent == 0) {
                this._reportInvalidContent(4);
            } else if (!TextUtil.isAllWhitespace(text, start, len, this._config.isXml11())) {
                this._reportInvalidContent(4);
            }
        } else if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(text, start, len, false);
        }
        if (len > 0) {
            try {
                this._xmlWriter.writeCharacters(text, start, len);
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text);
            return;
        }
        if (this._vldContent <= 1) {
            if (this._vldContent == 0) {
                this._reportInvalidContent(4);
            } else if (!TextUtil.isAllWhitespace(text, this._config.isXml11())) {
                this._reportInvalidContent(4);
            }
        } else if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(text, false);
        }
        try {
            this._xmlWriter.writeCharacters(text);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeComment(String data2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(5);
        }
        try {
            int ix = this._xmlWriter.writeComment(data2);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_COMMENT_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public final void writeDTD(String dtd) throws XMLStreamException {
        this._verifyWriteDTD();
        this._dtdRootElemName = "";
        try {
            this._xmlWriter.writeDTD(dtd);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        if (this._validator != null) {
            this._validator.validateElementStart(localName, "", "");
        }
        this._writeStartTag(name, true);
    }

    @Override
    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this._finishDocument(false);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        if (this._state != State.TREE) {
            StreamWriterBase._reportNwfStructure("No open start element, when trying to write end element");
        }
        OutputElement thisElem = this._currElem;
        this._currElem = thisElem.getParent();
        if (this._poolSize < 8) {
            thisElem.addToPool(this._outputElemPool);
            this._outputElemPool = thisElem;
            ++this._poolSize;
        }
        if (this._cfgCheckStructure) {
            // empty if block
        }
        try {
            if (this._stateStartElementOpen) {
                this._stateStartElementOpen = false;
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeEndTag(thisElem.getName());
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (this._currElem.isRoot()) {
            this._state = State.EPILOG;
        }
        if (this._validator != null) {
            this._vldContent = this._validator.validateElementEnd(thisElem.getLocalName(), thisElem.getNonNullPrefix(), thisElem.getNonNullNamespaceURI());
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._cfgCheckStructure && this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_ENTITY);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(9);
        }
        try {
            this._xmlWriter.writeEntityReference(this._symbols.findSymbol(name));
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(3);
        }
        try {
            int ix = this._xmlWriter.writePI(this._symbols.findSymbol(target), data2);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_PI_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        String enc = this._config.getActualEncoding();
        if (enc == null) {
            enc = "UTF-8";
            this._config.setActualEncodingIfNotSet(enc);
        }
        this._writeStartDocument("1.0", enc, null);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this._writeStartDocument(version, this._config.getActualEncoding(), null);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this._writeStartDocument(version, encoding, null);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        if (this._validator != null) {
            this._validator.validateElementStart(localName, "", "");
        }
        this._writeStartTag(name, false);
    }

    @Override
    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public String getNamespaceURI(String prefix) {
        String uri = this._currElem.getNamespaceURI(prefix);
        if (uri == null && this._rootNsContext != null) {
            uri = this._rootNsContext.getNamespaceURI(prefix);
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) {
        String prefix = this._currElem.getPrefix(uri);
        if (prefix == null && this._rootNsContext != null) {
            prefix = this._rootNsContext.getPrefix(uri);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return this._currElem.getPrefixes(uri, this._rootNsContext);
    }

    @Override
    public void writeBoolean(boolean b) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(b ? "true" : "false"));
    }

    @Override
    public void writeInt(int value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public void writeLong(long value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public void writeFloat(float value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public void writeDouble(double value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public void writeInteger(BigInteger value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(value.toString()));
    }

    @Override
    public void writeDecimal(BigDecimal value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(value.toString()));
    }

    @Override
    public void writeQName(QName value) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(this._serializeQName(value)));
    }

    @Override
    public final void writeIntArray(int[] value, int from, int length) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value, from, length));
    }

    @Override
    public void writeLongArray(long[] value, int from, int length) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value, from, length));
    }

    @Override
    public void writeFloatArray(float[] value, int from, int length) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value, from, length));
    }

    @Override
    public void writeDoubleArray(double[] value, int from, int length) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(value, from, length));
    }

    @Override
    public void writeBinary(byte[] value, int from, int length) throws XMLStreamException {
        Base64Variant v = Base64Variants.getDefaultVariant();
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(v, value, from, length));
    }

    @Override
    public void writeBinary(Base64Variant v, byte[] value, int from, int length) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(v, value, from, length));
    }

    private final void writeTypedElement(AsciiValueEncoder enc) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeTypedValue(enc);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public final void writeBooleanAttribute(String prefix, String nsURI, String localName, boolean value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public final void writeIntAttribute(String prefix, String nsURI, String localName, int value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public final void writeLongAttribute(String prefix, String nsURI, String localName, long value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public final void writeFloatAttribute(String prefix, String nsURI, String localName, float value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public final void writeDoubleAttribute(String prefix, String nsURI, String localName, double value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value));
    }

    @Override
    public final void writeIntegerAttribute(String prefix, String nsURI, String localName, BigInteger value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getScalarEncoder(value.toString()));
    }

    @Override
    public final void writeDecimalAttribute(String prefix, String nsURI, String localName, BigDecimal value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getScalarEncoder(value.toString()));
    }

    @Override
    public final void writeQNameAttribute(String prefix, String nsURI, String localName, QName value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this._serializeQName(value));
    }

    @Override
    public void writeIntArrayAttribute(String prefix, String nsURI, String localName, int[] value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value, 0, value.length));
    }

    @Override
    public void writeLongArrayAttribute(String prefix, String nsURI, String localName, long[] value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value, 0, value.length));
    }

    @Override
    public void writeFloatArrayAttribute(String prefix, String nsURI, String localName, float[] value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value, 0, value.length));
    }

    @Override
    public void writeDoubleArrayAttribute(String prefix, String nsURI, String localName, double[] value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(value, 0, value.length));
    }

    @Override
    public void writeBinaryAttribute(String prefix, String nsURI, String localName, byte[] value) throws XMLStreamException {
        Base64Variant v = Base64Variants.getDefaultVariant();
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(v, value, 0, value.length));
    }

    @Override
    public void writeBinaryAttribute(Base64Variant v, String prefix, String nsURI, String localName, byte[] value) throws XMLStreamException {
        this.writeTypedAttribute(prefix, nsURI, localName, this.valueEncoderFactory().getEncoder(v, value, 0, value.length));
    }

    public abstract void writeTypedAttribute(String var1, String var2, String var3, AsciiValueEncoder var4) throws XMLStreamException;

    protected abstract String _serializeQName(QName var1) throws XMLStreamException;

    @Override
    public void writeSpace(String text) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(text);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeSpace(char[] cbuf, int offset, int len) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(cbuf, offset, len);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void closeCompletely() throws XMLStreamException {
        this._finishDocument(true);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this._config.isPropertySupported(name);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        return this._config.setProperty(name, value);
    }

    @Override
    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        XMLValidator vld = schema.createValidator(this);
        if (this._validator == null) {
            this._cfgCheckStructure = true;
            this._cfgCheckAttrs = true;
            this._validator = vld;
        } else {
            this._validator = new ValidatorPair(this._validator, vld);
        }
        return vld;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        XMLValidator[] results = new XMLValidator[2];
        XMLValidator found = null;
        if (ValidatorPair.removeValidator(this._validator, schema, results)) {
            found = results[0];
            this._validator = results[1];
            found.validationCompleted(false);
            if (this._validator == null) {
                this.resetValidationFlags();
            }
        }
        return found;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        XMLValidator[] results = new XMLValidator[2];
        XMLValidator found = null;
        if (ValidatorPair.removeValidator(this._validator, validator, results)) {
            found = results[0];
            this._validator = results[1];
            found.validationCompleted(false);
            if (this._validator == null) {
                this.resetValidationFlags();
            }
        }
        return found;
    }

    @Override
    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h2) {
        ValidationProblemHandler oldH = this._vldProblemHandler;
        this._vldProblemHandler = h2;
        return oldH;
    }

    private void resetValidationFlags() {
        this._cfgCheckStructure = this._config.willCheckStructure();
        this._cfgCheckAttrs = this._config.willCheckAttributes();
    }

    @Override
    public XMLStreamLocation2 getLocation() {
        return new LocationImpl(null, null, this._xmlWriter.getAbsOffset(), this._xmlWriter.getRow(), this._xmlWriter.getColumn());
    }

    @Override
    public String getEncoding() {
        return this._config.getActualEncoding();
    }

    @Override
    public void writeCData(char[] cbuf, int start, int len) throws XMLStreamException {
        int ix;
        if (this._cfgCDataAsText) {
            this.writeCharacters(cbuf, start, len);
            return;
        }
        this._verifyWriteCData();
        try {
            ix = this._xmlWriter.writeCData(cbuf, start, len);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (ix >= 0) {
            StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, ix);
        }
    }

    public void writeDTD(DTDInfo info) throws XMLStreamException {
        this.writeDTD(info.getDTDRootName(), info.getDTDSystemId(), info.getDTDPublicId(), info.getDTDInternalSubset());
    }

    @Override
    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        this._verifyWriteDTD();
        this._dtdRootElemName = rootName;
        try {
            this._xmlWriter.writeDTD(this._symbols.findSymbol(rootName), systemId, publicId, internalSubset);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeFullEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        this.writeEndElement();
    }

    @Override
    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this._writeStartDocument(version, encoding, standAlone ? "yes" : "no");
    }

    @Override
    public void writeRaw(String text) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, 0, text.length());
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeRaw(String text, int start, int offset) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, start, offset);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(text, offset, length);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    public String getXmlVersion() {
        return this._config.isXml11() ? "1.1" : "1.0";
    }

    @Override
    public QName getCurrentElementName() {
        return this._currElem.getQName();
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public Location getValidationLocation() {
        return this.getLocation();
    }

    @Override
    public void reportProblem(XMLValidationProblem prob) throws XMLStreamException {
        if (this._vldProblemHandler != null) {
            this._vldProblemHandler.reportProblem(prob);
            return;
        }
        if (prob.getSeverity() >= 2) {
            throw ValidationException.create(prob);
        }
    }

    @Override
    public int addDefaultAttribute(String localName, String uri, String prefix, String value) {
        return -1;
    }

    @Override
    public boolean isNotationDeclared(String name) {
        return false;
    }

    @Override
    public boolean isUnparsedEntityDeclared(String name) {
        return false;
    }

    @Override
    public int getAttributeCount() {
        return 0;
    }

    @Override
    public String getAttributeLocalName(int index) {
        return null;
    }

    @Override
    public String getAttributeNamespace(int index) {
        return null;
    }

    @Override
    public String getAttributePrefix(int index) {
        return null;
    }

    @Override
    public String getAttributeValue(int index) {
        return null;
    }

    @Override
    public String getAttributeValue(String nsURI, String localName) {
        return null;
    }

    @Override
    public String getAttributeType(int index) {
        return "";
    }

    @Override
    public int findAttributeIndex(String nsURI, String localName) {
        return -1;
    }

    protected void _closeStartElement(boolean emptyElem) throws XMLStreamException {
        this._stateStartElementOpen = false;
        try {
            if (emptyElem) {
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeStartTagEnd();
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (emptyElem) {
            OutputElement thisElem = this._currElem;
            this._currElem = thisElem.getParent();
            if (this._currElem.isRoot()) {
                this._state = State.EPILOG;
            }
            if (this._poolSize < 8) {
                thisElem.addToPool(this._outputElemPool);
                this._outputElemPool = thisElem;
                ++this._poolSize;
            }
        }
    }

    protected final boolean inPrologOrEpilog() {
        return this._state != State.TREE;
    }

    protected final ValueEncoderFactory valueEncoderFactory() {
        if (this._valueEncoderFactory == null) {
            this._valueEncoderFactory = new ValueEncoderFactory();
        }
        return this._valueEncoderFactory;
    }

    protected final void _writeAttribute(WName name, String value) throws XMLStreamException {
        if (this._cfgCheckAttrs) {
            this._verifyWriteAttr(name);
        }
        try {
            this._xmlWriter.writeAttribute(name, value);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final void _writeAttribute(WName name, AsciiValueEncoder enc) throws XMLStreamException {
        if (this._cfgCheckAttrs) {
            this._verifyWriteAttr(name);
        }
        try {
            this._xmlWriter.writeAttribute(name, enc);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final void _writeDefaultNamespace(String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns");
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final void _writeNamespace(String prefix, String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns", prefix);
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected void _writeStartDocument(String version, String encoding, String standAlone) throws XMLStreamException {
        if (this._cfgCheckStructure && this._stateAnyOutput) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_DUP_XML_DECL);
        }
        this._stateAnyOutput = true;
        if (this._cfgCheckContent && version != null && version.length() > 0 && !version.equals("1.0") && !version.equals("1.1")) {
            StreamWriterBase._reportNwfContent("Illegal version argument ('" + version + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        if ("1.1".equals(version)) {
            this._config.enableXml11();
            this._xmlWriter.enableXml11();
        }
        if (encoding != null && encoding.length() > 0) {
            this._config.setActualEncodingIfNotSet(encoding);
        }
        try {
            this._xmlWriter.writeXmlDeclaration(version, encoding, standAlone);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected void _writeStartTag(WName name, boolean isEmpty) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    protected void _writeStartTag(WName name, boolean isEmpty, String uri) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (uri == null) {
            uri = "";
        }
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name, uri);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name, uri);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    protected final void _verifyWriteAttr(WName name) {
    }

    protected void _verifyStartElement(String prefix, String localName) throws XMLStreamException {
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        } else if (this._state == State.PROLOG) {
            this._verifyRootElement(prefix, localName);
        } else if (this._state == State.EPILOG) {
            if (this._cfgCheckStructure) {
                String name = prefix == null ? localName : prefix + ":" + localName;
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, name);
            }
            this._state = State.TREE;
        }
    }

    protected final void _verifyWriteCData() throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._cfgCheckStructure && this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
        }
    }

    protected final void _verifyWriteDTD() throws XMLStreamException {
        if (this._cfgCheckStructure) {
            if (this._state != State.PROLOG) {
                throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + (Object)((Object)this._state) + "; start element(s) written)");
            }
            if (this._dtdRootElemName != null) {
                throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
            }
        }
    }

    protected void _verifyRootElement(String prefix, String localName) throws XMLValidationException {
        this._state = State.TREE;
    }

    protected static void throwOutputError(String msg) throws XMLStreamException {
        throw new StreamExceptionBase(msg);
    }

    protected static void throwOutputError(String format2, Object arg2) throws XMLStreamException {
        String msg = MessageFormat.format(format2, arg2);
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void reportIllegalMethod(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfStructure(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfStructure(String msg, Object arg2) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg2);
    }

    protected static void _reportNwfContent(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfContent(String msg, Object arg2) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg2);
    }

    protected static void _reportNwfAttr(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void _reportNwfAttr(String msg, Object arg2) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg2);
    }

    protected static void _reportNwfName(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    protected static void throwFromIOE(IOException ioe) throws XMLStreamException {
        throw new IoStreamException(ioe);
    }

    protected static void reportIllegalArg(String msg) throws IllegalArgumentException {
        throw new IllegalArgumentException(msg);
    }

    protected void _reportInvalidContent(int evtType) throws XMLStreamException {
        switch (this._vldContent) {
            case 0: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_EMPTY, this._currElem.getNameDesc(), ErrorConsts.tokenTypeDesc(evtType)));
                break;
            }
            case 1: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_NON_MIXED, this._currElem.getNameDesc()));
                break;
            }
            case 3: 
            case 4: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_ANY, this._currElem.getNameDesc(), ErrorConsts.tokenTypeDesc(evtType)));
                break;
            }
            default: {
                this._reportValidationProblem("Internal error: trying to report invalid content for " + evtType);
            }
        }
    }

    public void _reportValidationProblem(String msg) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg, 2));
    }

    private final void _finishDocument(boolean forceRealClose) throws XMLStreamException {
        if (this._state != State.EPILOG) {
            if (this._cfgCheckStructure && this._state == State.PROLOG) {
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_NO_ROOT);
            }
            if (this._stateStartElementOpen) {
                this._closeStartElement(this._stateEmptyElement);
            }
            while (this._state != State.EPILOG) {
                this.writeEndElement();
            }
        }
        if (this._symbols.maybeDirty()) {
            this._symbols.mergeToParent();
        }
        try {
            this._xmlWriter.close(forceRealClose);
        }
        catch (IOException ie) {
            throw new IoStreamException(ie);
        }
    }

    public String toString() {
        return "[StreamWriter: " + this.getClass() + ", underlying outputter: " + (this._xmlWriter == null ? "NULL" : this._xmlWriter.toString());
    }

    protected static enum State {
        PROLOG,
        TREE,
        EPILOG;

    }
}

