/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Perl5Pattern;

public final class Perl5Debug {
    private Perl5Debug() {
    }

    public static String printProgram(Perl5Pattern perl5Pattern) {
        int n = 27;
        char[] cArray = perl5Pattern._program;
        int n2 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 0) {
            n = cArray[n2];
            stringBuffer.append(n2);
            Perl5Debug._printOperator(cArray, n2, stringBuffer);
            int n3 = OpCode._getNext(cArray, n2);
            n2 += OpCode._operandLength[n];
            stringBuffer.append("(" + n3 + ")");
            n2 += 2;
            if (n == 9) {
                n2 += 16;
            } else if (n == 35 || n == 36) {
                while (cArray[n2] != '\u0000') {
                    if (cArray[n2] == '%') {
                        n2 += 3;
                        continue;
                    }
                    n2 += 2;
                }
                ++n2;
            } else if (n == 14) {
                ++n2;
                stringBuffer.append(" <");
                while (cArray[n2] != '\uffff') {
                    stringBuffer.append(cArray[n2]);
                    ++n2;
                }
                stringBuffer.append(">");
                ++n2;
            }
            stringBuffer.append('\n');
        }
        if (perl5Pattern._startString != null) {
            stringBuffer.append("start `" + new String(perl5Pattern._startString) + "' ");
        }
        if (perl5Pattern._startClassOffset != -1) {
            stringBuffer.append("stclass `");
            Perl5Debug._printOperator(cArray, perl5Pattern._startClassOffset, stringBuffer);
            stringBuffer.append("' ");
        }
        if ((perl5Pattern._anchor & 3) != 0) {
            stringBuffer.append("anchored ");
        }
        if ((perl5Pattern._anchor & 4) != 0) {
            stringBuffer.append("plus ");
        }
        if ((perl5Pattern._anchor & 8) != 0) {
            stringBuffer.append("implicit ");
        }
        if (perl5Pattern._mustString != null) {
            stringBuffer.append("must have \"" + new String(perl5Pattern._mustString) + "\" back " + perl5Pattern._back + " ");
        }
        stringBuffer.append("minlen " + perl5Pattern._minLength + '\n');
        return stringBuffer.toString();
    }

    static void _printOperator(char[] cArray, int n, StringBuffer stringBuffer) {
        String string2 = null;
        stringBuffer.append(":");
        switch (cArray[n]) {
            case '\u0001': {
                string2 = "BOL";
                break;
            }
            case '\u0002': {
                string2 = "MBOL";
                break;
            }
            case '\u0003': {
                string2 = "SBOL";
                break;
            }
            case '\u0004': {
                string2 = "EOL";
                break;
            }
            case '\u0005': {
                string2 = "MEOL";
                break;
            }
            case '\u0007': {
                string2 = "ANY";
                break;
            }
            case '\b': {
                string2 = "SANY";
                break;
            }
            case '\t': {
                string2 = "ANYOF";
                break;
            }
            case '#': {
                string2 = "ANYOFUN";
                break;
            }
            case '$': {
                string2 = "NANYOFUN";
                break;
            }
            case '\f': {
                string2 = "BRANCH";
                break;
            }
            case '\u000e': {
                string2 = "EXACTLY";
                break;
            }
            case '\u000f': {
                string2 = "NOTHING";
                break;
            }
            case '\r': {
                string2 = "BACK";
                break;
            }
            case '\u0000': {
                string2 = "END";
                break;
            }
            case '\u0012': {
                string2 = "ALNUM";
                break;
            }
            case '\u0013': {
                string2 = "NALNUM";
                break;
            }
            case '\u0014': {
                string2 = "BOUND";
                break;
            }
            case '\u0015': {
                string2 = "NBOUND";
                break;
            }
            case '\u0016': {
                string2 = "SPACE";
                break;
            }
            case '\u0017': {
                string2 = "NSPACE";
                break;
            }
            case '\u0018': {
                string2 = "DIGIT";
                break;
            }
            case '\u0019': {
                string2 = "NDIGIT";
                break;
            }
            case '&': {
                string2 = "ALPHA";
                break;
            }
            case '\'': {
                string2 = "BLANK";
                break;
            }
            case '(': {
                string2 = "CNTRL";
                break;
            }
            case ')': {
                string2 = "GRAPH";
                break;
            }
            case '*': {
                string2 = "LOWER";
                break;
            }
            case '+': {
                string2 = "PRINT";
                break;
            }
            case ',': {
                string2 = "PUNCT";
                break;
            }
            case '-': {
                string2 = "UPPER";
                break;
            }
            case '.': {
                string2 = "XDIGIT";
                break;
            }
            case '2': {
                string2 = "ALNUMC";
                break;
            }
            case '3': {
                string2 = "ASCII";
                break;
            }
            case '\n': {
                stringBuffer.append("CURLY {");
                stringBuffer.append((int)OpCode._getArg1(cArray, n));
                stringBuffer.append(',');
                stringBuffer.append((int)OpCode._getArg2(cArray, n));
                stringBuffer.append('}');
                break;
            }
            case '\u000b': {
                stringBuffer.append("CURLYX {");
                stringBuffer.append((int)OpCode._getArg1(cArray, n));
                stringBuffer.append(',');
                stringBuffer.append((int)OpCode._getArg2(cArray, n));
                stringBuffer.append('}');
                break;
            }
            case '\u001a': {
                stringBuffer.append("REF");
                stringBuffer.append((int)OpCode._getArg1(cArray, n));
                break;
            }
            case '\u001b': {
                stringBuffer.append("OPEN");
                stringBuffer.append((int)OpCode._getArg1(cArray, n));
                break;
            }
            case '\u001c': {
                stringBuffer.append("CLOSE");
                stringBuffer.append((int)OpCode._getArg1(cArray, n));
                break;
            }
            case '\u0010': {
                string2 = "STAR";
                break;
            }
            case '\u0011': {
                string2 = "PLUS";
                break;
            }
            case '\u001d': {
                string2 = "MINMOD";
                break;
            }
            case '\u001e': {
                string2 = "GBOL";
                break;
            }
            case ' ': {
                string2 = "UNLESSM";
                break;
            }
            case '\u001f': {
                string2 = "IFMATCH";
                break;
            }
            case '!': {
                string2 = "SUCCEED";
                break;
            }
            case '\"': {
                string2 = "WHILEM";
                break;
            }
            default: {
                stringBuffer.append("Operator is unrecognized.  Faulty expression code!");
            }
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
    }
}

