/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.schemagen;

import com.sun.xml.bind.v2.schemagen.GroupKind;
import com.sun.xml.bind.v2.schemagen.xmlschema.ContentModelContainer;
import com.sun.xml.bind.v2.schemagen.xmlschema.Occurs;
import com.sun.xml.bind.v2.schemagen.xmlschema.Particle;
import com.sun.xml.bind.v2.schemagen.xmlschema.TypeDefParticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class Tree {
    Tree() {
    }

    Tree makeOptional(boolean really) {
        return really ? new Optional(this) : this;
    }

    Tree makeRepeated(boolean really) {
        return really ? new Repeated(this) : this;
    }

    static Tree makeGroup(GroupKind kind, List<Tree> children2) {
        if (children2.size() == 1) {
            return children2.get(0);
        }
        ArrayList<Tree> normalizedChildren = new ArrayList<Tree>(children2.size());
        for (Tree t2 : children2) {
            Group g2;
            if (t2 instanceof Group && (g2 = (Group)t2).kind == kind) {
                normalizedChildren.addAll(Arrays.asList(g2.children));
                continue;
            }
            normalizedChildren.add(t2);
        }
        return new Group(kind, normalizedChildren.toArray(new Tree[normalizedChildren.size()]));
    }

    abstract boolean isNullable();

    boolean canBeTopLevel() {
        return false;
    }

    protected abstract void write(ContentModelContainer var1, boolean var2, boolean var3);

    protected void write(TypeDefParticle ct) {
        if (this.canBeTopLevel()) {
            this.write(ct._cast(ContentModelContainer.class), false, false);
        } else {
            new Group(GroupKind.SEQUENCE, new Tree[]{this}).write(ct);
        }
    }

    protected final void writeOccurs(Occurs o, boolean isOptional, boolean repeated) {
        if (isOptional) {
            o.minOccurs(0);
        }
        if (repeated) {
            o.maxOccurs("unbounded");
        }
    }

    private static final class Group
    extends Tree {
        private final GroupKind kind;
        private final Tree[] children;

        private Group(GroupKind kind, Tree ... children2) {
            this.kind = kind;
            this.children = children2;
        }

        @Override
        boolean canBeTopLevel() {
            return true;
        }

        @Override
        boolean isNullable() {
            if (this.kind == GroupKind.CHOICE) {
                for (Tree t2 : this.children) {
                    if (!t2.isNullable()) continue;
                    return true;
                }
                return false;
            }
            for (Tree t3 : this.children) {
                if (t3.isNullable()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
            Particle c = this.kind.write(parent);
            this.writeOccurs(c, isOptional, repeated);
            for (Tree child : this.children) {
                child.write(c, false, false);
            }
        }
    }

    private static final class Repeated
    extends Tree {
        private final Tree body;

        private Repeated(Tree body) {
            this.body = body;
        }

        @Override
        boolean isNullable() {
            return this.body.isNullable();
        }

        @Override
        Tree makeRepeated(boolean really) {
            return this;
        }

        @Override
        protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
            this.body.write(parent, isOptional, true);
        }
    }

    private static final class Optional
    extends Tree {
        private final Tree body;

        private Optional(Tree body) {
            this.body = body;
        }

        @Override
        boolean isNullable() {
            return true;
        }

        @Override
        Tree makeOptional(boolean really) {
            return this;
        }

        @Override
        protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
            this.body.write(parent, true, repeated);
        }
    }

    static abstract class Term
    extends Tree {
        Term() {
        }

        @Override
        boolean isNullable() {
            return false;
        }
    }
}

