/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.AbstractMethodInvocationProblem;
import com.jetbrains.pluginverifier.results.problems.InvokeClassMethodOnInterfaceProblem;
import com.jetbrains.pluginverifier.results.problems.InvokeInterfaceMethodOnClassProblem;
import com.jetbrains.pluginverifier.results.problems.MultipleDefaultImplementationsProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.verifiers.InheritanceUtilKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolutionResult;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J$\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodResolveImpl;", "", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;)V", "methodDescriptor", "", "methodName", "getMaximallySpecificSuperInterfaceMethods", "", "start", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "getSuperInterfaceMethods", "predicate", "Lkotlin/Function1;", "", "isSignaturePolymorphic", "methodNode", "lookupSpecialMethod", "Lkotlin/Pair;", "", "classRef", "resolvedMethod", "resolveClassMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodResolutionResult;", "classFile", "resolveClassMethodStep2", "currentClass", "resolveClassMethodStep3", "resolveInterfaceMethod", "interfaceFile", "resolveMethod", "ownerClass", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nMethodResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodResolver.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodResolveImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,489:1\n179#2,2:490\n179#2,2:492\n543#2,2:511\n179#2,2:515\n1250#2,3:517\n661#3,11:494\n766#3:505\n857#3:506\n2624#3,3:507\n858#3:510\n1855#3,2:513\n661#3,11:521\n766#3:532\n857#3,2:533\n1#4:520\n*S KotlinDebug\n*F\n+ 1 MethodResolver.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodResolveImpl\n*L\n160#1:490,2\n172#1:492,2\n238#1:511,2\n340#1:515,2\n341#1:517,3\n184#1:494,11\n218#1:505\n218#1:506\n219#1:507,3\n218#1:510\n240#1:513,2\n381#1:521,11\n456#1:532\n456#1:533,2\n*E\n"})
final class MethodResolveImpl {
    @NotNull
    private final MethodReference methodReference;
    @NotNull
    private final Instruction instruction;
    @NotNull
    private final Method callerMethod;
    @NotNull
    private final VerificationContext context;
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDescriptor;

    public MethodResolveImpl(@NotNull MethodReference methodReference, @NotNull Instruction instruction, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        this.methodReference = methodReference;
        this.instruction = instruction;
        this.callerMethod = callerMethod;
        this.context = context;
        this.methodName = this.methodReference.getMethodName();
        this.methodDescriptor = this.methodReference.getMethodDescriptor();
    }

    @NotNull
    public final MethodResolutionResult resolveMethod(@NotNull ClassFile ownerClass) {
        MethodResolutionResult methodResolutionResult;
        Intrinsics.checkNotNullParameter(ownerClass, "ownerClass");
        switch (WhenMappings.$EnumSwitchMapping$0[this.instruction.ordinal()]) {
            case 1: {
                methodResolutionResult = this.resolveClassMethod(ownerClass);
                break;
            }
            case 2: {
                methodResolutionResult = this.resolveInterfaceMethod(ownerClass);
                break;
            }
            case 3: {
                methodResolutionResult = this.resolveClassMethod(ownerClass);
                break;
            }
            case 4: {
                if (ownerClass.isInterface()) {
                    methodResolutionResult = this.resolveInterfaceMethod(ownerClass);
                    break;
                }
                methodResolutionResult = this.resolveClassMethod(ownerClass);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return methodResolutionResult;
    }

    private final MethodResolutionResult resolveInterfaceMethod(ClassFile interfaceFile) {
        Object v4;
        block14: {
            Object v2;
            block13: {
                Method method;
                Object it;
                block12: {
                    if (!interfaceFile.isInterface()) {
                        this.context.getProblemRegistrar().registerProblem(new InvokeInterfaceMethodOnClassProblem(this.methodReference, this.callerMethod.getLocation(), this.instruction));
                        return MethodResolutionResult.Abort.INSTANCE;
                    }
                    Sequence<Method> $this$firstOrNull$iv = interfaceFile.getMethods();
                    boolean $i$f$firstOrNull = false;
                    Iterator<Method> iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        Method element$iv = iterator2.next();
                        it = element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getName(), this.methodName) && Intrinsics.areEqual(it.getDescriptor(), this.methodDescriptor))) continue;
                        method = element$iv;
                        break block12;
                    }
                    method = null;
                }
                Method matching = method;
                if (matching != null) {
                    return new MethodResolutionResult.Found(matching);
                }
                ClassFile classFile = ResolutionUtilKt.resolveClassChecked$default(this.context.getClassResolver(), "java/lang/Object", interfaceFile, this.context, null, 8, null);
                if (classFile == null) {
                    return MethodResolutionResult.Abort.INSTANCE;
                }
                ClassFile objectClass = classFile;
                Sequence<Method> $this$firstOrNull$iv = objectClass.getMethods();
                boolean $i$f$firstOrNull = false;
                it = $this$firstOrNull$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv = it.next();
                    Method it2 = (Method)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it2.getName(), this.methodName) && Intrinsics.areEqual(it2.getDescriptor(), this.methodDescriptor) && it2.isPublic() && !it2.isStatic())) continue;
                    v2 = element$iv;
                    break block13;
                }
                v2 = null;
            }
            Method objectMethod = v2;
            if (objectMethod != null) {
                return new MethodResolutionResult.Found(objectMethod);
            }
            List<Method> list = this.getMaximallySpecificSuperInterfaceMethods(interfaceFile);
            if (list == null) {
                return MethodResolutionResult.Abort.INSTANCE;
            }
            List<Method> maximallySpecificSuperInterfaceMethods = list;
            Iterable $this$singleOrNull$iv = maximallySpecificSuperInterfaceMethods;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), this.methodName) && Intrinsics.areEqual(it.getDescriptor(), this.methodDescriptor) && !it.isAbstract())) continue;
                if (found$iv) {
                    v4 = null;
                    break block14;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        Method single2 = v4;
        if (single2 != null) {
            return new MethodResolutionResult.Found(single2);
        }
        List<Method> list = this.getSuperInterfaceMethods(interfaceFile, (Function1<? super Method, Boolean>)new Function1<Method, Boolean>(this){
            final /* synthetic */ MethodResolveImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Method it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getName(), MethodResolveImpl.access$getMethodName$p(this.this$0)) && Intrinsics.areEqual(it.getDescriptor(), MethodResolveImpl.access$getMethodDescriptor$p(this.this$0)) && !it.isPrivate() && !it.isStatic();
            }
        });
        if (list == null) {
            return MethodResolutionResult.Abort.INSTANCE;
        }
        List<Method> matchingMethods2 = list;
        if (!((Collection)matchingMethods2).isEmpty()) {
            return new MethodResolutionResult.Found(CollectionsKt.first(matchingMethods2));
        }
        return MethodResolutionResult.NotFound.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Method> getMaximallySpecificSuperInterfaceMethods(ClassFile start) {
        void $this$filterTo$iv$iv;
        Function1 predicate2 = new Function1<Method, Boolean>(this){
            final /* synthetic */ MethodResolveImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Method it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getName(), MethodResolveImpl.access$getMethodName$p(this.this$0)) && Intrinsics.areEqual(it.getDescriptor(), MethodResolveImpl.access$getMethodDescriptor$p(this.this$0)) && !it.isPrivate() && !it.isStatic();
            }
        };
        List<Method> list = this.getSuperInterfaceMethods(start, predicate2);
        if (list == null) {
            return null;
        }
        List<Method> allMatching = list;
        Iterable $this$filter$iv = allMatching;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                Method method = (Method)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = allMatching;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Method otherMethod = (Method)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = !Intrinsics.areEqual(otherMethod.getContainingClassFile().getName(), method.getContainingClassFile().getName()) && InheritanceUtilKt.isSubclassOf(this.context.getClassResolver(), otherMethod.getContainingClassFile(), method.getContainingClassFile().getName());
                        if (!bl4) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Method> getSuperInterfaceMethods(ClassFile start, Function1<? super Method, Boolean> predicate2) {
        Queue queue = new LinkedList();
        HashSet<String> visited = new HashSet<String>();
        ArrayList result2 = new ArrayList();
        queue.add(start);
        visited.add(start.getName());
        while (!queue.isEmpty()) {
            ClassFile resolvedSuper;
            ClassFile cur = (ClassFile)queue.remove();
            Sequence<Method> $this$filterTo$iv = cur.getMethods();
            boolean $i$f$filterTo = false;
            Iterator<Method> iterator2 = $this$filterTo$iv.iterator();
            while (iterator2.hasNext()) {
                Method element$iv = iterator2.next();
                if (!predicate2.invoke(element$iv).booleanValue()) continue;
                ((Collection)result2).add(element$iv);
            }
            Iterable $this$forEach$iv = cur.getInterfaces();
            boolean $i$f$forEach = false;
            for (Method element$iv : $this$forEach$iv) {
                ClassFile resolveClass2;
                String it = (String)((Object)element$iv);
                boolean bl = false;
                if (visited.contains(it)) continue;
                Resolver resolver = this.context.getClassResolver();
                Intrinsics.checkNotNullExpressionValue(cur, "cur");
                if (ResolutionUtilKt.resolveClassChecked$default(resolver, it, cur, this.context, null, 8, null) == null) {
                    return null;
                }
                visited.add(it);
                queue.add(resolveClass2);
            }
            String superName = cur.getSuperName();
            if (superName == null || visited.contains(superName)) continue;
            Resolver resolver = this.context.getClassResolver();
            Intrinsics.checkNotNullExpressionValue(cur, "cur");
            if (ResolutionUtilKt.resolveClassChecked$default(resolver, superName, cur, this.context, null, 8, null) == null) {
                return null;
            }
            visited.add(superName);
            queue.add(resolvedSuper);
        }
        return result2;
    }

    private final MethodResolutionResult resolveClassMethod(ClassFile classFile) {
        MethodResolutionResult lookupResult3;
        if (classFile.isInterface() && this.instruction != Instruction.INVOKE_STATIC) {
            this.context.getProblemRegistrar().registerProblem(new InvokeClassMethodOnInterfaceProblem(this.methodReference, this.callerMethod.getLocation(), this.instruction));
            return MethodResolutionResult.Abort.INSTANCE;
        }
        MethodResolutionResult lookupResult2 = this.resolveClassMethodStep2(classFile);
        if (Intrinsics.areEqual(lookupResult2, MethodResolutionResult.Abort.INSTANCE)) {
            return lookupResult2;
        }
        if (lookupResult2 instanceof MethodResolutionResult.Found) {
            return lookupResult2;
        }
        if (Intrinsics.areEqual(lookupResult2, MethodResolutionResult.NotFound.INSTANCE)) {
            // empty if block
        }
        if (Intrinsics.areEqual(lookupResult3 = this.resolveClassMethodStep3(classFile), MethodResolutionResult.Abort.INSTANCE)) {
            return lookupResult3;
        }
        if (lookupResult3 instanceof MethodResolutionResult.Found) {
            return lookupResult3;
        }
        if (Intrinsics.areEqual(lookupResult3, MethodResolutionResult.NotFound.INSTANCE)) {
            // empty if block
        }
        return MethodResolutionResult.NotFound.INSTANCE;
    }

    private final boolean isSignaturePolymorphic(Method methodNode) {
        return !(!Intrinsics.areEqual("java/lang/invoke/MethodHandle", methodNode.getContainingClassFile().getName()) && !Intrinsics.areEqual("java/lang/invoke/VarHandle", methodNode.getContainingClassFile().getName()) || !Intrinsics.areEqual("([Ljava/lang/Object;)Ljava/lang/Object;", methodNode.getDescriptor()) && !Intrinsics.areEqual("([Ljava/lang/Object;)Z", methodNode.getDescriptor()) || !methodNode.isVararg() || !methodNode.isNative());
    }

    private final MethodResolutionResult resolveClassMethodStep2(ClassFile currentClass) {
        Object v1;
        block12: {
            Iterator<Method> iterator2;
            Iterator<Method> element$iv;
            Sequence<Method> methods2;
            block11: {
                Sequence<Method> $this$firstOrNull$iv = methods2 = currentClass.getMethods();
                boolean $i$f$firstOrNull = false;
                Iterator<Method> iterator3 = $this$firstOrNull$iv.iterator();
                while (iterator3.hasNext()) {
                    element$iv = iterator3.next();
                    Method it = element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), this.methodName)) continue;
                    iterator2 = element$iv;
                    break block11;
                }
                iterator2 = null;
            }
            Method matchByName = (Method)((Object)iterator2);
            if (matchByName != null && this.isSignaturePolymorphic(matchByName)) {
                Sequence<Method> $this$count$iv = methods2;
                boolean $i$f$count = false;
                int count$iv = 0;
                element$iv = $this$count$iv.iterator();
                while (element$iv.hasNext()) {
                    Method element$iv2;
                    Method it = element$iv2 = element$iv.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), this.methodName) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                if (count$iv == 1) {
                    return new MethodResolutionResult.Found(matchByName);
                }
            }
            Sequence<Method> count$iv = methods2;
            element$iv = count$iv.iterator();
            while (element$iv.hasNext()) {
                Object e = element$iv.next();
                Method it = (Method)e;
                boolean bl = false;
                if (!(Intrinsics.areEqual(this.methodName, it.getName()) && Intrinsics.areEqual(this.methodDescriptor, it.getDescriptor()))) continue;
                v1 = e;
                break block12;
            }
            v1 = null;
        }
        Method matching = v1;
        if (matching != null) {
            return new MethodResolutionResult.Found(matching);
        }
        String superName = currentClass.getSuperName();
        if (superName != null) {
            ClassFile classFile = ResolutionUtilKt.resolveClassChecked$default(this.context.getClassResolver(), superName, currentClass, this.context, null, 8, null);
            if (classFile == null) {
                return MethodResolutionResult.Abort.INSTANCE;
            }
            ClassFile resolvedSuper = classFile;
            MethodResolutionResult lookupResult = this.resolveClassMethodStep2(resolvedSuper);
            if (lookupResult instanceof MethodResolutionResult.Found) {
                return lookupResult;
            }
            if (Intrinsics.areEqual(lookupResult, MethodResolutionResult.Abort.INSTANCE)) {
                return MethodResolutionResult.Abort.INSTANCE;
            }
            if (Intrinsics.areEqual(lookupResult, MethodResolutionResult.NotFound.INSTANCE)) {
                // empty if block
            }
        }
        return MethodResolutionResult.NotFound.INSTANCE;
    }

    private final MethodResolutionResult resolveClassMethodStep3(ClassFile currentClass) {
        Object v1;
        block6: {
            List<Method> list = this.getMaximallySpecificSuperInterfaceMethods(currentClass);
            if (list == null) {
                return MethodResolutionResult.Abort.INSTANCE;
            }
            List<Method> maximallySpecificSuperInterfaceMethods = list;
            Iterable $this$singleOrNull$iv = maximallySpecificSuperInterfaceMethods;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), this.methodName) && Intrinsics.areEqual(it.getDescriptor(), this.methodDescriptor) && !it.isAbstract())) continue;
                if (found$iv) {
                    v1 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Method single2 = v1;
        if (single2 != null) {
            return new MethodResolutionResult.Found(single2);
        }
        List<Method> list = this.getSuperInterfaceMethods(currentClass, (Function1<? super Method, Boolean>)new Function1<Method, Boolean>(this){
            final /* synthetic */ MethodResolveImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Method it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getName(), MethodResolveImpl.access$getMethodName$p(this.this$0)) && Intrinsics.areEqual(it.getDescriptor(), MethodResolveImpl.access$getMethodDescriptor$p(this.this$0)) && !it.isPrivate() && !it.isStatic();
            }
        });
        if (list == null) {
            return MethodResolutionResult.Abort.INSTANCE;
        }
        List<Method> matchingMethods2 = list;
        if (!((Collection)matchingMethods2).isEmpty()) {
            return new MethodResolutionResult.Found(CollectionsKt.first(matchingMethods2));
        }
        return MethodResolutionResult.NotFound.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Integer, Method> lookupSpecialMethod(@NotNull ClassFile classRef, @NotNull Method resolvedMethod) {
        void $this$filterTo$iv$iv;
        Method match;
        Method it;
        Method method;
        Iterator<Object> it2;
        Sequence<Method> sequence;
        block16: {
            Intrinsics.checkNotNullParameter(classRef, "classRef");
            Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
            Sequence<Method> sequence2 = classRef.getMethods();
            Iterator<Method> iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                sequence = iterator2.next();
                it2 = sequence;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it2.getName(), resolvedMethod.getName()) && Intrinsics.areEqual(it2.getDescriptor(), resolvedMethod.getDescriptor()))) continue;
                method = sequence;
                break block16;
            }
            method = null;
        }
        Method matching = method;
        if (matching != null) {
            return TuplesKt.to(1, matching);
        }
        if (!classRef.isInterface() && classRef.getSuperName() != null) {
            Resolver resolver = this.context.getClassResolver();
            String string2 = classRef.getSuperName();
            Intrinsics.checkNotNull(string2);
            ClassFile classFile = ResolutionUtilKt.resolveClassChecked$default(resolver, string2, classRef, this.context, null, 8, null);
            if (classFile == null) {
                return null;
            }
            ClassFile current = classFile;
            while (true) {
                Object object;
                block17: {
                    sequence = current.getMethods();
                    it2 = sequence.iterator();
                    while (it2.hasNext()) {
                        Object bl = it2.next();
                        it = (Method)bl;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it.getName(), resolvedMethod.getName()) && Intrinsics.areEqual(it.getDescriptor(), resolvedMethod.getDescriptor()))) continue;
                        object = bl;
                        break block17;
                    }
                    object = null;
                }
                match = (Method)object;
                if (match != null) {
                    return TuplesKt.to(2, match);
                }
                String superName = current.getSuperName();
                if (superName == null) break;
                if (ResolutionUtilKt.resolveClassChecked$default(this.context.getClassResolver(), superName, current, this.context, null, 8, null) != null) continue;
                return null;
            }
        }
        if (classRef.isInterface()) {
            Object object;
            block18: {
                ClassFile classFile = ResolutionUtilKt.resolveClassChecked$default(this.context.getClassResolver(), "java/lang/Object", classRef, this.context, null, 8, null);
                if (classFile == null) {
                    return null;
                }
                ClassFile objectClass = classFile;
                sequence = objectClass.getMethods();
                it2 = sequence.iterator();
                while (it2.hasNext()) {
                    Object bl = it2.next();
                    it = (Method)bl;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(it.getName(), resolvedMethod.getName()) && Intrinsics.areEqual(it.getDescriptor(), resolvedMethod.getDescriptor()) && it.isPublic())) continue;
                    object = bl;
                    break block18;
                }
                object = null;
            }
            match = (Method)object;
            if (match != null) {
                return TuplesKt.to(3, match);
            }
        }
        List<Method> list = this.getMaximallySpecificSuperInterfaceMethods(classRef);
        if (list == null) {
            return null;
        }
        List<Method> interfaceMethods = list;
        Iterable $this$filter$iv = interfaceMethods;
        boolean $i$f$filter = false;
        it2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Method it3 = (Method)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(it3.getName(), resolvedMethod.getName()) && Intrinsics.areEqual(it3.getDescriptor(), resolvedMethod.getDescriptor()) && !it3.isAbstract())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.size() == 1) {
            return TuplesKt.to(4, CollectionsKt.single(filtered));
        }
        if (filtered.size() > 1) {
            MethodLocation implementation1 = ((Method)filtered.get(0)).getLocation();
            MethodLocation implementation2 = ((Method)filtered.get(1)).getLocation();
            if (implementation1.toString().compareTo(implementation2.toString()) > 0) {
                MethodLocation tmp = implementation1;
                implementation1 = implementation2;
                implementation2 = tmp;
            }
            this.context.getProblemRegistrar().registerProblem(new MultipleDefaultImplementationsProblem(this.callerMethod.getLocation(), this.methodReference, this.instruction, implementation1, implementation2));
            return null;
        }
        this.context.getProblemRegistrar().registerProblem(new AbstractMethodInvocationProblem(this.methodReference, resolvedMethod.getLocation(), this.callerMethod.getLocation(), this.instruction));
        return null;
    }

    public static final /* synthetic */ String access$getMethodName$p(MethodResolveImpl $this) {
        return $this.methodName;
    }

    public static final /* synthetic */ String access$getMethodDescriptor$p(MethodResolveImpl $this) {
        return $this.methodDescriptor;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Instruction.values().length];
            try {
                nArray[Instruction.INVOKE_VIRTUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_STATIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_SPECIAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

