/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.method;

import com.jetbrains.pluginverifier.results.problems.OverridingFinalMethodProblem;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassParentsVisitor;
import com.jetbrains.pluginverifier.verifiers.method.MethodVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/method/OverrideNonFinalVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/method/MethodVerifier;", "()V", "verify", "", "method", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-core"})
public final class OverrideNonFinalVerifier
implements MethodVerifier {
    @Override
    public void verify(@NotNull Method method, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(context, "context");
        if (method.isPrivate() || Intrinsics.areEqual(method.getName(), "<init>") || Intrinsics.areEqual(method.getName(), "<clinit>")) {
            return;
        }
        if (method.isStatic()) {
            return;
        }
        ClassParentsVisitor parentsVisitor2 = new ClassParentsVisitor(false, (Function2<? super ClassFile, ? super String, ? extends ClassFile>)new Function2<ClassFile, String, ClassFile>(context){
            final /* synthetic */ VerificationContext $context;
            {
                this.$context = $context;
                super(2);
            }

            @Nullable
            public final ClassFile invoke(@NotNull ClassFile subclassFile, @NotNull String superName) {
                Intrinsics.checkNotNullParameter(subclassFile, "subclassFile");
                Intrinsics.checkNotNullParameter(superName, "superName");
                return ResolutionUtilKt.resolveClassChecked$default(this.$context.getClassResolver(), superName, subclassFile, this.$context, null, 8, null);
            }
        });
        ClassParentsVisitor.visitClass$default(parentsVisitor2, method.getContainingClassFile(), false, new Function1<ClassFile, Boolean>(context, method){
            final /* synthetic */ VerificationContext $context;
            final /* synthetic */ Method $method;
            {
                this.$context = $context;
                this.$method = $method;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClassFile parent) {
                boolean bl;
                Method method;
                block3: {
                    Intrinsics.checkNotNullParameter(parent, "parent");
                    Sequence<Method> sequence = parent.getMethods();
                    Method method2 = this.$method;
                    Sequence<Method> sequence2 = sequence;
                    Iterator<Method> iterator2 = sequence2.iterator();
                    while (iterator2.hasNext()) {
                        Method method3;
                        Method it = method3 = iterator2.next();
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it.getName(), method2.getName()) && Intrinsics.areEqual(it.getDescriptor(), method2.getDescriptor()))) continue;
                        method = method3;
                        break block3;
                    }
                    method = null;
                }
                Method sameMethod = method;
                if (sameMethod != null && sameMethod.isFinal()) {
                    this.$context.getProblemRegistrar().registerProblem(new OverridingFinalMethodProblem(sameMethod.getLocation(), this.$method.getContainingClassFile().getLocation()));
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, null, 8, null);
    }
}

