/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.instruction;

import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.problems.AbstractMethodInvocationProblem;
import com.jetbrains.pluginverifier.results.problems.InvokeInstanceInstructionOnStaticMethodProblem;
import com.jetbrains.pluginverifier.results.problems.InvokeInterfaceOnPrivateMethodProblem;
import com.jetbrains.pluginverifier.results.problems.InvokeStaticOnInstanceMethodProblem;
import com.jetbrains.pluginverifier.results.problems.MethodNotFoundProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassHierarchyBuilder;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolver;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/instruction/MethodInvokeInstructionVerifier;", "", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "methodOwnerClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;Lorg/objectweb/asm/tree/AbstractInsnNode;)V", "processInvokeInterface", "", "processInvokeSpecial", "processInvokeStatic", "processInvokeVirtual", "registerMethodNotFoundProblem", "ownerClass", "resolveMethod", "verify", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nMethodInvokeInstructionVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodInvokeInstructionVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/instruction/MethodInvokeInstructionVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1855#2,2:191\n*S KotlinDebug\n*F\n+ 1 MethodInvokeInstructionVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/instruction/MethodInvokeInstructionVerifier\n*L\n185#1:191,2\n*E\n"})
public final class MethodInvokeInstructionVerifier {
    @NotNull
    private final Method callerMethod;
    @NotNull
    private final ClassFile methodOwnerClass;
    @NotNull
    private final MethodReference methodReference;
    @NotNull
    private final VerificationContext context;
    @NotNull
    private final Instruction instruction;
    @NotNull
    private final AbstractInsnNode instructionNode;

    public MethodInvokeInstructionVerifier(@NotNull Method callerMethod, @NotNull ClassFile methodOwnerClass, @NotNull MethodReference methodReference, @NotNull VerificationContext context, @NotNull Instruction instruction, @NotNull AbstractInsnNode instructionNode) {
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(methodOwnerClass, "methodOwnerClass");
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
        this.callerMethod = callerMethod;
        this.methodOwnerClass = methodOwnerClass;
        this.methodReference = methodReference;
        this.context = context;
        this.instruction = instruction;
        this.instructionNode = instructionNode;
    }

    public final void verify() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.instruction.ordinal()]) {
            case 1: {
                this.processInvokeVirtual();
                break;
            }
            case 2: {
                this.processInvokeSpecial();
                break;
            }
            case 3: {
                this.processInvokeInterface();
                break;
            }
            case 4: {
                this.processInvokeStatic();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private final void processInvokeVirtual() {
        Method method = this.resolveMethod();
        if (method == null) {
            return;
        }
        Method method2 = method;
        if (method2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InvokeInstanceInstructionOnStaticMethodProblem(this.methodReference, method2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processInvokeSpecial() {
        ClassFile classFile;
        Method method = this.resolveMethod();
        if (method == null) {
            return;
        }
        Method method2 = method;
        if (Intrinsics.areEqual(method2.getName(), "<init>") && !Intrinsics.areEqual(method2.getContainingClassFile().getName(), this.methodReference.getHostClass().getClassName())) {
            this.registerMethodNotFoundProblem(this.methodOwnerClass);
        }
        if (method2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InvokeInstanceInstructionOnStaticMethodProblem(this.methodReference, method2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
        if (!Intrinsics.areEqual(method2.getName(), "<init>") && !this.methodOwnerClass.isInterface() && Intrinsics.areEqual(this.methodReference.getHostClass().getClassName(), this.callerMethod.getContainingClassFile().getSuperName()) && this.callerMethod.getContainingClassFile().isSuperFlag()) {
            Resolver resolver = this.context.getClassResolver();
            String string2 = this.callerMethod.getContainingClassFile().getSuperName();
            Intrinsics.checkNotNull(string2);
            classFile = ResolutionUtilKt.resolveClassChecked$default(resolver, string2, this.callerMethod, this.context, null, 8, null);
            if (classFile == null) {
                return;
            }
        } else {
            classFile = ResolutionUtilKt.resolveClassChecked$default(this.context.getClassResolver(), this.methodReference.getHostClass().getClassName(), this.callerMethod, this.context, null, 8, null);
            if (classFile == null) {
                return;
            }
        }
        ClassFile classRef = classFile;
        Pair<Integer, Method> pair = new MethodResolver().lookupSpecialMethod(classRef, this.methodReference, this.instruction, this.callerMethod, this.context, method2);
        if (pair == null) {
            return;
        }
        Pair<Integer, Method> pair2 = pair;
        int stepNumber = ((Number)pair2.component1()).intValue();
        Method resolvedMethod = pair2.component2();
        Integer[] integerArray = new Integer[]{1, 2, 3};
        if (CollectionsKt.listOf(integerArray).contains(stepNumber) && resolvedMethod.isAbstract() && (!this.callerMethod.isSynthetic() || !this.callerMethod.isBridgeMethod())) {
            this.context.getProblemRegistrar().registerProblem(new AbstractMethodInvocationProblem(this.methodReference, resolvedMethod.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processInvokeInterface() {
        Method method = this.resolveMethod();
        if (method == null) {
            return;
        }
        Method method2 = method;
        if (method2.isPrivate() || MethodInvokeInstructionVerifier.processInvokeInterface$isTestPrivateInterfaceMethod(method2)) {
            this.context.getProblemRegistrar().registerProblem(new InvokeInterfaceOnPrivateMethodProblem(this.methodReference, method2.getLocation(), this.callerMethod.getLocation()));
        }
        if (method2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InvokeInstanceInstructionOnStaticMethodProblem(this.methodReference, method2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processInvokeStatic() {
        Method method = this.resolveMethod();
        if (method == null) {
            return;
        }
        Method method2 = method;
        if (!method2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InvokeStaticOnInstanceMethodProblem(this.methodReference, method2.getLocation(), this.callerMethod.getLocation()));
        }
    }

    private final void registerMethodNotFoundProblem(ClassFile ownerClass) {
        ClassHierarchy methodOwnerHierarchy = new ClassHierarchyBuilder(this.context).buildClassHierarchy(ownerClass);
        this.context.getProblemRegistrar().registerProblem(new MethodNotFoundProblem(this.methodReference, this.callerMethod.getLocation(), this.instruction, methodOwnerHierarchy));
    }

    private final Method resolveMethod() {
        Method method = new MethodResolver().resolveMethod(this.methodOwnerClass, this.methodReference, this.instruction, this.callerMethod, this.context);
        if (method != null) {
            Iterable $this$forEach$iv = this.context.getApiUsageProcessors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiUsageProcessor it = (ApiUsageProcessor)element$iv;
                boolean bl = false;
                it.processMethodInvocation(this.methodReference, method, this.instructionNode, this.callerMethod, this.context);
            }
        }
        return method;
    }

    private static final boolean processInvokeInterface$isTestPrivateInterfaceMethod(Method method) {
        return Intrinsics.areEqual(method.getName(), System.getProperty("plugin.verifier.test.private.interface.method.name"));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Instruction.values().length];
            try {
                nArray[Instruction.INVOKE_VIRTUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_SPECIAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_INTERFACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_STATIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

