/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.properties;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/jetbrains/pluginverifier/usages/properties/DeprecatedPropertyUsageWarning;", "Lcom/jetbrains/pluginverifier/warnings/CompatibilityWarning;", "propertyKey", "", "originalResourceBundle", "deprecatedResourceBundle", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "getDeprecatedResourceBundle", "()Ljava/lang/String;", "fullDescription", "getFullDescription", "getOriginalResourceBundle", "problemType", "getProblemType", "getPropertyKey", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class DeprecatedPropertyUsageWarning
extends CompatibilityWarning {
    @NotNull
    private final String propertyKey;
    @NotNull
    private final String originalResourceBundle;
    @NotNull
    private final String deprecatedResourceBundle;
    @NotNull
    private final Location usageLocation;

    public DeprecatedPropertyUsageWarning(@NotNull String propertyKey, @NotNull String originalResourceBundle, @NotNull String deprecatedResourceBundle, @NotNull Location usageLocation) {
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(originalResourceBundle, "originalResourceBundle");
        Intrinsics.checkNotNullParameter(deprecatedResourceBundle, "deprecatedResourceBundle");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.propertyKey = propertyKey;
        this.originalResourceBundle = originalResourceBundle;
        this.deprecatedResourceBundle = deprecatedResourceBundle;
        this.usageLocation = usageLocation;
    }

    @NotNull
    public final String getPropertyKey() {
        return this.propertyKey;
    }

    @NotNull
    public final String getOriginalResourceBundle() {
        return this.originalResourceBundle;
    }

    @NotNull
    public final String getDeprecatedResourceBundle() {
        return this.deprecatedResourceBundle;
    }

    @NotNull
    public final Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Reference to a deprecated property of resource bundle was moved";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.propertyKey, this.originalResourceBundle, this.deprecatedResourceBundle};
        return FormatUtilsKt.formatMessage("Reference to a deprecated property ''{0}'' of resource bundle ''{1}'', which was moved to ''{2}''", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{StringsKt.capitalize(this.usageLocation.getElementType().getPresentableName()), this.usageLocation, this.propertyKey, this.originalResourceBundle, this.deprecatedResourceBundle};
        return FormatUtilsKt.formatMessage("{0} {1} references deprecated property ''{2}'' that was moved from the resource bundle ''{3}'' to ''{4}''. The clients will continue to get the correct value of the property but they are encouraged to place the property to their own resource bundle.", objectArray);
    }

    @NotNull
    public final String component1() {
        return this.propertyKey;
    }

    @NotNull
    public final String component2() {
        return this.originalResourceBundle;
    }

    @NotNull
    public final String component3() {
        return this.deprecatedResourceBundle;
    }

    @NotNull
    public final Location component4() {
        return this.usageLocation;
    }

    @NotNull
    public final DeprecatedPropertyUsageWarning copy(@NotNull String propertyKey, @NotNull String originalResourceBundle, @NotNull String deprecatedResourceBundle, @NotNull Location usageLocation) {
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(originalResourceBundle, "originalResourceBundle");
        Intrinsics.checkNotNullParameter(deprecatedResourceBundle, "deprecatedResourceBundle");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        return new DeprecatedPropertyUsageWarning(propertyKey, originalResourceBundle, deprecatedResourceBundle, usageLocation);
    }

    public static /* synthetic */ DeprecatedPropertyUsageWarning copy$default(DeprecatedPropertyUsageWarning deprecatedPropertyUsageWarning, String string2, String string3, String string4, Location location, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = deprecatedPropertyUsageWarning.propertyKey;
        }
        if ((n & 2) != 0) {
            string3 = deprecatedPropertyUsageWarning.originalResourceBundle;
        }
        if ((n & 4) != 0) {
            string4 = deprecatedPropertyUsageWarning.deprecatedResourceBundle;
        }
        if ((n & 8) != 0) {
            location = deprecatedPropertyUsageWarning.usageLocation;
        }
        return deprecatedPropertyUsageWarning.copy(string2, string3, string4, location);
    }

    public int hashCode() {
        int result2 = this.propertyKey.hashCode();
        result2 = result2 * 31 + this.originalResourceBundle.hashCode();
        result2 = result2 * 31 + this.deprecatedResourceBundle.hashCode();
        result2 = result2 * 31 + this.usageLocation.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeprecatedPropertyUsageWarning)) {
            return false;
        }
        DeprecatedPropertyUsageWarning deprecatedPropertyUsageWarning = (DeprecatedPropertyUsageWarning)other;
        if (!Intrinsics.areEqual(this.propertyKey, deprecatedPropertyUsageWarning.propertyKey)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.originalResourceBundle, deprecatedPropertyUsageWarning.originalResourceBundle)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.deprecatedResourceBundle, deprecatedPropertyUsageWarning.deprecatedResourceBundle)) {
            return false;
        }
        return Intrinsics.areEqual(this.usageLocation, deprecatedPropertyUsageWarning.usageLocation);
    }
}

