/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.javaPlugin;

import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.javaPlugin.JavaPluginClassUsage;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/usages/javaPlugin/UndeclaredDependencyOnJavaPluginProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "javaPluginClassUsages", "", "Lcom/jetbrains/pluginverifier/usages/javaPlugin/JavaPluginClassUsage;", "(Ljava/util/Set;)V", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getJavaPluginClassUsages", "()Ljava/util/Set;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nUndeclaredDependencyOnJavaPluginProblem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndeclaredDependencyOnJavaPluginProblem.kt\ncom/jetbrains/pluginverifier/usages/javaPlugin/UndeclaredDependencyOnJavaPluginProblem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1855#2,2:40\n*S KotlinDebug\n*F\n+ 1 UndeclaredDependencyOnJavaPluginProblem.kt\ncom/jetbrains/pluginverifier/usages/javaPlugin/UndeclaredDependencyOnJavaPluginProblem\n*L\n23#1:40,2\n*E\n"})
public final class UndeclaredDependencyOnJavaPluginProblem
extends CompatibilityProblem {
    @NotNull
    private final Set<JavaPluginClassUsage> javaPluginClassUsages;

    public UndeclaredDependencyOnJavaPluginProblem(@NotNull Set<JavaPluginClassUsage> javaPluginClassUsages) {
        Intrinsics.checkNotNullParameter(javaPluginClassUsages, "javaPluginClassUsages");
        this.javaPluginClassUsages = javaPluginClassUsages;
    }

    public /* synthetic */ UndeclaredDependencyOnJavaPluginProblem(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new HashSet();
        }
        this(set);
    }

    @NotNull
    public final Set<JavaPluginClassUsage> getJavaPluginClassUsages() {
        return this.javaPluginClassUsages;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return this.getShortDescription();
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Dependency on Java plugin is not specified";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$_get_fullDescription__u24lambda_u243.append("Plugin uses classes of Java plugin, for example");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                JavaPluginClassUsage it = (JavaPluginClassUsage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getUsedClass().getClassName());
                it = (JavaPluginClassUsage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getUsedClass().getClassName()));
            }
        };
        List deterministicUsages = CollectionsKt.sortedWith((Iterable)this.javaPluginClassUsages, new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    JavaPluginClassUsage it = (JavaPluginClassUsage)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getUsageLocation().getPresentableLocation());
                    it = (JavaPluginClassUsage)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getUsageLocation().getPresentableLocation()));
                }
                return n;
            }
        });
        Iterable $this$forEach$iv = CollectionsKt.take(deterministicUsages, 3);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JavaPluginClassUsage usage2 = (JavaPluginClassUsage)element$iv;
            boolean bl2 = false;
            $this$_get_fullDescription__u24lambda_u243.append("'" + LocationsPresentationKt.formatClassLocation(usage2.getUsedClass(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS) + "'");
            $this$_get_fullDescription__u24lambda_u243.append(" is used at ");
            $this$_get_fullDescription__u24lambda_u243.append("'" + UsageLocationPresentationKt.formatUsageLocation(usage2.getUsageLocation()) + "'");
            Intrinsics.checkNotNullExpressionValue($this$_get_fullDescription__u24lambda_u243.append('\n'), "append('\\n')");
        }
        StringBuilder stringBuilder3 = $this$_get_fullDescription__u24lambda_u243.append("but the plugin does not declare explicit dependency on the Java plugin, via <depends>com.intellij.modules.java</depends>. ");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
        StringBuilder stringBuilder4 = $this$_get_fullDescription__u24lambda_u243.append("Java functionality was extracted from the IntelliJ Platform to a separate plugin in IDEA 2019.2. ");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
        StringBuilder stringBuilder5 = $this$_get_fullDescription__u24lambda_u243.append("For more info refer to https://blog.jetbrains.com/platform/2019/06/java-functionality-extracted-as-a-plugin");
        Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof UndeclaredDependencyOnJavaPluginProblem && Intrinsics.areEqual(this.javaPluginClassUsages, ((UndeclaredDependencyOnJavaPluginProblem)other).javaPluginClassUsages);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.javaPluginClassUsages};
        return Objects.hash(objectArray);
    }

    public UndeclaredDependencyOnJavaPluginProblem() {
        this(null, 1, null);
    }
}

