/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.internal;

import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsage;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/InternalMethodOverridden;", "Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsage;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "usageLocation", "(Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class InternalMethodOverridden
extends InternalApiUsage {
    @NotNull
    private final MethodLocation apiElement;
    @NotNull
    private final MethodLocation usageLocation;

    public InternalMethodOverridden(@NotNull MethodLocation apiElement, @NotNull MethodLocation usageLocation) {
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public MethodLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public MethodLocation getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Internal method is overridden";
    }

    @Override
    @NotNull
    public MethodReference getApiReference() {
        return LocationToReferenceKt.toReference(this.getApiElement());
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Internal method " + LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.NO_RETURN_TYPE, MethodParameterNameOption.NO_PARAMETER_NAMES) + " is overridden";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("Internal method " + LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE));
        $this$_get_fullDescription__u24lambda_u240.append(" is overridden in class " + LocationsPresentationKt.formatClassLocation(this.getUsageLocation().getHostClass(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS));
        $this$_get_fullDescription__u24lambda_u240.append(". This method is marked with @org.jetbrains.annotations.ApiStatus.Internal annotation or @com.intellij.openapi.util.IntellijInternalApi annotation and indicates that the method is not supposed to be used in client code.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof InternalMethodOverridden && Intrinsics.areEqual(this.getApiElement(), ((InternalMethodOverridden)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((InternalMethodOverridden)other).getUsageLocation());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiElement(), this.getUsageLocation()};
        return Objects.hash(objectArray);
    }
}

