/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.internal;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.PluginVerificationDescriptor;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.usages.FilteringApiUsageProcessor;
import com.jetbrains.pluginverifier.usages.SamePluginUsageFilter;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsageKt;
import com.jetbrains.pluginverifier.usages.internal.InternalClassUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalFieldUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalFusApiUsageCompatibilityProblem;
import com.jetbrains.pluginverifier.usages.internal.InternalMethodUsage;
import com.jetbrains.pluginverifier.verifiers.PluginVerificationContext;
import com.jetbrains.pluginverifier.verifiers.ProblemRegistrar;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassUsageType;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolver;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import com.jetbrains.pluginverifier.warnings.WarningRegistrar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J(\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J0\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsageProcessor;", "Lcom/jetbrains/pluginverifier/usages/FilteringApiUsageProcessor;", "pluginVerificationContext", "Lcom/jetbrains/pluginverifier/verifiers/PluginVerificationContext;", "(Lcom/jetbrains/pluginverifier/verifiers/PluginVerificationContext;)V", "doProcessClassReference", "", "classReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "resolvedClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "referrer", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileMember;", "classUsageType", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassUsageType;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "doProcessFieldAccess", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "resolvedField", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "doProcessMethodInvocation", "invokedMethodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "invokedMethod", "invocationInstruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "isInternal", "", "resolvedMember", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "registerInternalApiUsage", "usage", "Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsage;", "ClassFileWithNoMethodsWrapper", "VerificationContextWithSilentProblemRegistrar", "verifier-intellij"})
public final class InternalApiUsageProcessor
extends FilteringApiUsageProcessor {
    @NotNull
    private final PluginVerificationContext pluginVerificationContext;

    public InternalApiUsageProcessor(@NotNull PluginVerificationContext pluginVerificationContext) {
        Intrinsics.checkNotNullParameter(pluginVerificationContext, "pluginVerificationContext");
        super(new SamePluginUsageFilter());
        this.pluginVerificationContext = pluginVerificationContext;
    }

    private final boolean isInternal(ClassFileMember resolvedMember, VerificationContext context, Location usageLocation) {
        return InternalApiUsageKt.isInternalApi(resolvedMember, context.getClassResolver(), usageLocation);
    }

    @Override
    protected void doProcessClassReference(@NotNull ClassReference classReference, @NotNull ClassFile resolvedClass, @NotNull ClassFileMember referrer, @NotNull ClassUsageType classUsageType, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(classReference, "classReference");
        Intrinsics.checkNotNullParameter(resolvedClass, "resolvedClass");
        Intrinsics.checkNotNullParameter(referrer, "referrer");
        Intrinsics.checkNotNullParameter((Object)classUsageType, "classUsageType");
        Intrinsics.checkNotNullParameter(context, "context");
        Location usageLocation = referrer.getLocation();
        if (this.isInternal(resolvedClass, context, usageLocation)) {
            this.registerInternalApiUsage(new InternalClassUsage(classReference, resolvedClass.getLocation(), usageLocation));
        }
    }

    @Override
    protected void doProcessMethodInvocation(@NotNull MethodReference invokedMethodReference, @NotNull Method invokedMethod, @NotNull AbstractInsnNode invocationInstruction, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(invokedMethodReference, "invokedMethodReference");
        Intrinsics.checkNotNullParameter(invokedMethod, "invokedMethod");
        Intrinsics.checkNotNullParameter(invocationInstruction, "invocationInstruction");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isInternal(invokedMethod, context, usageLocation)) {
            Method overriddenMethod;
            boolean canBeOverridden;
            boolean bl = canBeOverridden = !invokedMethod.isStatic() && !invokedMethod.isPrivate() && !Intrinsics.areEqual(invokedMethod.getName(), "<init>") && !Intrinsics.areEqual(invokedMethod.getName(), "<clinit>");
            Method method = canBeOverridden ? new MethodResolver().resolveMethod(new ClassFileWithNoMethodsWrapper(invokedMethod.getContainingClassFile()), LocationToReferenceKt.toReference(invokedMethod.getLocation()), invokedMethod.getContainingClassFile().isInterface() ? Instruction.INVOKE_INTERFACE : Instruction.INVOKE_VIRTUAL, invokedMethod, new VerificationContextWithSilentProblemRegistrar(context)) : (overriddenMethod = null);
            if (overriddenMethod == null || this.isInternal(overriddenMethod, context, usageLocation)) {
                this.registerInternalApiUsage(new InternalMethodUsage(invokedMethodReference, invokedMethod.getLocation(), usageLocation));
            }
        }
    }

    @Override
    protected void doProcessFieldAccess(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(resolvedField, "resolvedField");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isInternal(resolvedField, context, usageLocation)) {
            this.registerInternalApiUsage(new InternalFieldUsage(fieldReference, resolvedField.getLocation(), usageLocation));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void registerInternalApiUsage(InternalApiUsage usage2) {
        if (StringsKt.startsWith$default(usage2.getApiElement().getContainingClass().getPackageName(), "com/intellij/internal/statistic", false, 2, null)) {
            String string2 = this.pluginVerificationContext.getIdePlugin().getVendor();
            if (!(string2 != null ? StringsKt.contains((CharSequence)string2, "JetBrains", true) : false) && this.pluginVerificationContext.getVerificationDescriptor() instanceof PluginVerificationDescriptor.IDE && ((PluginVerificationDescriptor.IDE)this.pluginVerificationContext.getVerificationDescriptor()).getIdeVersion().getBaselineVersion() >= 211) {
                this.pluginVerificationContext.registerProblem(new InternalFusApiUsageCompatibilityProblem(usage2));
                return;
            }
        }
        this.pluginVerificationContext.registerInternalApiUsage(usage2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0001X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0012\u0010\u001f\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0012\u0010\"\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!R\u0012\u0010#\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020 8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010!R\u0012\u0010%\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u0012\u0010&\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010!R\u0012\u0010'\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010!R\u0012\u0010(\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010!R\u0012\u0010)\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u0012\u0010*\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010!R\u0012\u0010+\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010!R\u0012\u0010,\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010!R\u0012\u0010-\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u0012\u0010/\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u000204X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001a\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001cR\u0012\u0010:\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0017R\u0014\u0010<\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0017R\u0012\u0010>\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0017R\u0014\u0010@\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0017R\u0014\u0010B\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0017\u00a8\u0006D"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsageProcessor$ClassFileWithNoMethodsWrapper;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "classFile", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;)V", "accessType", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getAccessType", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "getAnnotations", "()Ljava/util/List;", "classFileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getClassFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "containingClassFile", "getContainingClassFile", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "enclosingClassName", "", "getEnclosingClassName", "()Ljava/lang/String;", "fields", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "getFields", "()Lkotlin/sequences/Sequence;", "interfaces", "getInterfaces", "isAbstract", "", "()Z", "isDeprecated", "isFinal", "isInnerClass", "isInterface", "isPackagePrivate", "isPrivate", "isProtected", "isPublic", "isStatic", "isSuperFlag", "isSynthetic", "javaPackageName", "getJavaPackageName", "javaVersion", "", "getJavaVersion", "()I", "location", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getLocation", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "methods", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "getMethods", "name", "getName", "nestHostClass", "getNestHostClass", "packageName", "getPackageName", "signature", "getSignature", "superName", "getSuperName", "verifier-intellij"})
    private static final class ClassFileWithNoMethodsWrapper
    implements ClassFile {
        @NotNull
        private final ClassFile classFile;

        public ClassFileWithNoMethodsWrapper(@NotNull ClassFile classFile) {
            Intrinsics.checkNotNullParameter(classFile, "classFile");
            this.classFile = classFile;
        }

        @Override
        @NotNull
        public AccessType getAccessType() {
            return this.classFile.getAccessType();
        }

        @Override
        @NotNull
        public List<AnnotationNode> getAnnotations() {
            return this.classFile.getAnnotations();
        }

        @Override
        @NotNull
        public FileOrigin getClassFileOrigin() {
            return this.classFile.getClassFileOrigin();
        }

        @Override
        @NotNull
        public ClassFile getContainingClassFile() {
            return this.classFile.getContainingClassFile();
        }

        @Override
        @Nullable
        public String getEnclosingClassName() {
            return this.classFile.getEnclosingClassName();
        }

        @Override
        @NotNull
        public Sequence<Field> getFields() {
            return this.classFile.getFields();
        }

        @Override
        @NotNull
        public List<String> getInterfaces() {
            return this.classFile.getInterfaces();
        }

        @Override
        public boolean isAbstract() {
            return this.classFile.isAbstract();
        }

        @Override
        public boolean isDeprecated() {
            return this.classFile.isDeprecated();
        }

        @Override
        public boolean isFinal() {
            return this.classFile.isFinal();
        }

        @Override
        public boolean isInnerClass() {
            return this.classFile.isInnerClass();
        }

        @Override
        public boolean isInterface() {
            return this.classFile.isInterface();
        }

        @Override
        public boolean isPackagePrivate() {
            return this.classFile.isPackagePrivate();
        }

        @Override
        public boolean isPrivate() {
            return this.classFile.isPrivate();
        }

        @Override
        public boolean isProtected() {
            return this.classFile.isProtected();
        }

        @Override
        public boolean isPublic() {
            return this.classFile.isPublic();
        }

        @Override
        public boolean isStatic() {
            return this.classFile.isStatic();
        }

        @Override
        public boolean isSuperFlag() {
            return this.classFile.isSuperFlag();
        }

        @Override
        public boolean isSynthetic() {
            return this.classFile.isSynthetic();
        }

        @Override
        @NotNull
        public String getJavaPackageName() {
            return this.classFile.getJavaPackageName();
        }

        @Override
        public int getJavaVersion() {
            return this.classFile.getJavaVersion();
        }

        @Override
        @NotNull
        public ClassLocation getLocation() {
            return this.classFile.getLocation();
        }

        @Override
        @NotNull
        public String getName() {
            return this.classFile.getName();
        }

        @Override
        @Nullable
        public String getNestHostClass() {
            return this.classFile.getNestHostClass();
        }

        @Override
        @NotNull
        public String getPackageName() {
            return this.classFile.getPackageName();
        }

        @Override
        @Nullable
        public String getSignature() {
            return this.classFile.getSignature();
        }

        @Override
        @Nullable
        public String getSuperName() {
            return this.classFile.getSuperName();
        }

        @Override
        @NotNull
        public Sequence<Method> getMethods() {
            return SequencesKt.emptySequence();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsageProcessor$VerificationContextWithSilentProblemRegistrar;", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "delegate", "(Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;)V", "apiUsageProcessors", "", "Lcom/jetbrains/pluginverifier/usages/ApiUsageProcessor;", "getApiUsageProcessors", "()Ljava/util/List;", "classResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "getClassResolver", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "externalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "getExternalClassesPackageFilter", "()Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "problemRegistrar", "Lcom/jetbrains/pluginverifier/verifiers/ProblemRegistrar;", "getProblemRegistrar", "()Lcom/jetbrains/pluginverifier/verifiers/ProblemRegistrar;", "warningRegistrar", "Lcom/jetbrains/pluginverifier/warnings/WarningRegistrar;", "getWarningRegistrar", "()Lcom/jetbrains/pluginverifier/warnings/WarningRegistrar;", "verifier-intellij"})
    private static final class VerificationContextWithSilentProblemRegistrar
    implements VerificationContext {
        @NotNull
        private final VerificationContext delegate;
        @NotNull
        private final ProblemRegistrar problemRegistrar;
        @NotNull
        private final WarningRegistrar warningRegistrar;

        public VerificationContextWithSilentProblemRegistrar(@NotNull VerificationContext delegate) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            this.delegate = delegate;
            this.problemRegistrar = new ProblemRegistrar(){

                public void registerProblem(@NotNull CompatibilityProblem problem) {
                    Intrinsics.checkNotNullParameter(problem, "problem");
                }
            };
            this.warningRegistrar = new WarningRegistrar(){

                public void registerCompatibilityWarning(@NotNull CompatibilityWarning warning) {
                    Intrinsics.checkNotNullParameter(warning, "warning");
                }
            };
        }

        @Override
        @NotNull
        public List<ApiUsageProcessor> getApiUsageProcessors() {
            return this.delegate.getApiUsageProcessors();
        }

        @Override
        @NotNull
        public Resolver getClassResolver() {
            return this.delegate.getClassResolver();
        }

        @Override
        @NotNull
        public PackageFilter getExternalClassesPackageFilter() {
            return this.delegate.getExternalClassesPackageFilter();
        }

        @Override
        @NotNull
        public ProblemRegistrar getProblemRegistrar() {
            return this.problemRegistrar;
        }

        @Override
        @NotNull
        public WarningRegistrar getWarningRegistrar() {
            return this.warningRegistrar;
        }
    }
}

