/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.processAllPlugins;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.ExecutorWithProgress;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginContentDescriptor;
import com.jetbrains.pluginverifier.PluginVerifierRunKt;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.tasks.Task;
import com.jetbrains.pluginverifier.tasks.TaskResult;
import com.jetbrains.pluginverifier.tasks.processAllPlugins.CountUsagesOfExtensionPointsParameters;
import com.jetbrains.pluginverifier.tasks.processAllPlugins.CountUsagesOfExtensionPointsTask;
import com.jetbrains.pluginverifier.tasks.processAllPlugins.CountUsagesOfExtensionPointsTaskResult;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask;", "Lcom/jetbrains/pluginverifier/tasks/Task;", "params", "Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsParameters;", "(Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsParameters;)V", "execute", "Lcom/jetbrains/pluginverifier/tasks/TaskResult;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "ProcessingOutcome", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nCountUsagesOfExtensionPointsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountUsagesOfExtensionPointsTask.kt\ncom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n1271#2,2:104\n1285#2,4:106\n1549#2:110\n1620#2,3:111\n766#2:114\n857#2,2:115\n*S KotlinDebug\n*F\n+ 1 CountUsagesOfExtensionPointsTask.kt\ncom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask\n*L\n42#1:100\n42#1:101,3\n42#1:104,2\n42#1:106,4\n43#1:110\n43#1:111,3\n57#1:114\n57#1:115,2\n*E\n"})
public final class CountUsagesOfExtensionPointsTask
implements Task {
    @NotNull
    private final CountUsagesOfExtensionPointsParameters params;

    public CountUsagesOfExtensionPointsTask(@NotNull CountUsagesOfExtensionPointsParameters params) {
        Intrinsics.checkNotNullParameter(params, "params");
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskResult execute(@NotNull PluginVerificationReportage reportage, @NotNull PluginDetailsCache pluginDetailsCache) {
        void $this$mapTo$iv$iv;
        void $this$associateWith$iv;
        String it;
        Object object;
        void $this$mapTo$iv$iv2;
        Object object2;
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        ArrayList ideAndPluginsExtensionPoints = new ArrayList();
        for (IdePlugin idePlugin : this.params.getIdeDescriptor().getIde().getBundledPlugins()) {
            CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getAppContainerDescriptor().getExtensionPoints());
            CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getProjectContainerDescriptor().getExtensionPoints());
            CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getModuleContainerDescriptor().getExtensionPoints());
        }
        for (PluginInfo additionalIdePluginInfo : this.params.getAdditionalIdePlugins()) {
            Closeable closeable = pluginDetailsCache.getPluginDetailsCacheEntry(additionalIdePluginInfo);
            object2 = null;
            try {
                Object cacheResult = (PluginDetailsCache.Result)closeable;
                boolean bl = false;
                if (cacheResult instanceof PluginDetailsCache.Result.Provided) {
                    Iterator idePlugin = ((PluginDetailsCache.Result.Provided)cacheResult).getPluginDetails().getIdePlugin();
                    CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getAppContainerDescriptor().getExtensionPoints());
                    CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getProjectContainerDescriptor().getExtensionPoints());
                    CollectionsKt.addAll((Collection)ideAndPluginsExtensionPoints, (Iterable)idePlugin.getModuleContainerDescriptor().getExtensionPoints());
                }
                cacheResult = Unit.INSTANCE;
            }
            catch (Throwable cacheResult) {
                object2 = cacheResult;
                throw cacheResult;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
            }
        }
        Iterable $this$map$iv = ideAndPluginsExtensionPoints;
        boolean $i$f$map = false;
        object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IdePluginContentDescriptor.ExtensionPoint extensionPoint2 = (IdePluginContentDescriptor.ExtensionPoint)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((IdePluginContentDescriptor.ExtensionPoint)((Object)it)).getExtensionPointName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = 0;
            object.put(t2, n);
        }
        Map map2 = result$iv;
        ConcurrentHashMap extensionPointUsages = new ConcurrentHashMap(map2);
        Iterable $this$map$iv2 = this.params.getCompatiblePluginsList();
        boolean $i$f$map2 = false;
        $this$associateWithTo$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void plugin;
            PluginInfo bl = (PluginInfo)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new ExecutorWithProgress.Task<ProcessingOutcome>(String.valueOf(plugin), () -> CountUsagesOfExtensionPointsTask.execute$lambda$7$lambda$6(pluginDetailsCache, (PluginInfo)plugin, extensionPointUsages)));
        }
        List tasks2 = (List)destination$iv$iv2;
        ExecutorWithProgress executor2 = new ExecutorWithProgress("processAllPlugins [countUsagesOfExtensionPoints]", PluginVerifierRunKt.getConcurrencyLevel(), false, (Function1)new Function1<ExecutorWithProgress.ProgressData<ProcessingOutcome>, Unit>(reportage){
            final /* synthetic */ PluginVerificationReportage $reportage;
            {
                this.$reportage = $reportage;
                super(1);
            }

            public final void invoke(@NotNull ExecutorWithProgress.ProgressData<ProcessingOutcome> progressData) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter(progressData, "progressData");
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append("Finished #" + progressData.getFinishedNumber() + " of " + progressData.getTotalNumber() + ": ");
                if (progressData.getException() != null) {
                    Throwable throwable = progressData.getException();
                    Intrinsics.checkNotNull(throwable);
                    $this$invoke_u24lambda_u240.append("[error] [ " + throwable.getMessage() + " ]");
                } else {
                    ProcessingOutcome processingOutcome = progressData.getResult();
                    Intrinsics.checkNotNull(processingOutcome);
                    ProcessingOutcome result2 = processingOutcome;
                    if (result2 instanceof ProcessingOutcome.Success) {
                        $this$invoke_u24lambda_u240.append("[success]");
                    } else if (result2 instanceof ProcessingOutcome.Failed) {
                        $this$invoke_u24lambda_u240.append("[bad plugin] [" + ((ProcessingOutcome.Failed)result2).getReason() + "]");
                    }
                }
                $this$invoke_u24lambda_u240.append(progressData.getTask().getPresentableName());
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
                String message2 = string2;
                this.$reportage.logVerificationStage(message2);
            }
        });
        executor2.executeTasks(tasks2);
        return new CountUsagesOfExtensionPointsTaskResult(extensionPointUsages, this.params.getOutputJson());
    }

    private static final Integer execute$lambda$7$lambda$6$lambda$5$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final ProcessingOutcome execute$lambda$7$lambda$6(PluginDetailsCache $pluginDetailsCache, PluginInfo $plugin, ConcurrentHashMap $extensionPointUsages) {
        ProcessingOutcome processingOutcome;
        Intrinsics.checkNotNullParameter($pluginDetailsCache, "$pluginDetailsCache");
        Intrinsics.checkNotNullParameter($plugin, "$plugin");
        Intrinsics.checkNotNullParameter($extensionPointUsages, "$extensionPointUsages");
        Closeable closeable = $pluginDetailsCache.getPluginDetailsCacheEntry($plugin);
        Throwable throwable = null;
        try {
            ProcessingOutcome processingOutcome2;
            PluginDetailsCache.Result cacheResult = (PluginDetailsCache.Result)closeable;
            boolean bl = false;
            PluginDetailsCache.Result result2 = cacheResult;
            if (result2 instanceof PluginDetailsCache.Result.Provided) {
                for (Map.Entry<String, List<Element>> entry : ((PluginDetailsCache.Result.Provided)cacheResult).getPluginDetails().getIdePlugin().getExtensions().entrySet()) {
                    String extensionPointName = entry.getKey();
                    List<Element> elements = entry.getValue();
                    $extensionPointUsages.compute(extensionPointName, (arg_0, arg_1) -> CountUsagesOfExtensionPointsTask.execute$lambda$7$lambda$6$lambda$5$lambda$3(new Function2<String, Integer, Integer>(elements){
                        final /* synthetic */ List<Element> $elements;
                        {
                            this.$elements = $elements;
                            super(2);
                        }

                        @Nullable
                        public final Integer invoke(String string2, @Nullable Integer count2) {
                            Integer n = count2;
                            return n == null ? null : Integer.valueOf(n + this.$elements.size());
                        }
                    }, arg_0, arg_1));
                }
                processingOutcome2 = ProcessingOutcome.Success.INSTANCE;
            } else if (result2 instanceof PluginDetailsCache.Result.Failed) {
                processingOutcome2 = new ProcessingOutcome.Failed(((PluginDetailsCache.Result.Failed)cacheResult).getReason());
            } else if (result2 instanceof PluginDetailsCache.Result.FileNotFound) {
                processingOutcome2 = new ProcessingOutcome.Failed(((PluginDetailsCache.Result.FileNotFound)cacheResult).getReason());
            } else if (result2 instanceof PluginDetailsCache.Result.InvalidPlugin) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((PluginDetailsCache.Result.InvalidPlugin)cacheResult).getPluginErrors();
                boolean $i$f$filter = false;
                Iterable extensionPointName = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String string2 = "Invalid plugin: " + CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, execute.tasks.1.1.1.3.INSTANCE, 31, null);
                processingOutcome2 = new ProcessingOutcome.Failed(string2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            processingOutcome = processingOutcome2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return processingOutcome;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome;", "", "()V", "Failed", "Success", "Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome$Failed;", "Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome$Success;", "verifier-cli"})
    private static abstract class ProcessingOutcome {
        private ProcessingOutcome() {
        }

        public /* synthetic */ ProcessingOutcome(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome$Failed;", "Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "verifier-cli"})
        public static final class Failed
        extends ProcessingOutcome {
            @NotNull
            private final String reason;

            public Failed(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Failed copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                return new Failed(reason);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = failed.reason;
                }
                return failed.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Failed(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual(this.reason, failed.reason);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome$Success;", "Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/CountUsagesOfExtensionPointsTask$ProcessingOutcome;", "()V", "verifier-cli"})
        public static final class Success
        extends ProcessingOutcome {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
                super(null);
            }
        }
    }
}

