/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.reference;

import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.SymbolicReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "Lcom/jetbrains/pluginverifier/results/reference/SymbolicReference;", "hostClass", "", "methodName", "methodDescriptor", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "(Lcom/jetbrains/pluginverifier/results/reference/ClassReference;Ljava/lang/String;Ljava/lang/String;)V", "getHostClass", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getMethodDescriptor", "()Ljava/lang/String;", "getMethodName", "presentableLocation", "getPresentableLocation", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class MethodReference
extends SymbolicReference {
    @NotNull
    private final ClassReference hostClass;
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDescriptor;

    public MethodReference(@NotNull ClassReference hostClass, @NotNull String methodName, @NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        super(null);
        this.hostClass = hostClass;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    @NotNull
    public final ClassReference getHostClass() {
        return this.hostClass;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public MethodReference(@NotNull String hostClass, @NotNull String methodName, @NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        this(new ClassReference(hostClass), methodName, methodDescriptor);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MethodReference && Intrinsics.areEqual(this.hostClass, ((MethodReference)other).hostClass) && Intrinsics.areEqual(this.methodName, ((MethodReference)other).methodName) && Intrinsics.areEqual(this.methodDescriptor, ((MethodReference)other).methodDescriptor);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.hostClass, this.methodName, this.methodDescriptor};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        return ReferencesPresentationKt.formatMethodReference(this, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME);
    }

    @NotNull
    public final ClassReference component1() {
        return this.hostClass;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @NotNull
    public final String component3() {
        return this.methodDescriptor;
    }

    @NotNull
    public final MethodReference copy(@NotNull ClassReference hostClass, @NotNull String methodName, @NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        return new MethodReference(hostClass, methodName, methodDescriptor);
    }

    public static /* synthetic */ MethodReference copy$default(MethodReference methodReference, ClassReference classReference, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            classReference = methodReference.hostClass;
        }
        if ((n & 2) != 0) {
            string2 = methodReference.methodName;
        }
        if ((n & 4) != 0) {
            string3 = methodReference.methodDescriptor;
        }
        return methodReference.copy(classReference, string2, string3);
    }
}

