/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/InvalidClassFileProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "invalidClass", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "usage", "Lcom/jetbrains/pluginverifier/results/location/Location;", "message", "", "(Lcom/jetbrains/pluginverifier/results/reference/ClassReference;Lcom/jetbrains/pluginverifier/results/location/Location;Ljava/lang/String;)V", "fullDescription", "getFullDescription", "()Ljava/lang/String;", "getInvalidClass", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getMessage", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsage", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class InvalidClassFileProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassReference invalidClass;
    @NotNull
    private final Location usage;
    @NotNull
    private final String message;

    public InvalidClassFileProblem(@NotNull ClassReference invalidClass, @NotNull Location usage2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter(invalidClass, "invalidClass");
        Intrinsics.checkNotNullParameter(usage2, "usage");
        Intrinsics.checkNotNullParameter(message2, "message");
        this.invalidClass = invalidClass;
        this.usage = usage2;
        this.message = message2;
    }

    @NotNull
    public final ClassReference getInvalidClass() {
        return this.invalidClass;
    }

    @NotNull
    public final Location getUsage() {
        return this.usage;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Invalid class file";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.invalidClass};
        return FormatUtilsKt.formatMessage("Invalid class-file {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.invalidClass, this.usage, this.message};
        return FormatUtilsKt.formatMessage("Class {0} referenced in {1} cannot be read: {2}. You may try to recompile the class-file. Invalid classes can lead to **ClassFormatError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof InvalidClassFileProblem && Intrinsics.areEqual(this.invalidClass, ((InvalidClassFileProblem)other).invalidClass) && Intrinsics.areEqual(this.usage, ((InvalidClassFileProblem)other).usage);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.invalidClass, this.usage};
        return Objects.hash(objectArray);
    }
}

