/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.resources;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.repository.cleanup.UsageStatistic;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import com.jetbrains.pluginverifier.repository.resources.AvailableResource;
import com.jetbrains.pluginverifier.repository.resources.EvictionInfo;
import com.jetbrains.pluginverifier.repository.resources.EvictionPolicy;
import com.jetbrains.pluginverifier.repository.resources.LoggerUtilsKt;
import com.jetbrains.pluginverifier.repository.resources.RepositoryResourcesRegistrar;
import com.jetbrains.pluginverifier.repository.resources.ResourceInfo;
import com.jetbrains.pluginverifier.repository.resources.ResourceLock;
import com.jetbrains.pluginverifier.repository.resources.ResourceLockImpl;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepository;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryResult;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.io.Closeable;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u000e\b\u0002\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005Bu\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00028\u0002\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00028\u00012\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00028\u00012\u0006\u0010,\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010/\u001a\u00020\u0010H\u0016J\u0015\u00100\u001a\u00020\u00102\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00101J\u001b\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00103J!\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002052\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00028\u000108H\u0016J \u00109\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020;0:H\u0016J!\u0010<\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002052\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00106J\u0015\u0010=\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010>J\u0015\u0010?\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010>J\u0015\u0010@\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010>J\u0015\u0010A\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010>J!\u0010B\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020C2\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010DJ'\u0010E\u001a\u00020\u00102\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dH\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010>J\b\u0010I\u001a\u00020\u0010H\u0016J\b\u0010J\u001a\u00020\u0012H\u0016J\u0015\u0010K\u001a\u00020L2\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010MJ+\u0010N\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000205*\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010ORB\u0010\u0014\u001a6\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u00160\u0015j\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u0016`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a0\u0015j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u001b\u001aN\u0012\u0004\u0012\u00028\u0001\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001d0\u001c0\u0015j&\u0012\u0004\u0012\u00028\u0001\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001d0\u001c`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00028\u00010#j\b\u0012\u0004\u0012\u00028\u0001`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u001e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020(0\u0015j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020(`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl;", "R", "K", "W", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepository;", "evictionPolicy", "Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;", "clock", "Ljava/time/Clock;", "resourceProvider", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "initialWeight", "weigher", "Lkotlin/Function1;", "disposer", "", "presentableName", "", "(Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;Ljava/time/Clock;Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "additionTasks", "Ljava/util/HashMap;", "Ljava/util/concurrent/FutureTask;", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "Lkotlin/collections/HashMap;", "additionWaitingThreads", "", "key2Locks", "", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceLockImpl;", "logger", "Lorg/slf4j/Logger;", "nextLockId", "", "removeQueue", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "resourcesRegistrar", "Lcom/jetbrains/pluginverifier/repository/resources/RepositoryResourcesRegistrar;", "statistics", "Lcom/jetbrains/pluginverifier/repository/cleanup/UsageStatistic;", "add", "", "key", "resource", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "addResource", "cleanup", "doRemove", "(Ljava/lang/Object;)V", "fetchAndAddResource", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "get", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryResult;", "getAllExistingKeys", "", "getAvailableResources", "", "Lcom/jetbrains/pluginverifier/repository/resources/AvailableResource;", "getOrWait", "has", "(Ljava/lang/Object;)Z", "isBeingProvided", "isLockedKey", "isLockedOrBeingProvided", "registerLock", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceLock;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/resources/ResourceLock;", "releaseLock", "lock", "releaseLock$verifier_repository", "remove", "removeAll", "toString", "updateUsageStatistics", "Ljava/time/Instant;", "(Ljava/lang/Object;)Ljava/time/Instant;", "registerLockIfProvided", "(Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryResult;", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nResourceRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceRepositoryImpl.kt\ncom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,294:1\n1855#2,2:295\n1549#2:315\n1620#2,3:316\n2661#2,7:319\n361#3,7:297\n361#3,7:304\n125#4:311\n152#4,3:312\n70#5,5:326\n*S KotlinDebug\n*F\n+ 1 ResourceRepositoryImpl.kt\ncom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl\n*L\n103#1:295,2\n250#1:315\n250#1:316,3\n250#1:319,7\n114#1:297,7\n130#1:304,7\n237#1:311\n237#1:312,3\n286#1:326,5\n*E\n"})
public final class ResourceRepositoryImpl<R, K, W extends ResourceWeight<W>>
implements ResourceRepository<R, K, W> {
    @NotNull
    private final EvictionPolicy<R, K, W> evictionPolicy;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ResourceProvider<K, R> resourceProvider;
    @NotNull
    private final String presentableName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final RepositoryResourcesRegistrar<R, K, W> resourcesRegistrar;
    private long nextLockId;
    @NotNull
    private final HashMap<K, Set<ResourceLockImpl<R, K, W>>> key2Locks;
    @NotNull
    private final HashSet<K> removeQueue;
    @NotNull
    private final HashMap<K, FutureTask<ProvideResult<R>>> additionTasks;
    @NotNull
    private final HashMap<K, Integer> additionWaitingThreads;
    @NotNull
    private final HashMap<K, UsageStatistic> statistics;

    public ResourceRepositoryImpl(@NotNull EvictionPolicy<R, K, W> evictionPolicy, @NotNull Clock clock, @NotNull ResourceProvider<? super K, ? extends R> resourceProvider, @NotNull W initialWeight, @NotNull Function1<? super R, ? extends W> weigher, @NotNull Function1<? super R, Unit> disposer, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(evictionPolicy, "evictionPolicy");
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(resourceProvider, "resourceProvider");
        Intrinsics.checkNotNullParameter(initialWeight, "initialWeight");
        Intrinsics.checkNotNullParameter(weigher, "weigher");
        Intrinsics.checkNotNullParameter(disposer, "disposer");
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.evictionPolicy = evictionPolicy;
        this.clock = clock;
        this.resourceProvider = resourceProvider;
        this.presentableName = presentableName2;
        Logger logger = LoggerFactory.getLogger(this.presentableName);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(presentableName)");
        this.logger = logger;
        this.resourcesRegistrar = new RepositoryResourcesRegistrar(initialWeight, weigher, disposer, this.logger);
        this.key2Locks = new HashMap();
        this.removeQueue = new HashSet();
        this.additionTasks = new HashMap();
        this.additionWaitingThreads = new HashMap();
        this.statistics = new HashMap();
    }

    public /* synthetic */ ResourceRepositoryImpl(EvictionPolicy evictionPolicy, Clock clock, ResourceProvider resourceProvider, ResourceWeight resourceWeight, Function1 function1, Function1 function12, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            string2 = "ResourceRepository";
        }
        this(evictionPolicy, clock, resourceProvider, resourceWeight, function1, function12, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(K key, R resource) {
        boolean bl;
        try {
            bl = this.addResource(key, resource);
        }
        finally {
            this.cleanup();
        }
        return bl;
    }

    private final synchronized boolean addResource(K key, R resource) {
        if (this.resourcesRegistrar.addResource(key, resource)) {
            if (!(!((Map)this.statistics).containsKey(key))) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            this.updateUsageStatistics(key);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public synchronized Set<K> getAllExistingKeys() {
        return CollectionsKt.toSet((Iterable)this.resourcesRegistrar.getAllKeys());
    }

    @Override
    public synchronized boolean has(K key) {
        return this.resourcesRegistrar.has(key);
    }

    @Override
    public synchronized boolean isLockedOrBeingProvided(K key) {
        return this.isLockedKey(key) || this.isBeingProvided(key);
    }

    @Override
    public synchronized boolean remove(K key) {
        boolean bl;
        if (this.isLockedOrBeingProvided(key)) {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                final /* synthetic */ K $key;
                {
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "remove(" + this.$key + "): the resource is locked or is being provided, enqueue for removing later.";
                }
            });
            this.removeQueue.add(key);
            bl = false;
        } else if (this.resourcesRegistrar.has(key)) {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                final /* synthetic */ K $key;
                {
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "remove(" + this.$key + "): the resource is not locked, deleting now";
                }
            });
            this.doRemove(key);
            this.cleanup();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public synchronized void removeAll() {
        Iterable $this$forEach$iv = this.getAllExistingKeys();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.remove(it);
        }
    }

    private final synchronized boolean isLockedKey(K key) {
        return this.key2Locks.containsKey(key);
    }

    private final synchronized boolean isBeingProvided(K key) {
        return this.additionTasks.containsKey(key);
    }

    private final Instant updateUsageStatistics(K key) {
        Object object;
        Instant now = this.clock.instant();
        Map $this$getOrPut$iv = this.statistics;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(now, "now");
            UsageStatistic answer$iv = new UsageStatistic(now, 0L);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        UsageStatistic usageStatistic = (UsageStatistic)object;
        Intrinsics.checkNotNullExpressionValue(now, "now");
        usageStatistic.setLastAccessTime(now);
        long l = usageStatistic.getTimesAccessed();
        usageStatistic.setTimesAccessed(l + 1L);
        return now;
    }

    private final synchronized ResourceLock<R, W> registerLock(K key) {
        Object object;
        if (!this.resourcesRegistrar.has(key)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        ResourceInfo<R, W> resourceInfo = this.resourcesRegistrar.get(key);
        Intrinsics.checkNotNull(resourceInfo);
        ResourceInfo<R, W> resourceInfo2 = resourceInfo;
        Instant now = this.updateUsageStatistics(key);
        long l = this.nextLockId;
        this.nextLockId = l + 1L;
        long lockId = l;
        ResourceLockImpl<R, K, W> lock = new ResourceLockImpl<R, K, W>(now, resourceInfo2, key, lockId, this);
        LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, lock){
            final /* synthetic */ K $key;
            final /* synthetic */ ResourceLockImpl<R, K, W> $lock;
            {
                this.$key = $key;
                this.$lock = $lock;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "get(" + this.$key + "): lock is registered " + this.$lock + " ";
            }
        });
        Map $this$getOrPut$iv = this.key2Locks;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(lock);
        return lock;
    }

    public final synchronized void releaseLock$verifier_repository(@NotNull ResourceLockImpl<R, K, W> lock) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        K key = lock.getKey();
        Set<ResourceLockImpl<R, K, W>> resourceLocks = this.key2Locks.get(key);
        if (resourceLocks != null) {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(lock){
                final /* synthetic */ ResourceLockImpl<R, K, W> $lock;
                {
                    this.$lock = $lock;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "releasing lock " + this.$lock;
                }
            });
            resourceLocks.remove(lock);
            if (resourceLocks.isEmpty()) {
                this.key2Locks.remove(key);
                if (this.removeQueue.contains(key)) {
                    if (this.isBeingProvided(key)) {
                        LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                            final /* synthetic */ K $key;
                            {
                                this.$key = $key;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "hand over removing of the " + this.$key + " to another thread waiting for this key";
                            }
                        });
                    } else {
                        LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                            final /* synthetic */ K $key;
                            {
                                this.$key = $key;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "removing the " + this.$key + " as it is enqueued for removing and it has been just released";
                            }
                        });
                        this.removeQueue.remove(key);
                        this.doRemove(key);
                    }
                }
            }
        } else {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(lock){
                final /* synthetic */ ResourceLockImpl<R, K, W> $lock;
                {
                    this.$lock = $lock;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "attempt to release an unregistered lock " + this.$lock;
                }
            });
        }
    }

    private final synchronized void doRemove(K key) {
        if (!(!this.isBeingProvided(key))) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        this.resourcesRegistrar.removeResource(key);
        this.statistics.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceRepositoryResult<R, W> getOrWait(K key) throws InterruptedException {
        Pair<FutureTask<ProvideResult<R>>, Boolean> pair;
        LanguageUtilsKt.checkIfInterrupted();
        ResourceRepositoryImpl resourceRepositoryImpl = this;
        synchronized (resourceRepositoryImpl) {
            Pair<FutureTask<ProvideResult<R>>, Boolean> pair2;
            block21: {
                boolean bl = false;
                if (!this.resourcesRegistrar.has(key)) break block21;
                ResourceLock<R, W> lock = this.registerLock(key);
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, lock){
                    final /* synthetic */ K $key;
                    final /* synthetic */ ResourceLock<R, W> $lock;
                    {
                        this.$key = $key;
                        this.$lock = $lock;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): the resource is available and a lock is registered " + this.$lock;
                    }
                });
                ResourceRepositoryResult resourceRepositoryResult = new ResourceRepositoryResult.Found<R, W>(lock);
                return resourceRepositoryResult;
            }
            FutureTask<ProvideResult<R>> oldTask = this.additionTasks.get(key);
            this.additionWaitingThreads.compute(key, (arg_0, arg_1) -> ResourceRepositoryImpl.getOrWait$lambda$5$lambda$3(getOrWait.1.2.INSTANCE, arg_0, arg_1));
            if (oldTask != null) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): waiting for another thread to finish fetching the resource";
                    }
                });
                pair2 = TuplesKt.to(oldTask, false);
            } else {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): fetching the resource in the current thread";
                    }
                });
                FutureTask<ProvideResult> newTask = new FutureTask<ProvideResult>(() -> ResourceRepositoryImpl.getOrWait$lambda$5$lambda$4(this, key));
                ((Map)this.additionTasks).put(key, newTask);
                pair2 = TuplesKt.to(newTask, true);
            }
            pair = pair2;
        }
        Pair<FutureTask<ProvideResult<R>>, Boolean> pair3 = pair;
        FutureTask<ProvideResult<R>> fetchTask = pair3.component1();
        boolean runInCurrentThread = pair3.component2();
        if (runInCurrentThread) {
            fetchTask.run();
        }
        try {
            ResourceRepositoryResult<R, W> resourceRepositoryResult;
            try {
                resourceRepositoryResult = fetchTask.get();
            }
            catch (CancellationException ce) {
                throw new InterruptedException("Fetch task for " + key + " has been cancelled");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw new RuntimeException("Failed to fetch result", e);
            }
            ResourceRepositoryResult<R, W> provideResult = resourceRepositoryResult;
            Intrinsics.checkNotNullExpressionValue(provideResult, "provideResult");
            resourceRepositoryResult = this.registerLockIfProvided((ProvideResult<? extends R>)((Object)provideResult), key);
            return resourceRepositoryResult;
        }
        finally {
            ResourceRepositoryImpl e = this;
            synchronized (e) {
                boolean bl = false;
                this.additionWaitingThreads.compute(key, (arg_0, arg_1) -> ResourceRepositoryImpl.getOrWait$lambda$7$lambda$6(getOrWait.2.1.INSTANCE, arg_0, arg_1));
                if (!this.additionWaitingThreads.containsKey(key)) {
                    this.additionTasks.remove(key);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final ProvideResult<R> fetchAndAddResource(K key) {
        ProvideResult<R> provideResult = this.resourceProvider.provide(key);
        if (provideResult instanceof ProvideResult.Provided) {
            this.addResource(key, ((ProvideResult.Provided)provideResult).getResource());
        }
        return provideResult;
    }

    private final ResourceRepositoryResult<R, W> registerLockIfProvided(ProvideResult<? extends R> $this$registerLockIfProvided, K key) {
        ResourceRepositoryResult resourceRepositoryResult;
        ProvideResult<? extends R> provideResult = $this$registerLockIfProvided;
        if (provideResult instanceof ProvideResult.Provided) {
            resourceRepositoryResult = new ResourceRepositoryResult.Found<R, W>(this.registerLock(key));
        } else if (provideResult instanceof ProvideResult.NotFound) {
            resourceRepositoryResult = new ResourceRepositoryResult.NotFound(((ProvideResult.NotFound)$this$registerLockIfProvided).getReason());
        } else if (provideResult instanceof ProvideResult.Failed) {
            resourceRepositoryResult = new ResourceRepositoryResult.Failed(((ProvideResult.Failed)$this$registerLockIfProvided).getReason(), ((ProvideResult.Failed)$this$registerLockIfProvided).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resourceRepositoryResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized List<AvailableResource<R, K, W>> getAvailableResources() {
        void $this$mapTo$iv$iv;
        Map<K, ResourceInfo<R, W>> $this$map$iv = this.resourcesRegistrar.getResources();
        boolean $i$f$map = false;
        Map<K, ResourceInfo<R, W>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object key = entry.getKey();
            ResourceInfo resourceInfo = (ResourceInfo)entry.getValue();
            UsageStatistic usageStatistic = this.statistics.get(key);
            Intrinsics.checkNotNull(usageStatistic);
            collection.add(new AvailableResource(key, resourceInfo, usageStatistic, this.isLockedKey(key)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void cleanup() {
        if (this.evictionPolicy.isNecessary(this.resourcesRegistrar.getTotalWeight())) {
            List<AvailableResource<R, K, W>> availableResources = this.getAvailableResources();
            EvictionInfo<R, K, W> evictionInfo = new EvictionInfo<R, K, W>(this.resourcesRegistrar.getTotalWeight(), availableResources);
            List<AvailableResource<R, K, W>> resourcesForEviction = this.evictionPolicy.selectResourcesForEviction(evictionInfo);
            if (!((Collection)resourcesForEviction).isEmpty()) {
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = resourcesForEviction;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AvailableResource availableResource = (AvailableResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getResourceInfo().getWeight());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void weight;
                    ResourceWeight $i$f$mapTo2 = (ResourceWeight)iterator$iv.next();
                    ResourceWeight acc = (ResourceWeight)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.plus(weight);
                }
                ResourceWeight disposedTotalWeight = (ResourceWeight)accumulator$iv;
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(this, resourcesForEviction, disposedTotalWeight){
                    final /* synthetic */ ResourceRepositoryImpl<R, K, W> this$0;
                    final /* synthetic */ List<AvailableResource<R, K, W>> $resourcesForEviction;
                    final /* synthetic */ W $disposedTotalWeight;
                    {
                        this.this$0 = $receiver;
                        this.$resourcesForEviction = $resourcesForEviction;
                        this.$disposedTotalWeight = $disposedTotalWeight;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "It's time to evict unused resources. Total weight: " + ResourceRepositoryImpl.access$getResourcesRegistrar$p(this.this$0).getTotalWeight() + ". " + this.$resourcesForEviction.size() + " " + FormatUtilsKt.pluralize("resource", this.$resourcesForEviction.size()) + " will be evicted with total weight " + this.$disposedTotalWeight;
                    }
                });
                for (AvailableResource<R, K, W> resource : resourcesForEviction) {
                    this.remove(resource.getKey());
                }
            }
        }
    }

    @Override
    @NotNull
    public ResourceRepositoryResult<R, W> get(K key) throws InterruptedException {
        ResourceRepositoryResult<R, W> result2 = this.getOrWait(key);
        Object object = result2 instanceof ResourceRepositoryResult.Found ? (ResourceRepositoryResult.Found)result2 : null;
        if (object != null && (object = ((ResourceRepositoryResult.Found)object).getLockedResource()) != null) {
            Closeable $this$closeOnException$iv = (Closeable)object;
            boolean $i$f$closeOnException = false;
            try {
                ResourceLock it = (ResourceLock)$this$closeOnException$iv;
                boolean bl = false;
                this.cleanup();
            }
            catch (Throwable e$iv) {
                LanguageUtilsKt.closeLogged($this$closeOnException$iv);
                throw e$iv;
            }
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return this.presentableName;
    }

    private static final Integer getOrWait$lambda$5$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final ProvideResult getOrWait$lambda$5$lambda$4(ResourceRepositoryImpl this$0, Object $key) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.fetchAndAddResource($key);
    }

    private static final Integer getOrWait$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ RepositoryResourcesRegistrar access$getResourcesRegistrar$p(ResourceRepositoryImpl $this) {
        return $this.resourcesRegistrar;
    }
}

